%macro export_func 1
   global _%1
   _%1:
%endmacro
%define USE_SECTIONS
%define SAMPLE_RATE	44100
%define MAX_INSTRUMENTS	12
%define MAX_VOICES 1
%define HLD 1
%define BPM 80.000000
%define MAX_PATTERNS 37
%define PATTERN_SIZE_SHIFT 4
%define PATTERN_SIZE (1 << PATTERN_SIZE_SHIFT)
%define	MAX_TICKS (MAX_PATTERNS*PATTERN_SIZE)
%define	SAMPLES_PER_TICK 8268
%define DEF_LFO_NORMALIZE 0.0000302343
%define	MAX_SAMPLES	(SAMPLES_PER_TICK*MAX_TICKS)
;%define 	GO4K_USE_16BIT_OUTPUT
;%define 	GO4K_USE_GROOVE_PATTERN
;%define 	GO4K_USE_ENVELOPE_RECORDINGS
;%define 	GO4K_USE_NOTE_RECORDINGS
%define 	GO4K_CLIP_OUTPUT
%define 	GO4K_USE_DST
%define 	GO4K_USE_DLL
%define 	GO4K_USE_PAN
%define 	GO4K_USE_GLOBAL_DLL
%define 	GO4K_USE_ENV_CHECK
%define 	GO4K_USE_VCO_CHECK
%define 	GO4K_USE_VCO_PHASE_OFFSET
%define 	GO4K_USE_VCO_SHAPE
%define		GO4K_USE_VCO_GATE
%define 	GO4K_USE_VCO_MOD_PM
%define		GO4K_USE_VCO_STEREO
%define 	GO4K_USE_VCF_CHECK
%define 	GO4K_USE_VCF_MOD_FM
%define 	GO4K_USE_VCF_HIGH
%define 	GO4K_USE_VCF_BAND
%define 	GO4K_USE_VCF_PEAK
%define		GO4K_USE_VCF_STEREO
%define 	GO4K_USE_DST_CHECK
%define 	GO4K_USE_DST_SH
%define		GO4K_USE_DST_STEREO
%define		GO4K_USE_DLL_CHORUS
%define		GO4K_USE_DLL_CHORUS_CLAMP
%define 	GO4K_USE_DLL_DAMP
%define 	GO4K_USE_DLL_DC_FILTER
%define 	GO4K_USE_FSTG_CHECK
%define		GO4K_USE_WAVESHAPER_CLIP
%define	MAX_DELAY			65536
%define MAX_UNITS			48
%define	MAX_UNIT_SLOTS	    9
%define GO4K_BEGIN_CMDDEF(def_name)
%define GO4K_END_CMDDEF db 0
%define GO4K_BEGIN_PARAMDEF(def_name)
%define GO4K_END_PARAMDEF
GO4K_ENV_ID		equ		1
%macro	GO4K_ENV 5
	db	%1
	db	%2
	db	%3
	db	%4
	db	%5
%endmacro
%define	ATTAC(val)		val	
%define	DECAY(val)		val	
%define	SUSTAIN(val)	val	
%define	RELEASE(val)	val	
%define	GAIN(val)		val	
struc	go4kENV_val
	.attac		resd	1
	.decay		resd	1
	.sustain	resd	1
	.release	resd	1
	.gain		resd	1
	.size
endstruc
struc	go4kENV_wrk
	.state		resd	1
	.level		resd	1
	.gm			resd	1
	.am			resd	1
	.dm			resd	1
	.sm			resd	1
	.rm			resd	1
	.size
endstruc
%define ENV_STATE_ATTAC		0
%define ENV_STATE_DECAY		1
%define ENV_STATE_SUSTAIN	2
%define ENV_STATE_RELEASE	3
%define ENV_STATE_OFF		4
GO4K_VCO_ID		equ		2
%macro	GO4K_VCO 8
	db	%1
	db	%2
%ifdef GO4K_USE_VCO_PHASE_OFFSET	
	db	%3
%endif	
%ifdef GO4K_USE_VCO_GATE	
	db	%4
%endif	
	db	%5
%ifdef GO4K_USE_VCO_SHAPE	
	db	%6
%endif	
	db	%7
	db	%8
%endmacro
%define	TRANSPOSE(val)	val	
%define	DETUNE(val)		val	
%define	PHASE(val)		val	
%define	GATES(val)		val	
%define	COLOR(val)		val	
%define	SHAPE(val)		val 
%define	FLAGS(val)		val	
%define SINE		0x01
%define TRISAW		0x02
%define PULSE		0x04
%define NOISE		0x08
%define LFO			0x10
%define GATE		0x20
%define	VCO_STEREO	0x40
struc	go4kVCO_val
	.transpose	resd	1
	.detune		resd	1
%ifdef GO4K_USE_VCO_PHASE_OFFSET	
	.phaseofs	resd	1
%endif	
%ifdef GO4K_USE_VCO_GATE	
	.gate		resd	1
%endif	
	.color		resd	1
%ifdef GO4K_USE_VCO_SHAPE	
	.shape		resd	1
%endif	
	.gain		resd	1
	.flags		resd	1	
	.size
endstruc
struc	go4kVCO_wrk
	.phase		resd	1
	.tm			resd	1
	.dm			resd	1
	.fm			resd	1
	.pm			resd	1
	.cm			resd	1
	.sm			resd	1
	.gm			resd	1
	.phase2		resd	1
	.size
endstruc
GO4K_VCF_ID		equ		3
%macro	GO4K_VCF 3
	db	%1
	db	%2
	db	%3
%endmacro
%define LOWPASS		0x1
%define HIGHPASS	0x2
%define BANDPASS	0x4
%define	BANDSTOP	0x3
%define ALLPASS		0x7
%define	PEAK		0x8
%define STEREO		0x10
%define	FREQUENCY(val)	val
%define	RESONANCE(val)	val
%define	VCFTYPE(val)	val
struc	go4kVCF_val
	.freq		resd	1
	.res		resd	1
	.type		resd	1
	.size
endstruc
struc	go4kVCF_wrk
	.low		resd	1
	.high		resd	1
	.band		resd	1
	.freq		resd	1
	.fm			resd	1
	.rm			resd	1
	.low2		resd	1
	.high2		resd	1
	.band2		resd	1
	.size
endstruc
GO4K_DST_ID		equ		4
%macro	GO4K_DST 3
	db	%1
%ifdef GO4K_USE_DST_SH
	db	%2
%ifdef GO4K_USE_DST_STEREO
	db	%3
%endif
%else
%ifdef GO4K_USE_DST_STEREO
	db	%3
%endif
%endif
%endmacro
%define	DRIVE(val)		val
%define	SNHFREQ(val)	val
%define	FLAGS(val)		val
struc	go4kDST_val
	.drive		resd	1
%ifdef GO4K_USE_DST_SH	
	.snhfreq	resd	1
%endif	
	.flags		resd	1
	.size
endstruc
struc	go4kDST_wrk
	.out		resd	1
	.snhphase	resd	1
	.dm			resd	1
	.sm			resd	1
	.out2		resd	1
	.size
endstruc
GO4K_DLL_ID		equ		5
%macro	GO4K_DLL 8
	db	%1
	db	%2
	db	%3
%ifdef GO4K_USE_DLL_DAMP	
	db	%4
%endif		
%ifdef GO4K_USE_DLL_CHORUS	
	db	%5
	db	%6
%endif
	db	%7
	db	%8
%endmacro
%define PREGAIN(val)	val
%define	DRY(val)		val
%define	FEEDBACK(val)	val
%define	DEPTH(val)		val
%define DAMP(val)		val
%define	DELAY(val)		val
%define	COUNT(val)		val
struc	go4kDLL_val
	.pregain	resd	1
	.dry		resd	1
	.feedback	resd	1
%ifdef GO4K_USE_DLL_DAMP	
	.damp		resd	1	
%endif
%ifdef GO4K_USE_DLL_CHORUS
	.freq		resd	1
	.depth
%endif
	.delay		resd	1
	.count		resd	1
	.size
endstruc
struc	go4kDLL_wrk
	.index		resd	1
	.store		resd	1
	.dcin		resd	1
	.dcout		resd	1
%ifdef GO4K_USE_DLL_CHORUS
	.phase		resd	1
%endif
	.buffer		resd	MAX_DELAY
	.size
endstruc
struc	go4kDLL_wrk2
 .pm			resd	1
 .fm			resd	1
 .im			resd	1
 .dm			resd	1
 .sm			resd	1
 .am			resd	1
 .size
endstruc
GO4K_FOP_ID	equ			6
%macro	GO4K_FOP 1
	db	%1
%endmacro
%define	OP(val)			val
%define FOP_POP			0x1
%define FOP_ADDP		0x2
%define FOP_MULP		0x3
%define FOP_PUSH		0x4
%define FOP_XCH			0x5
%define FOP_ADD			0x6
%define FOP_MUL			0x7
%define FOP_ADDP2		0x8
%define FOP_LOADNOTE	0x9
%define FOP_MULP2		0xa
struc	go4kFOP_val
	.flags		resd	1
	.size
endstruc
struc	go4kFOP_wrk
	.size
endstruc
GO4K_FST_ID		equ		7
%macro	GO4K_FST 2
	db	%1
	dw	%2
%endmacro
%define	AMOUNT(val)		val
%define	DEST(val)		val
%define	FST_SET			0x0000
%define	FST_ADD			0x4000
%define	FST_POP			0x8000
struc	go4kFST_val
	.amount		resd	1
	.op1		resd	1
	.size
endstruc
struc	go4kFST_wrk
	.size
endstruc
GO4K_PAN_ID		equ		8
%macro	GO4K_PAN 1
%ifdef GO4K_USE_PAN
	db	%1
%endif
%endmacro
%define	PANNING(val)	val
struc	go4kPAN_val
%ifdef GO4K_USE_PAN
	.panning	resd	1
%endif
	.size
endstruc
struc	go4kPAN_wrk
	.pm			resd	1
	.size
endstruc
GO4K_OUT_ID		equ		9
%macro	GO4K_OUT 2
	db	%1
%ifdef GO4K_USE_GLOBAL_DLL	
	db	%2
%endif	
%endmacro
%define	AUXSEND(val)	val
struc	go4kOUT_val
	.gain		resd	1
%ifdef GO4K_USE_GLOBAL_DLL	
	.auxsend	resd	1
%endif
	.size
endstruc
struc	go4kOUT_wrk
	.am			resd	1
	.gm			resd	1
	.size
endstruc
GO4K_ACC_ID		equ		10
%macro	GO4K_ACC 1
	db	%1
%endmacro
%define OUTPUT			0
%define	AUX				8
%define ACCTYPE(val)	val
struc	go4kACC_val
	.acctype	resd	1
	.size
endstruc
struc	go4kACC_wrk
	.size
endstruc
%ifdef GO4K_USE_FLD
GO4K_FLD_ID	equ		11
%macro	GO4K_FLD 1
	db	%1
%endmacro
%define	VALUE(val)	val
struc	go4kFLD_val
	.value		resd	1
	.size
endstruc
struc	go4kFLD_wrk
	.vm			resd	1
	.size
endstruc
%endif
%ifdef GO4K_USE_FSTG
GO4K_FSTG_ID	equ		12
%macro	GO4K_FSTG 2
	db	%1
	dw	%2
%endmacro
struc	go4kFSTG_val
	.amount		resd	1
	.op1		resd	1
	.size
endstruc
struc	go4kFSTG_wrk
	.size
endstruc
%endif
struc	go4k_instrument
	.release	resd	1
	.note		resd	1
	.workspace	resd	MAX_UNITS*MAX_UNIT_SLOTS
	.dlloutl	resd	1
	.dlloutr	resd	1
	.outl		resd	1
	.outr		resd	1
	.size
endstruc
struc	go4k_synth
	.instruments	resb	go4k_instrument.size * MAX_INSTRUMENTS * MAX_VOICES
	.global			resb	go4k_instrument.size * MAX_VOICES
	.size
endstruc
%ifdef USE_SECTIONS
section .g4kmuc1 data align=1
%else
section .data align=1
%endif
go4k_patterns
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	83, 0, 0, 83, 0, 0, 83, 0, 83, 0, 0, 0, 0, 83, 0, 0, 
	db	0, 59, 0, 0, 59, 0, 0, 59, 0, 59, 0, 0, 0, 0, 59, 0, 
	db	60, 48, 59, 64, 60, 48, 59, 64, 60, 48, 59, 64, 60, 48, 59, 64, 
	db	62, 50, 59, 66, 62, 50, 59, 66, 62, 50, 59, 66, 62, 50, 59, 66, 
	db	62, 52, 59, 66, 62, 52, 59, 66, 62, 52, 59, 66, 62, 52, 59, 66, 
	db	62, 47, 59, 66, 62, 47, 59, 66, 62, 47, 59, 66, 62, 47, 59, 66, 
	db	60, 45, 59, 64, 60, 45, 59, 64, 60, 45, 59, 64, 60, 45, 59, 64, 
	db	64, 52, 59, 66, 64, 52, 59, 66, 64, 52, 59, 66, 64, 52, 59, 66, 
	db	40, 52, 59, 66, 40, 52, 59, 66, 40, 52, 59, 66, 40, 52, 59, 66, 
	db	67, 0, 0, 71, 67, 0, 0, 71, 67, 0, 0, 71, 67, 0, 0, 71, 
	db	69, 0, 0, 71, 69, 0, 0, 71, 69, 0, 0, 71, 69, 0, 0, 71, 
	db	68, 0, 0, 71, 68, 0, 0, 71, 68, 0, 0, 71, 68, 0, 0, 71, 
	db	71, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	67, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	69, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	68, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	64, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	66, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	60, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	62, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	48, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	52, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	47, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	45, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	50, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	36, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	40, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	35, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	33, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	38, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	95, 91, 84, 60, 79, 72, 48, 67, 60, 91, 84, 60, 79, 72, 48, 67, 
	db	60, 91, 84, 60, 79, 72, 48, 67, 60, 91, 84, 60, 79, 72, 48, 67, 
	db	60, 93, 86, 64, 81, 74, 52, 69, 62, 93, 86, 64, 81, 74, 52, 69, 
	db	62, 93, 86, 64, 81, 74, 52, 69, 62, 93, 86, 64, 81, 74, 52, 69, 
	db	62, 91, 84, 60, 79, 72, 48, 67, 60, 91, 84, 60, 79, 72, 48, 67, 
	db	60, 93, 86, 59, 81, 74, 47, 69, 62, 93, 86, 59, 81, 74, 47, 69, 
	db	62, 93, 86, 59, 81, 74, 47, 69, 62, 93, 86, 59, 81, 74, 47, 69, 
	db	62, 91, 84, 57, 79, 72, 45, 67, 60, 91, 84, 57, 79, 72, 45, 67, 
	db	60, 91, 84, 57, 79, 72, 45, 67, 60, 91, 84, 57, 79, 72, 45, 67, 
	db	60, 93, 86, 62, 81, 74, 50, 69, 62, 93, 86, 62, 81, 74, 50, 69, 
	db	62, 93, 86, 62, 81, 74, 50, 69, 62, 93, 86, 62, 81, 74, 50, 69, 
	db	62, 93, 88, 64, 81, 76, 52, 69, 64, 93, 88, 64, 81, 76, 52, 69, 
	db	64, 93, 88, 64, 81, 76, 52, 69, 64, 93, 88, 64, 81, 76, 52, 69, 
	db	64, 93, 88, 64, 80, 76, 52, 68, 64, 93, 88, 64, 80, 76, 52, 68, 
	db	64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
go4k_patterns_end
%ifdef USE_SECTIONS
section .g4kmuc2 data align=1
%else
section .data
%endif
go4k_pattern_lists
Instrument0List		db	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
Instrument1List		db	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 
Instrument2List		db	0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 3, 3, 5, 5, 3, 3, 6, 6, 7, 7, 4, 4, 8, 8, 9, 9, 0, 0, 0, 0, 0, 
Instrument3List		db	0, 0, 0, 0, 10, 10, 10, 10, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 11, 11, 12, 12, 0, 0, 0, 0, 0, 
Instrument4List		db	0, 0, 0, 0, 0, 0, 0, 0, 13, 14, 14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 0, 0, 0, 0, 0, 
Instrument5List		db	0, 0, 0, 0, 0, 0, 0, 0, 15, 14, 16, 14, 15, 14, 16, 14, 15, 14, 16, 14, 15, 14, 16, 14, 15, 14, 16, 14, 14, 14, 17, 14, 0, 0, 0, 0, 0, 
Instrument6List		db	0, 0, 0, 0, 0, 0, 0, 0, 18, 14, 19, 14, 18, 14, 19, 14, 18, 14, 19, 14, 18, 14, 19, 14, 18, 14, 19, 14, 14, 14, 14, 14, 0, 0, 0, 0, 0, 
Instrument7List		db	0, 0, 0, 0, 0, 0, 0, 0, 20, 14, 21, 14, 20, 14, 21, 14, 20, 14, 21, 14, 20, 14, 21, 14, 20, 14, 21, 14, 18, 14, 14, 14, 0, 0, 0, 0, 0, 
Instrument8List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 14, 23, 14, 22, 14, 24, 14, 25, 14, 26, 14, 23, 14, 14, 14, 0, 0, 0, 0, 0, 
Instrument9List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 14, 28, 14, 27, 14, 29, 14, 30, 14, 31, 14, 28, 14, 14, 14, 0, 0, 0, 0, 0, 
Instrument10List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 14, 23, 14, 22, 14, 24, 14, 25, 14, 26, 14, 23, 14, 14, 14, 0, 0, 0, 0, 0, 
Instrument11List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 34, 35, 36, 33, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46, 0, 0, 0, 0, 
go4k_pattern_lists_end
%ifdef USE_SECTIONS
section .g4kmuc3 data align=1
%else
section .data
%endif
go4k_synth_instructions
GO4K_BEGIN_CMDDEF(Instrument0)
	db GO4K_ENV_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_DST_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument1)
	db GO4K_ENV_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_DST_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument2)
	db GO4K_ENV_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_DST_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument3)
	db GO4K_ENV_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_DST_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument4)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument5)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument6)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument7)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument8)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument9)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument10)
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_FST_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_VCF_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument11)
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_ENV_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Global)
	db GO4K_ACC_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_ACC_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
go4k_synth_instructions_end
%ifdef USE_SECTIONS
section .g4kmuc4 data align=1
%else
section .data
%endif
go4k_synth_parameter_values
GO4K_BEGIN_PARAMDEF(Instrument0)
	GO4K_ENV	ATTAC(64),DECAY(73),SUSTAIN(22),RELEASE(79),GAIN(128)
	GO4K_DST	DRIVE(30), SNHFREQ(128), FLAGS(0)
	GO4K_FST	AMOUNT(92),DEST(26*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_DST	DRIVE(78), SNHFREQ(71), FLAGS(0)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(58),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(88),DETUNE(61),PHASE(8),GATES(0),COLOR(37),SHAPE(16),GAIN(128),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(18*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(68),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(72),PHASE(32),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_FOP	OP(FOP_POP)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS|STEREO)
	GO4K_DLL	PREGAIN(104),DRY(57),FEEDBACK(93),DAMP(3),FREQUENCY(22),DEPTH(18),DELAY(17),COUNT(1)
	GO4K_OUT	GAIN(45), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument1)
	GO4K_ENV	ATTAC(64),DECAY(70),SUSTAIN(35),RELEASE(46),GAIN(128)
	GO4K_DST	DRIVE(30), SNHFREQ(128), FLAGS(0)
	GO4K_FST	AMOUNT(92),DEST(26*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_DST	DRIVE(78), SNHFREQ(71), FLAGS(0)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(58),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(88),DETUNE(61),PHASE(8),GATES(0),COLOR(37),SHAPE(16),GAIN(128),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(18*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(76),DETUNE(68),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(76),DETUNE(72),PHASE(32),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_FOP	OP(FOP_POP)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS|STEREO)
	GO4K_DLL	PREGAIN(104),DRY(57),FEEDBACK(93),DAMP(3),FREQUENCY(22),DEPTH(18),DELAY(17),COUNT(1)
	GO4K_OUT	GAIN(66), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument2)
	GO4K_ENV	ATTAC(21),DECAY(79),SUSTAIN(51),RELEASE(89),GAIN(128)
	GO4K_DST	DRIVE(29), SNHFREQ(128), FLAGS(0)
	GO4K_FST	AMOUNT(90),DEST(27*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(90),DEST(29*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_DST	DRIVE(127), SNHFREQ(128), FLAGS(0)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(9*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(58),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(19*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(68),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(72),PHASE(32),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_FOP	OP(FOP_POP)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(94),DRY(113),FEEDBACK(111),DAMP(14),FREQUENCY(128),DEPTH(3),DELAY(1),COUNT(8)
	GO4K_OUT	GAIN(41), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument3)
	GO4K_ENV	ATTAC(28),DECAY(66),SUSTAIN(27),RELEASE(44),GAIN(128)
	GO4K_DST	DRIVE(45), SNHFREQ(128), FLAGS(0)
	GO4K_FST	AMOUNT(90),DEST(27*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(90),DEST(29*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_DST	DRIVE(127), SNHFREQ(128), FLAGS(0)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(9*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(58),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(128),DEST(19*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(68),PHASE(0),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCO	TRANSPOSE(64),DETUNE(72),PHASE(32),GATES(0),COLOR(128),SHAPE(64),GAIN(64),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_MUL)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_FOP	OP(FOP_POP)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_VCF	FREQUENCY(0),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_DLL	PREGAIN(94),DRY(113),FEEDBACK(111),DAMP(14),FREQUENCY(128),DEPTH(3),DELAY(9),COUNT(8)
	GO4K_OUT	GAIN(79), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument4)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(69),PHASE(19),GATES(56),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(75),PHASE(17),GATES(192),COLOR(1),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(81),PHASE(13),GATES(14),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(28),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(47),DRY(128),FEEDBACK(80),DAMP(22),FREQUENCY(11),DEPTH(16),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(0)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(11),GATES(192),COLOR(1),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(57),PHASE(7),GATES(0),COLOR(224),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(51),PHASE(5),GATES(128),COLOR(3),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(56),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(103),DRY(128),FEEDBACK(110),DAMP(8),FREQUENCY(6),DEPTH(17),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(128)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_LOADNOTE)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(128),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(83), SNHFREQ(128), FLAGS(STEREO)
	GO4K_OUT	GAIN(110), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument5)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(69),PHASE(19),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(75),PHASE(17),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(81),PHASE(13),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(73),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(44),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(47),DRY(128),FEEDBACK(80),DAMP(22),FREQUENCY(11),DEPTH(16),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(0)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(11),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(57),PHASE(7),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(51),PHASE(5),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(103),DRY(128),FEEDBACK(110),DAMP(8),FREQUENCY(6),DEPTH(17),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(128)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_LOADNOTE)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(128),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(68), SNHFREQ(128), FLAGS(STEREO)
	GO4K_OUT	GAIN(110), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument6)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(69),PHASE(19),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(75),PHASE(17),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(81),PHASE(13),GATES(7),COLOR(224),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(47),DRY(128),FEEDBACK(80),DAMP(22),FREQUENCY(11),DEPTH(16),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(0)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(11),GATES(7),COLOR(28),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(57),PHASE(7),GATES(7),COLOR(7),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(51),PHASE(5),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(103),DRY(128),FEEDBACK(110),DAMP(8),FREQUENCY(6),DEPTH(17),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(128)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_LOADNOTE)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(128),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(67), SNHFREQ(128), FLAGS(STEREO)
	GO4K_OUT	GAIN(110), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument7)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(69),PHASE(19),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(75),PHASE(17),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(81),PHASE(13),GATES(15),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(47),DRY(128),FEEDBACK(80),DAMP(22),FREQUENCY(11),DEPTH(16),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(0)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(11),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(57),PHASE(7),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(51),PHASE(5),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(103),DRY(128),FEEDBACK(110),DAMP(8),FREQUENCY(6),DEPTH(17),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(128)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_LOADNOTE)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(128),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(66), SNHFREQ(128), FLAGS(STEREO)
	GO4K_OUT	GAIN(110), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument8)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(69),PHASE(19),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(75),PHASE(17),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(81),PHASE(13),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(47),DRY(128),FEEDBACK(80),DAMP(22),FREQUENCY(11),DEPTH(16),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(8)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(11),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(57),PHASE(7),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(51),PHASE(5),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(103),DRY(128),FEEDBACK(110),DAMP(8),FREQUENCY(6),DEPTH(17),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(128)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_LOADNOTE)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(128),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(62), SNHFREQ(128), FLAGS(STEREO)
	GO4K_OUT	GAIN(110), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument9)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(69),PHASE(19),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(75),PHASE(17),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(81),PHASE(13),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(47),DRY(128),FEEDBACK(80),DAMP(22),FREQUENCY(11),DEPTH(16),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(4)
	GO4K_ENV	ATTAC(64),DECAY(64),SUSTAIN(128),RELEASE(84),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(61),PHASE(11),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(57),PHASE(7),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(51),PHASE(5),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(7),COLOR(0),SHAPE(96),GAIN(128),FLAGS(GATE)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(108),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(48),RESONANCE(64),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(103),DRY(128),FEEDBACK(110),DAMP(8),FREQUENCY(6),DEPTH(17),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(128)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_FOP	OP(FOP_LOADNOTE)
	GO4K_FST	AMOUNT(128),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(128),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(76), SNHFREQ(128), FLAGS(STEREO)
	GO4K_OUT	GAIN(110), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument10)
	GO4K_ENV	ATTAC(35),DECAY(128),SUSTAIN(64),RELEASE(64),GAIN(64)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(12),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_VCO	TRANSPOSE(64),DETUNE(60),PHASE(49),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(64),DETUNE(71),PHASE(16),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(52),DETUNE(77),PHASE(68),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(76),DETUNE(66),PHASE(95),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(64),DETUNE(58),PHASE(41),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(52),DETUNE(75),PHASE(41),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(76),DETUNE(56),PHASE(41),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(64),DETUNE(63),PHASE(41),GATES(0),COLOR(128),SHAPE(64),GAIN(128),FLAGS(TRISAW|VCO_STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(59),GAIN(58),FLAGS(NOISE|VCO_STEREO)
	GO4K_VCF	FREQUENCY(121),RESONANCE(115),VCFTYPE(HIGHPASS|STEREO)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_ENV	ATTAC(34),DECAY(64),SUSTAIN(128),RELEASE(32),GAIN(128)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_FST	AMOUNT(78),DEST(26*MAX_UNIT_SLOTS+4+FST_SET+FST_POP)
	GO4K_VCF	FREQUENCY(24),RESONANCE(112),VCFTYPE(LOWPASS|STEREO)
	GO4K_VCF	FREQUENCY(24),RESONANCE(112),VCFTYPE(LOWPASS|STEREO)
	GO4K_VCF	FREQUENCY(24),RESONANCE(111),VCFTYPE(PEAK|STEREO)
	GO4K_ENV	ATTAC(16),DECAY(96),SUSTAIN(64),RELEASE(64),GAIN(38)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_FOP	OP(FOP_MULP2)
	GO4K_DLL	PREGAIN(101),DRY(128),FEEDBACK(106),DAMP(10),FREQUENCY(0),DEPTH(0),DELAY(19),COUNT(1)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_DLL	PREGAIN(115),DRY(128),FEEDBACK(98),DAMP(25),FREQUENCY(0),DEPTH(0),DELAY(17),COUNT(1)
	GO4K_VCF	FREQUENCY(18),RESONANCE(128),VCFTYPE(HIGHPASS|STEREO)
	GO4K_OUT	GAIN(94), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument11)
	GO4K_ENV	ATTAC(0),DECAY(128),SUSTAIN(128),RELEASE(0),GAIN(128)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_DST	DRIVE(64), SNHFREQ(0), FLAGS(0)
	GO4K_FST	AMOUNT(54),DEST(8*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(78),DEST(9*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(100),DEST(10*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(45),DEST(11*MAX_UNIT_SLOTS+4+FST_SET+FST_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(23),GATES(0),COLOR(128),SHAPE(90),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(17),GATES(0),COLOR(128),SHAPE(90),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(6),GATES(0),COLOR(128),SHAPE(90),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(0),COLOR(128),SHAPE(90),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_ENV	ATTAC(0),DECAY(128),SUSTAIN(128),RELEASE(0),GAIN(72)
	GO4K_FOP	OP(FOP_PUSH)
	GO4K_FOP	OP(FOP_MULP2)
	GO4K_DLL	PREGAIN(48),DRY(128),FEEDBACK(127),DAMP(2),FREQUENCY(7),DEPTH(21),DELAY(9),COUNT(8)
	GO4K_OUT	GAIN(13), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Global)
	GO4K_ACC	ACCTYPE(AUX)
	GO4K_DLL	PREGAIN(40),DRY(128),FEEDBACK(125),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(1),COUNT(8)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_DLL	PREGAIN(40),DRY(128),FEEDBACK(125),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(9),COUNT(8)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_ACC	ACCTYPE(OUTPUT)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_VCF	FREQUENCY(9),RESONANCE(128),VCFTYPE(HIGHPASS|STEREO)
	GO4K_OUT	GAIN(23), AUXSEND(0)
GO4K_END_PARAMDEF
go4k_synth_parameter_values_end
%ifdef USE_SECTIONS
section .g4kmuc5 data align=1
%else
section .data
%endif
%ifdef GO4K_USE_DLL
global _go4k_delay_times
_go4k_delay_times
	dw 0
	dw 1116
	dw 1188
	dw 1276
	dw 1356
	dw 1422
	dw 1492
	dw 1556
	dw 1618
	dw 1140
	dw 1212
	dw 1300
	dw 1380
	dw 1446
	dw 1516
	dw 1580
	dw 1642
	dw 33075
	dw 44100
	dw 24806
%endif
