#ifndef	__KEYFRAMER_H_
#define __KEYFRAMER_H_

#include "math3d.h"

class he3d_CTrack;
class he3d_CObject;
class he3d_CScene;

class he3d_CKeyframer
{
public:

	he3d_CScene*			pScene;
	FLOAT					frame;

	he3d_CKeyframer*		pkfNext;
	he3d_CKeyframer*		pkfSub;

	he3d_CObject*			poKeyframerOwner;

	he3d_CMatrix			mtxFrame;	

	he3d_CTrack*			ptPosition;
	he3d_CTrack*			ptRotation;
	he3d_CTrack*			ptScale;
	
public:

	he3d_CKeyframer( he3d_CScene* scene ) : pScene( scene ), 
											poKeyframerOwner( NULL ), 
											pkfNext( NULL ), 
											pkfSub( NULL ),
											frame( 0.0f )
	{
	}

	virtual ~he3d_CKeyframer();

	virtual void Transform( FLOAT _frame, he3d_CMtxStack& stack );
};

#endif