// Volumetic.h: interface for the Volumetic class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VOLUMETIC_H__43CA9021_7644_11D5_AD0F_406857C10000__INCLUDED_)
#define AFX_VOLUMETIC_H__43CA9021_7644_11D5_AD0F_406857C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef struct _FACECONECTIVITYDATA
{
	DWORD					m_pdwEdge[3];		// face connection
	he3d_CVector			m_vN;				// face normal

	BOOL					m_bVisible;			// visibility
} FACECONECTIVITYDATA, *PFACECONECTIVITYDATA;

// note: 
// all of overloaded version accept variable vertex format the only requiments is that vertex pos is on begin of
// vertex and contains 3 floats (which is not neccessary if programmable vertex shaders are used)
// on the other hand index buffer must be created with format D3DFMT_INDEX16, which is guaranted for
// CSimpleMesh, and thous you should be awared of this fact when using 3rd and 4th version of this
// function

// this function fill array of face connectivity data with a neighbours indices and normal value
BOOL CalculateConectivity( CSimpleMesh& mesh, PFACECONECTIVITYDATA& ppfcd );
BOOL CalculateConectivity( CSimpleMesh* mesh, PFACECONECTIVITYDATA& ppfcd );
// note that this function calculate stride from vertex fvf if vertex buffer is non-fvf or
// for some reason stride differs from vertex size use 4th version of this function where stride is
// passed directly
BOOL CalculateConectivity( DWORD dwFacesCount, PDIRECT3DVERTEXBUFFER8 pvb, PDIRECT3DINDEXBUFFER8 pib, PFACECONECTIVITYDATA& ppfcd );
BOOL CalculateConectivity( DWORD dwFacesCount, PDIRECT3DVERTEXBUFFER8 pvb, PDIRECT3DINDEXBUFFER8 pib, DWORD dwStride, PFACECONECTIVITYDATA& ppfcd );

BOOL CreateShiluette( CSimpleMesh& mesh, PFACECONECTIVITYDATA pfcd, he3d_CMatrix& mtx, DWORD& dwShiluetteCount, he3d_CVector* pvShiluette );
BOOL CreateShiluette( CSimpleMesh* mesh, PFACECONECTIVITYDATA pfcd, he3d_CMatrix& mtx, DWORD& dwShiluetteCount, he3d_CVector* pvShiluette );
BOOL CreateShiluette( DWORD dwFacesCount, PDIRECT3DVERTEXBUFFER8 pvb, PDIRECT3DINDEXBUFFER8 pib, PFACECONECTIVITYDATA pfcd, he3d_CMatrix& mtx, DWORD& dwShiluetteCount, he3d_CVector* pvShiluette );
BOOL CreateShiluette( DWORD dwFacesCount, PDIRECT3DVERTEXBUFFER8 pvb, PDIRECT3DINDEXBUFFER8 pib, DWORD dwStride, PFACECONECTIVITYDATA pfcd, he3d_CMatrix& mtx, DWORD& dwShiluetteCount, he3d_CVector* pvShiluette );

// note is caller resposibility to allocate and lock vertex buffer of correct size... well i decided for such solution beacaus
// it allow user not to create vertex buffer each time the volume is calculated (this is imporatant thing especially for shadow voume
// when volume will be propably calculated each frame)
// and its easy to calculate vertex buffer size if vertex count for shiluette is given, for non-striped siluette the vbuffer size
// is 3*dwShiluetteCount*sizeof(vertex_struct), and for striped shiluettes vertex buffer size is
// is 6*dwShiluetteCount*sizeof(vertex_struct)
// note2 strided shiluettes are automaticaly closed its mean that first vertice is also last
// note3 simple volume function fills only position, color and others components of vertex should be filled
// manually by caller
BOOL CreateVolumeFromShiluette( DWORD dwShiluetteCount, he3d_CVector* pvShiluette, he3d_CVector& vPoint, DWORD dwStride, LPBYTE pVertices, FLOAT length = 50.0f );
BOOL CreateVolumeFromShiluetteStrip( DWORD dwShiluetteCount, he3d_CVector* pvShiluette, he3d_CVector& vPoint, DWORD dwStride, LPBYTE pVertices, FLOAT length = 50.0f );
BOOL CreateParallelVolumeFromShiluette( DWORD dwShiluetteCount, he3d_CVector* pvShiluette, he3d_CVector& vDir, DWORD dwStride, LPBYTE pVertices, FLOAT length = 50.0f );
BOOL CreateParallelVolumeFromShiluetteStrip( DWORD dwShiluetteCount, he3d_CVector* pvShiluette, he3d_CVector& vDir, DWORD dwStride, LPBYTE pVertices, FLOAT length = 50.0f );

#endif // !defined(AFX_VOLUMETIC_H__43CA9021_7644_11D5_AD0F_406857C10000__INCLUDED_)
