#include "..\h\Part.h"

Part::Part()
{
	position=0.0;
	start=0.0;
	length=0.0;
	speed=1.0;
	track=0;

	functions=NULL;
}

Part::~Part()
{
	if (functions!=NULL)
	{
		for (int i=0; functions[i]!=NULL; i++)
			delete functions[i];
		free(functions);
	}
}

void Part::execute(float time)
{
	if ((time<position)||(time>=position+length))		// exit, if part isn't active
		return;

	for (int i=0; functions[i]!=NULL; i++)
		functions[i]->execute((time-position)*speed+start, (time-position)/length);
}
