{$N+,E-,D-,L-,F-}
program _3d_maker_v2_3_yeah;
uses tools3d,shapes3d,Crt,dos;

type
  lang = (bin, as, c, pas);
  t_shape = (s_sphere, s_torus, s_unknown);

var
  sname         : string;
  script        : text;
  line          : string;
  file_s        : string;
  shape         : t_shape;

function getnum(var s:string): integer;
var
  coma, err: integer;
  conv: string;
  value: integer;
begin
  coma := pos(',',s);
  conv := copy(s,1,coma-1);
  val(conv,value,err);
  delete(s,1,coma);
  getnum := value;
end;

function killspace( s: string ): string;
var
  i: integer;
begin
  i:=1;
  while (s[i] = ' ') or (s[i] = #9) do
    inc(i);
  delete(s,1,i-1);
  killspace := s;
end;

function getstr(var s:string): string;
var
  coma: integer;
  value: string;
begin
  coma := pos(',',s);
  if coma <> 0 then
  begin
    getstr := killspace(copy(s,1,coma-1));
    delete(s,1,coma);
  end
  else
    getstr := killspace(copy(s,1,length(s)));
end;

procedure getshape(s: string);
var
  id   : string;
begin
  id := getstr(s);
  if (id='SPHERE') or (id='sphere') then
  begin
    shape := s_sphere;

    v_sect := getnum(s);
    n_sect := getnum(s);
    promien_x := getnum(s);
    promien_y := getnum(s);
    tr_x := getnum(s);
    tr_y := getnum(s);
    tr_z := getnum(s);
    file_s := getstr(s);

    writeln;
    writeln ('          -= Creating sphere =-');
    writeln ('    No. of hemicircle''s vertices :  ',v_sect);
    writeln ('    No. of scections             :  ',n_sect);
    writeln ('    X radius                     :  ',promien_x);
    writeln ('    Y radius                     :  ',promien_y);
    writeln ('    Translate X                  :  ',tr_x);
    writeln ('    Translate Y                  :  ',tr_y);
    writeln ('    Translate Z                  :  ',tr_z);
    writeln ('    Output filename              :  ',file_s+'.'+ext[output]);
    writeln;
  end
  else
  if (id='TORUS') or (id='torus') then
  begin
    shape := s_torus;

    v_sect := getnum(s);
    n_sect := getnum(s);
    promien_x := getnum(s);
    promien_y := getnum(s);
    od_x := getnum(s);
    tr_x := getnum(s);
    tr_y := getnum(s);
    tr_z := getnum(s);
    file_s := getstr(s);

    writeln;
    writeln ('           -= Creating torus =-');
    writeln ('    No. of hemicircle''s vertices :  ',v_sect);
    writeln ('    No. of scections             :  ',n_sect);
    writeln ('    Section''s X radius           :  ',promien_x);
    writeln ('    Section''s Y radius           :  ',promien_y);
    writeln ('    Main radius                  :  ',od_x);
    writeln ('    Translate X                  :  ',tr_x);
    writeln ('    Translate Y                  :  ',tr_y);
    writeln ('    Translate Z                  :  ',tr_z);
    writeln ('    Output filename              :  ',file_s+'.'+ext[output]);
    writeln;
  end
  else
  begin
    shape := s_unknown;
    writeln ('         -= Unknown Shape ?! =-');
  end;
end;

begin
  getcfg;

  if paramstr(1)='' then
  begin
    write('Enter script filename: ');
    readln(sname);
  end
  else
    sname := paramstr(1);

  assign(script,sname);
  {$I-}
  reset(script);
  if IOresult <> 0 then
  begin
    writeln('Script not found!');
    halt;
  end;
  {$I+}

  while not(eof(script)) do
  begin
    readln (script,line);
    getshape(line);
    if shape <> s_unknown then
    begin
      write('under construction...');
      openout(file_s);
      case shape of
        s_sphere:
          Kula;
        s_torus:
          Torus;
        s_unknown:
          ;
      end;
      closeout;
      writeln('done');
    end
  end;
  close (script);
end.