/*
 * Timer which calls a user function at the desired PIT clock frequency.
 *
 * Doesn't "officially" belong to JUDAS V2.0 but feel free to use! This is
 * blasphemy-ware too!
 */

#include <conio.h>
#include <dos.h>
#include "judasmem.h"

int timer_init(unsigned short frequency, void (*function)());
void timer_uninit(void);
static int timer_lock(void);
static int timer_unlock(void);
void timer_handler(void);
unsigned short timer_get_ds(void);

#pragma aux timer_get_ds = \
"mov ax, ds" \
modify [ax] \
value [ax];

static unsigned char timer_initialized = 0;
void (__interrupt __far *timer_oldvect)();
void (__interrupt __far *timer_newvect)() = &timer_handler;
void (*timer_function)();
unsigned timer_count;
unsigned short timer_frequency;
unsigned short timer_systemcount;
unsigned short timer_ds;

extern int timer_code_lock_start;
extern int timer_code_lock_end;

int timer_init(unsigned short frequency, void (*function)())
{
	if (timer_initialized) return 1;
        if (!timer_lock()) return 0;
        timer_function = function;
        timer_count = 0;
        timer_systemcount = 0;
        timer_frequency = frequency;
        timer_ds = timer_get_ds();
        timer_oldvect = _dos_getvect(8);
        _disable();
        _dos_setvect(8, timer_newvect);
        outp(0x43, 0x34);
        outp(0x40, frequency);
        outp(0x40, frequency >> 8);
        _enable();
        timer_initialized = 1;
        return 1;
}

void timer_uninit(void)
{
	if (!timer_initialized) return;
        _disable();
        _dos_setvect(8, timer_oldvect);
        outp(0x43, 0x34);
        outp(0x40, 0x00);
        outp(0x40, 0x00);
        _enable();
        timer_unlock();
        timer_initialized = 0;
}

static int timer_lock(void)
{
        if (!judas_memlock(&timer_code_lock_start, (int)&timer_code_lock_end - (int)&timer_code_lock_start)) return 0;
        if (!judas_memlock(&timer_frequency, sizeof timer_frequency)) return 0;
        if (!judas_memlock(&timer_function, sizeof timer_function)) return 0;
        if (!judas_memlock(&timer_count, sizeof timer_count)) return 0;
        if (!judas_memlock(&timer_systemcount, sizeof timer_systemcount)) return 0;
        if (!judas_memlock(&timer_ds, sizeof timer_ds)) return 0;
        if (!judas_memlock(&timer_oldvect, sizeof timer_oldvect)) return 0;
        return 1;
}

static void timer_unlock(void)
{
        judas_memunlock(&timer_code_lock_start, (int)&timer_code_lock_end - (int)&timer_code_lock_start);
        judas_memunlock(&timer_frequency, sizeof timer_frequency);
        judas_memunlock(&timer_function, sizeof timer_function);
        judas_memunlock(&timer_count, sizeof timer_count);
        judas_memunlock(&timer_systemcount, sizeof timer_systemcount);
        judas_memunlock(&timer_ds, sizeof timer_ds);
        judas_memunlock(&timer_oldvect, sizeof timer_oldvect);
}
