#ifndef __3dmath_h
#define __3dmath_h

// 12-30-96 05:46pm [NP] mathematische Funktionen fr 3d-Grafik
// 12-30-96 05:46pm [NP] 1. Version

#define M_PI  3.141592654
#define M_PI2 6.283185308

#include "3dtypes.h"

extern "C" float veclength (const tvector &a);
#pragma aux veclength "*" parm [esi] modify [8087] value [8087];

extern "C" void getnormvector (const tvector &a, tvector &b);
#pragma aux getnormvector "*" parm [esi][edi] modify [8087];

extern "C" void normvector (tvector &a);
#pragma aux normvector "*" parm [esi] modify [8087];

extern "C" float dotproduct (const tvector &a, const tvector &b);
#pragma aux dotproduct "*" parm [esi][edi] modify [8087] value [8087];

extern "C" void crossproduct (const tvector &a, const tvector &b, tvector &c);
#pragma aux crossproduct "*" parm [edi][esi][ebx] modify [8087];

extern "C" float transform (const tvector &a, float * b, tvector &c);
#pragma aux transform "*" parm [esi][edi][ebx] modify [8087];

void make_rotation_matrix (float * m, tvector r);
void make_inverse_rotation_matrix (float * m, tvector r);
void make_scale_matrix (float * m, tvector s);
void make_move_matrix (float * m, tvector s);
void make_normal_matrix (float * m);
void matrix_mul (float * c, float * a, float * b);
void angle_preserving_matrix_inverse (float * in, float * out);

#endif



