#include "3dtypes.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

void make_rotation_matrix (float *m, tvector r)
{
  memset (m, 0, 16*sizeof(float));
  float sy = sin(r.y);
  float sx = sin(r.x);
  float sz = sin(r.z);
  float cy = cos(r.y);
  float cx = cos(r.x);
  float cz = cos(r.z);
  m[0+4*0] = (cx*cy)+((-sx*-sz)*-sy);
  m[1+4*0] = ((-sx*cz));
  m[2+4*0] = (cx*sy)+((-sx*-sz)*cy);
  m[0+4*1] = (sx*cy)+((cx*-sz)*-sy);
  m[1+4*1] = ((cx*cz));
  m[2+4*1] = (sx*sy)+((cx*-sz)*cy);
  m[0+4*2] = (cz*-sy);
  m[1+4*2] = sz;
  m[2+4*2] = (cz*cy);
  m[15]=1;
}

void make_inverse_rotation_matrix (float * m, tvector r)
{
  memset (m, 0, 16*sizeof(float));
  float sy = sin(-r.y);
  float sx = sin(-r.x);
  float sz = sin(-r.z);
  float cy = cos(-r.y);
  float cx = cos(-r.x);
  float cz = cos(-r.z);
  m[0+4*0] = (cy*cx)+((sy*sz)*sx);
  m[1+4*0] = (cy*-sx)+((sy*sz)*cx);
  m[2+4*0] = ((sy*cz));
  m[0+4*1] = (cz*sx);
  m[1+4*1] = (cz*cx);
  m[2+4*1] = -sz;
  m[0+4*2] = (-sy*cx)+((cy*sz)*sx);
  m[1+4*2] = (-sy*-sx)+((cy*sz)*cx);
  m[2+4*2] = ((cy*cz));
  m[15]=1;
}

void make_scale_matrix (float * m, tvector s)
{
  memset (m, 0, 16*sizeof(float));
  m[0]=s.x;
  m[5]=s.y;
  m[10]=s.z;
  m[15]=1;
}

void make_move_matrix (float * m, tvector s)
{
  memset (m, 0, 16*sizeof(float));
  m[0]=1;
  m[3]=s.x;
  m[5]=1;
  m[7]=s.y;
  m[10]=1;
  m[11]=s.z;
  m[15]=1;
}

void make_normal_matrix (float * m)
{
  memset (m, 0, 16*sizeof(float));
  m[0]=1;
  m[5]=1;
  m[10]=1;
  m[15]=1;
}

void matrix_mul (float * c, float * a, float * b)
{
  memset (c, 0, 16*sizeof(float));
  for ( int i=0; i<4; i++ )
  for ( int j=0; j<4; j++ )
  for ( int k=0; k<4; k++ )
    c[i+4*j]+=a[i+4*k]*b[k+4*j];
}

void angle_preserving_matrix_inverse (float *in, float *out)
{
    double  scale;

    /* Calculate the square of the isotropic scale factor */
    scale = in[0*4+0] * in[0*4+0] +
            in[0*4+1] * in[0*4+1] +
            in[0*4+2] * in[0*4+2];

    /* Calculate the inverse of the square of the isotropic scale factor */
    scale = 1.0 / scale;

    /* Transpose and scale the 3 by 3 upper-left submatrix */
    out[0*4+0] = scale * in[0*4+0];
    out[1*4+0] = scale * in[0*4+1];
    out[2*4+0] = scale * in[0*4+2];
    out[0*4+1] = scale * in[1*4+0];
    out[1*4+1] = scale * in[1*4+1];
    out[2*4+1] = scale * in[1*4+2];
    out[0*4+2] = scale * in[2*4+0];
    out[1*4+2] = scale * in[2*4+1];
    out[2*4+2] = scale * in[2*4+2];

    /* Calculate -(transpose(A) / s*s) C */
    out[0*4+3] = - ( out[0*4+0] * in[0*4+3] +
                    out[0*4+1] * in[1*4+3] +
                    out[0*4+2] * in[2*4+3] );
    out[1*4+3] = - ( out[1*4+0] * in[0*4+3] +
                    out[1*4+1] * in[1*4+3] +
                    out[1*4+2] * in[2*4+3] );
    out[2*4+3] = - ( out[2*4+0] * in[0*4+3] +
                    out[2*4+1] * in[1*4+3] +
                    out[2*4+2] * in[2*4+3] );

    /* Fill in last row */
    out[3*4+0] = out[3*4+1] = out[3*4+2] = 0.0;
    out[3*4+3] = 1.0;

}

