/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source: 
		win32 plugin

	revision history:
		Apr/15/2000 - Jukka Liimatta - initial revision
		Jan/24/2001 - Jukka Liimatta - renaissance build
*/
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// externsion                                      //
////////////////////////////////////////////////////

#ifndef NDEBUG
	#define DLL_EXTENSION "Debug.dll"
#else
	#define DLL_EXTENSION ".dll"
#endif


//////////////////////////////////////////////////////
// Plugin                                          //
////////////////////////////////////////////////////

Plugin::Plugin(const char* filename, bool rawmode)
{
	// create filename
	int length = strlen(filename) + strlen(DLL_EXTENSION) + 1;
	char* name = new char[ length ];
	strcpy(name,filename);
	if ( !rawmode )
		strcat(name,DLL_EXTENSION);

	// load win32 Plugin
	uint32 omode = SetErrorMode( SEM_FAILCRITICALERRORS | SEM_NOOPENFILEERRORBOX );
	handle = LoadLibrary( name );
	SetErrorMode( omode );

	// free filename
	delete[] name;
	
	// interface name
	SetName(filename);
}


Plugin::~Plugin()
{
	if ( handle )
		FreeLibrary( (HMODULE)handle );
}


void Plugin::GetAddress(void** address, const char* symbol)
{
	assert( symbol );
	assert( address );
	*address = handle ? (void*)GetProcAddress( (HMODULE)handle,symbol ) : NULL;
}
