/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		win32 exception

	revision history:
		Jul/20/2000 - Jukka Liimatta - initial revision
		Jan/24/2001 - Jukka Liimatta - renaissance build
*/
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// statics                                         //
////////////////////////////////////////////////////

static char ExFilename[] = "Unknown";
static char ExMethod[] = "Unknown";
static char ExMessage[] = "N/A";


//////////////////////////////////////////////////////
// Exeption                                        //
////////////////////////////////////////////////////

Exception::Exception()
{
	mFilename = ExFilename;
	mMethod = ExMethod;
	mMessage = ExMessage;
}


Exception::Exception(const char* method, const char* message, const char* file)
{
	mFilename = file ? file : ExFilename;
	mMethod = method ? method : ExMethod;
	mMessage = message ? message : ExMessage;
}


Exception::Exception(const Exception& e)
{
	*this = e;
}


Exception::~Exception()
{
}


void Exception::operator = (const Exception& e)
{
	mFilename = e.mFilename;
	mMethod = e.mMethod;
	mMessage = e.mMessage;
}


const String& Exception::GetFilename() const
{
	return mFilename;
}


const String& Exception::GetMethod() const
{
	return mMethod;
}


const String& Exception::GetMessage() const
{
	return mMessage;
}


//////////////////////////////////////////////////////
// logo                                            //
////////////////////////////////////////////////////

static const int mExceptionWidth   = 128;
static const int mExceptionHeight  = 94;
static const int mExceptionPixels  = 12032;
static const int mExceptionDepth   = 1;
static const int mExceptionBits    = 8;

#pragma pack(1)

static unsigned char mExceptionPalette[768] =
{
    252, 244, 252, 244, 236, 244, 12, 4, 15, 20, 12, 23, 28, 20, 31, 20,
    19, 31, 4, 4, 12, 244, 244, 252, 44, 44, 45, 5, 8, 25, 30, 34,
    45, 37, 43, 58, 7, 17, 40, 16, 27, 50, 228, 236, 252, 60, 74, 97,
    101, 123, 160, 37, 53, 73, 76, 108, 148, 118, 140, 168, 25, 40, 57, 104,
    140, 180, 76, 99, 124, 85, 108, 134, 55, 89, 124, 43, 65, 88, 132, 172,
    213, 92, 116, 140, 102, 122, 142, 148, 179, 208, 68, 99, 126, 75, 107, 134,
    76, 98, 116, 57, 85, 107, 88, 123, 149, 84, 116, 140, 103, 139, 166, 54,
    73, 87, 120, 155, 182, 86, 106, 121, 166, 200, 226, 6, 40, 64, 51, 101,
    135, 79, 130, 166, 100, 162, 207, 75, 120, 150, 70, 91, 106, 133, 171, 198,
    127, 164, 189, 54, 65, 73, 138, 160, 175, 23, 61, 84, 67, 97, 116, 106,
    152, 182, 154, 191, 215, 94, 116, 130, 119, 140, 153, 115, 163, 191, 133, 184,
    214, 103, 137, 156, 149, 176, 192, 230, 244, 252, 91, 141, 166, 121, 173, 201,
    76, 108, 124, 140, 197, 227, 84, 116, 132, 92, 124, 140, 13, 75, 104, 40,
    81, 99, 151, 209, 235, 118, 154, 170, 169, 215, 236, 215, 237, 247, 67, 108,
    125, 75, 118, 135, 89, 134, 152, 84, 124, 140, 106, 152, 172, 167, 225, 248,
    126, 164, 180, 136, 173, 188, 136, 183, 200, 102, 136, 148, 200, 235, 248, 197,
    221, 230, 106, 164, 183, 115, 173, 193, 116, 164, 180, 106, 150, 164, 124, 172,
    188, 30, 96, 116, 70, 88, 93, 180, 225, 238, 73, 136, 151, 59, 102, 112,
    76, 108, 116, 147, 201, 215, 165, 195, 202, 175, 204, 211, 43, 66, 71, 183,
    239, 251, 151, 190, 198, 7, 55, 63, 26, 57, 63, 17, 29, 31, 84, 125,
    132, 127, 181, 190, 159, 216, 226, 118, 135, 138, 67, 110, 116, 131, 197, 206,
    90, 133, 139, 72, 102, 106, 84, 118, 123, 122, 165, 171, 52, 128, 136, 76,
    133, 140, 75, 117, 122, 114, 172, 179, 104, 149, 154, 39, 56, 58, 94, 125,
    129, 86, 103, 105, 59, 95, 98, 106, 164, 169, 129, 174, 178, 102, 135, 138,
    8, 22, 23, 108, 180, 185, 92, 151, 155, 56, 85, 87, 118, 150, 152, 199,
    249, 252, 216, 250, 252, 216, 230, 231, 13, 50, 51, 11, 38, 39, 4, 12,
    12, 36, 44, 44, 179, 218, 218, 192, 232, 232, 232, 252, 252, 244, 252, 252,
    24, 40, 39, 201, 244, 241, 33, 81, 77, 76, 148, 140, 92, 148, 140, 71,
    118, 108, 126, 162, 154, 68, 82, 79, 95, 116, 111, 56, 80, 73, 230, 250,
    244, 204, 211, 209, 27, 52, 43, 71, 104, 91, 44, 69, 57, 110, 131, 121,
    154, 162, 158, 230, 232, 231, 190, 192, 191, 168, 193, 179, 215, 244, 228, 119,
    151, 129, 39, 56, 44, 24, 37, 27, 215, 226, 217, 4, 12, 4, 9, 22,
    9, 36, 44, 36, 233, 249, 233, 90, 92, 90, 19, 33, 18, 128, 132, 127,
    32, 45, 27, 199, 210, 192, 44, 52, 28, 236, 244, 220, 67, 68, 57, 12,
    12, 4, 36, 36, 20, 44, 44, 28, 36, 36, 28, 44, 44, 36, 58, 58,
    54, 252, 252, 244, 244, 244, 243, 245, 243, 193, 252, 250, 215, 252, 251, 232,
    215, 212, 172, 232, 229, 186, 249, 246, 203, 235, 232, 197, 31, 29, 8, 21,
    20, 11, 217, 214, 184, 148, 147, 138, 201, 197, 168, 180, 175, 147, 192, 186,
    158, 245, 236, 199, 229, 220, 185, 209, 202, 180, 204, 190, 152, 168, 159, 132,
    212, 201, 171, 212, 180, 95, 122, 115, 97, 75, 73, 68, 57, 53, 44, 229,
    220, 200, 180, 177, 170, 44, 36, 20, 216, 190, 140, 236, 204, 148, 93, 85,
    71, 232, 226, 215, 28, 25, 20, 153, 138, 116, 137, 124, 104, 113, 103, 88,
    246, 234, 218, 77, 69, 59, 103, 91, 78, 86, 76, 65, 52, 28, 4, 62,
    38, 14, 36, 28, 20, 44, 36, 28, 52, 44, 36, 103, 80, 61, 86, 66,
    50, 61, 46, 36, 248, 236, 228, 44, 28, 18, 70, 57, 49, 52, 37, 28,
    252, 244, 240, 36, 20, 18, 20, 12, 11, 13, 4, 4, 44, 28, 28, 52,
    36, 36, 61, 44, 44, 36, 28, 28, 44, 36, 36, 52, 44, 44, 36, 36,
    36, 28, 28, 28, 20, 20, 20, 12, 12, 12, 4, 4, 4, 3, 3, 3

};

static unsigned char mExceptionData[12032] = \
{
    143, 176, 84, 102, 45, 143, 0, 0, 109, 104, 0, 43, 102, 0, 0, 143,
    255, 60, 134, 72, 187, 177, 0, 51, 103, 0, 134, 143, 98, 187, 93, 255,
    98, 0, 143, 99, 199, 0, 68, 25, 143, 0, 134, 144, 85, 101, 6, 140,
    0, 0, 125, 181, 143, 47, 51, 143, 0, 79, 255, 123, 143, 24, 108, 155,
    0, 41, 255, 134, 82, 38, 99, 99, 72, 255, 152, 0, 62, 99, 159, 54,
    54, 82, 102, 60, 98, 60, 82, 102, 82, 60, 81, 60, 81, 81, 81, 81,
    50, 50, 48, 80, 50, 80, 80, 25, 50, 150, 40, 5, 167, 54, 36, 71,
    109, 50, 36, 255, 159, 54, 34, 55, 173, 126, 10, 186, 97, 71, 28, 167,
    140, 12, 142, 0, 0, 162, 255, 101, 58, 45, 0, 0, 0, 103, 128, 143,
    54, 134, 213, 143, 78, 255, 187, 0, 134, 168, 177, 0, 254, 137, 0, 0,
    142, 153, 191, 81, 255, 142, 143, 0, 69, 226, 187, 41, 89, 0, 0, 133,
    255, 115, 143, 9, 140, 143, 0, 41, 255, 143, 63, 43, 140, 187, 57, 255,
    150, 143, 65, 126, 160, 142, 255, 255, 0, 79, 58, 156, 162, 53, 255, 81,
    133, 54, 81, 82, 86, 126, 90, 80, 80, 88, 48, 88, 88, 71, 88, 115,
    71, 71, 78, 71, 89, 19, 19, 97, 69, 255, 132, 26, 16, 71, 159, 82,
    255, 197, 108, 16, 77, 231, 132, 33, 255, 150, 63, 78, 242, 225, 76, 6,
    0, 0, 0, 255, 114, 142, 68, 133, 0, 143, 163, 255, 143, 101, 140, 172,
    172, 143, 255, 94, 143, 0, 0, 152, 0, 130, 169, 0, 143, 134, 160, 207,
    0, 255, 116, 0, 143, 99, 255, 187, 36, 103, 143, 0, 143, 128, 212, 143,
    12, 45, 0, 143, 58, 255, 163, 142, 68, 102, 135, 143, 255, 255, 143, 65,
    58, 150, 143, 33, 255, 111, 143, 44, 113, 157, 101, 255, 255, 142, 101, 78,
    255, 148, 58, 38, 88, 38, 86, 71, 71, 88, 78, 120, 78, 89, 78, 62,
    62, 36, 59, 76, 76, 76, 77, 34, 78, 42, 75, 153, 111, 12, 255, 125,
    53, 43, 156, 153, 21, 255, 144, 97, 62, 25, 255, 67, 13, 255, 71, 76,
    159, 255, 142, 43, 108, 143, 0, 0, 255, 74, 142, 40, 143, 163, 0, 91,
    255, 0, 143, 187, 163, 236, 143, 254, 119, 0, 143, 155, 223, 0, 43, 255,
    0, 0, 0, 128, 214, 84, 9, 79, 0, 143, 81, 254, 0, 95, 68, 0,
    0, 143, 255, 104, 0, 91, 82, 98, 0, 31, 255, 133, 142, 44, 159, 172,
    79, 255, 137, 143, 101, 78, 176, 133, 51, 255, 101, 134, 70, 169, 180, 133,
    255, 110, 133, 58, 86, 48, 38, 80, 53, 78, 38, 78, 78, 78, 78, 19,
    89, 62, 36, 36, 62, 16, 76, 34, 76, 82, 24, 255, 113, 26, 43, 30,
    178, 78, 6, 255, 82, 86, 34, 255, 153, 43, 255, 113, 57, 57, 254, 181,
    82, 47, 143, 143, 0, 255, 6, 0, 44, 61, 163, 0, 142, 255, 93, 143,
    142, 161, 159, 0, 41, 91, 187, 0, 0, 131, 191, 84, 255, 108, 143, 0,
    120, 167, 143, 69, 116, 0, 143, 134, 255, 168, 85, 12, 133, 0, 0, 146,
    255, 0, 90, 62, 140, 0, 133, 255, 158, 143, 44, 102, 159, 0, 9, 255,
    134, 79, 79, 151, 163, 70, 255, 124, 143, 101, 69, 255, 145, 33, 255, 145,
    133, 72, 255, 122, 65, 88, 86, 80, 88, 38, 71, 78, 71, 71, 78, 78,
    53, 120, 62, 62, 76, 76, 59, 77, 62, 77, 62, 21, 62, 174, 132, 33,
    255, 96, 58, 53, 10, 197, 89, 6, 10, 81, 129, 25, 255, 39, 24, 20,
    143, 0, 132, 255, 134, 70, 140, 187, 164, 0, 169, 103, 0, 133, 143, 210,
    143, 86, 9, 143, 187, 143, 102, 175, 187, 41, 68, 187, 0, 142, 255, 168,
    140, 12, 0, 0, 0, 170, 156, 143, 76, 108, 0, 0, 142, 254, 140, 143,
    42, 133, 142, 143, 255, 255, 143, 101, 58, 152, 187, 87, 255, 102, 143, 133,
    118, 218, 143, 255, 255, 143, 101, 65, 255, 150, 101, 255, 87, 134, 133, 255,
    255, 79, 52, 45, 97, 98, 38, 78, 88, 80, 53, 53, 125, 71, 78, 89,
    89, 62, 89, 59, 130, 59, 62, 34, 76, 16, 67, 86, 89, 255, 136, 97,
    63, 31, 255, 114, 25, 255, 132, 90, 57, 255, 197, 89, 12, 95, 83, 122,
    134, 142, 73, 93, 143, 177, 0, 117, 255, 0, 133, 143, 162, 205, 134, 255,
    140, 143, 0, 143, 153, 0, 102, 255, 0, 0, 0, 146, 152, 143, 41, 107,
    0, 0, 81, 254, 143, 84, 62, 0, 143, 0, 255, 158, 0, 45, 97, 177,
    143, 75, 255, 145, 134, 65, 114, 214, 143, 255, 6, 143, 134, 40, 178, 140,
    24, 255, 97, 142, 101, 137, 196, 79, 6, 104, 141, 101, 28, 255, 120, 79,
    41, 60, 141, 133, 255, 174, 79, 58, 78, 53, 80, 38, 78, 89, 36, 78,
    78, 62, 89, 36, 62, 62, 34, 34, 76, 76, 34, 76, 35, 53, 53, 255,
    158, 62, 255, 131, 58, 58, 13, 255, 76, 69, 20, 83, 120, 16, 255, 158,
    142, 84, 142, 0, 85, 255, 111, 0, 61, 187, 160, 0, 103, 12, 0, 0,
    0, 201, 162, 187, 41, 140, 0, 187, 102, 170, 0, 126, 68, 0, 0, 143,
    255, 127, 187, 42, 134, 187, 143, 122, 254, 0, 140, 86, 99, 0, 143, 255,
    153, 143, 98, 80, 152, 143, 136, 255, 140, 133, 63, 174, 175, 98, 255, 136,
    141, 79, 114, 254, 60, 25, 255, 98, 108, 65, 255, 176, 54, 12, 118, 126,
    133, 9, 255, 97, 45, 75, 132, 120, 48, 71, 115, 80, 80, 86, 78, 78,
    78, 62, 89, 36, 36, 76, 59, 76, 16, 76, 77, 34, 35, 67, 62, 12,
    138, 81, 58, 45, 255, 158, 21, 9, 149, 19, 26, 255, 255, 76, 69, 124,
    84, 84, 134, 134, 0, 101, 0, 152, 187, 108, 255, 134, 143, 143, 163, 103,
    0, 41, 132, 0, 187, 0, 128, 162, 143, 41, 134, 0, 143, 69, 255, 0,
    50, 107, 187, 0, 141, 255, 108, 0, 42, 135, 177, 0, 138, 255, 188, 97,
    59, 157, 214, 127, 255, 37, 99, 81, 92, 128, 160, 20, 6, 56, 115, 55,
    255, 153, 55, 255, 131, 127, 80, 144, 255, 67, 17, 20, 96, 132, 34, 255,
    153, 63, 31, 28, 149, 101, 255, 255, 97, 65, 88, 38, 71, 38, 89, 89,
    36, 62, 89, 36, 130, 59, 34, 76, 83, 34, 27, 34, 34, 77, 27, 78,
    63, 9, 255, 78, 17, 37, 120, 90, 25, 255, 149, 76, 69, 23, 55, 46,
    142, 84, 143, 84, 73, 142, 143, 9, 114, 187, 0, 0, 169, 0, 43, 130,
    0, 0, 0, 132, 158, 0, 68, 83, 143, 0, 134, 255, 135, 73, 45, 134,
    0, 0, 255, 136, 187, 141, 161, 150, 0, 150, 255, 122, 162, 66, 153, 211,
    175, 255, 255, 173, 92, 186, 255, 180, 128, 255, 105, 151, 37, 169, 255, 121,
    255, 255, 186, 37, 10, 255, 167, 10, 255, 144, 121, 151, 255, 255, 92, 17,
    25, 186, 109, 25, 255, 113, 63, 31, 39, 158, 48, 78, 89, 62, 78, 78,
    62, 71, 62, 34, 62, 76, 76, 76, 59, 76, 83, 45, 34, 75, 34, 34,
    59, 69, 12, 120, 78, 21, 255, 169, 58, 24, 113, 151, 87, 5, 255, 75,
    134, 145, 134, 84, 142, 142, 61, 101, 0, 152, 150, 134, 12, 0, 143, 0,
    168, 170, 187, 107, 51, 0, 143, 0, 255, 157, 0, 94, 85, 0, 143, 112,
    169, 0, 187, 54, 162, 213, 168, 254, 156, 214, 123, 121, 220, 248, 255, 255,
    255, 138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 242,
    128, 255, 255, 100, 25, 37, 182, 120, 51, 255, 120, 111, 36, 120, 89, 71,
    89, 76, 59, 62, 76, 76, 76, 117, 16, 45, 34, 76, 77, 77, 75, 77,
    31, 76, 26, 3, 255, 83, 18, 95, 37, 132, 24, 255, 151, 16, 33, 92,
    73, 73, 134, 143, 61, 73, 142, 0, 0, 103, 67, 0, 0, 187, 169, 50,
    0, 51, 0, 0, 187, 122, 254, 0, 54, 82, 143, 0, 187, 255, 152, 0,
    72, 99, 199, 0, 137, 255, 160, 123, 10, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 169, 243, 242, 169, 254, 243, 181, 181, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 181, 138, 255, 138, 67, 31, 118, 243, 114, 21, 62, 89,
    78, 36, 59, 130, 36, 36, 76, 16, 117, 76, 34, 27, 34, 117, 34, 75,
    34, 35, 75, 45, 25, 113, 157, 48, 255, 255, 90, 36, 35, 144, 152, 17,
    84, 134, 143, 134, 134, 143, 142, 142, 142, 142, 0, 153, 137, 143, 76, 85,
    187, 0, 142, 255, 135, 73, 67, 187, 143, 187, 12, 255, 0, 84, 134, 214,
    187, 163, 255, 132, 175, 121, 6, 255, 255, 255, 255, 255, 243, 230, 235, 234,
    233, 223, 226, 223, 210, 210, 222, 222, 222, 221, 222, 221, 221, 207, 201, 201,
    201, 208, 205, 195, 213, 213, 191, 187, 187, 191, 191, 224, 213, 213, 205, 207,
    223, 227, 242, 255, 255, 255, 255, 254, 255, 186, 17, 255, 113, 89, 120, 76,
    83, 62, 36, 59, 117, 76, 43, 27, 83, 112, 76, 45, 112, 77, 45, 23,
    106, 27, 31, 18, 82, 13, 255, 106, 44, 16, 124, 153, 34, 255, 128, 71,
    73, 101, 142, 73, 142, 134, 143, 61, 143, 134, 143, 94, 78, 0, 143, 0,
    170, 153, 143, 75, 73, 187, 0, 150, 255, 143, 143, 145, 155, 213, 143, 255,
    104, 155, 160, 180, 255, 255, 255, 255, 255, 238, 221, 201, 208, 195, 203, 240,
    191, 179, 187, 179, 224, 179, 213, 195, 213, 161, 177, 219, 168, 14, 161, 168,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187,
    0, 187, 203, 207, 8, 242, 255, 255, 255, 255, 105, 124, 15, 255, 151, 78,
    94, 83, 62, 59, 83, 76, 83, 62, 34, 45, 27, 34, 112, 34, 77, 75,
    27, 75, 106, 66, 75, 62, 43, 46, 174, 88, 9, 255, 89, 21, 34, 138,
    84, 73, 143, 84, 134, 134, 134, 142, 134, 142, 142, 0, 187, 175, 254, 0,
    88, 60, 187, 0, 0, 255, 127, 0, 93, 187, 160, 0, 118, 255, 0, 161,
    160, 211, 253, 255, 255, 255, 239, 221, 203, 187, 143, 0, 0, 0, 143, 0,
    187, 191, 179, 198, 200, 205, 201, 201, 201, 201, 201, 207, 202, 214, 214, 214,
    205, 155, 213, 236, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    143, 0, 0, 201, 210, 226, 180, 184, 255, 255, 255, 255, 10, 6, 37, 118,
    76, 27, 106, 76, 34, 28, 36, 77, 76, 76, 18, 76, 77, 16, 34, 66,
    75, 31, 75, 66, 75, 75, 125, 25, 255, 118, 36, 62, 49, 181, 114, 9,
    73, 134, 134, 84, 142, 142, 142, 134, 0, 143, 143, 0, 143, 85, 111, 0,
    0, 0, 100, 254, 0, 93, 142, 168, 0, 143, 255, 126, 0, 61, 199, 186,
    173, 255, 255, 255, 255, 222, 191, 0, 0, 0, 0, 0, 0, 187, 179, 205,
    200, 207, 207, 222, 210, 223, 223, 226, 223, 223, 223, 226, 223, 223, 222, 223,
    226, 221, 207, 199, 201, 202, 198, 208, 195, 213, 213, 203, 213, 213, 213, 205,
    205, 208, 222, 218, 210, 210, 223, 210, 223, 180, 255, 255, 255, 139, 25, 255,
    158, 78, 34, 106, 59, 76, 76, 34, 83, 34, 76, 77, 34, 117, 28, 45,
    35, 77, 27, 66, 75, 31, 74, 76, 21, 77, 255, 39, 25, 255, 106, 36,
    61, 73, 101, 142, 142, 134, 142, 134, 143, 143, 0, 0, 0, 0, 143, 155,
    255, 134, 143, 108, 187, 172, 0, 255, 103, 143, 0, 188, 153, 214, 152, 255,
    255, 255, 255, 243, 202, 187, 187, 0, 0, 0, 0, 187, 179, 208, 202, 221,
    210, 223, 218, 223, 218, 227, 227, 225, 227, 227, 234, 227, 234, 233, 227, 227,
    227, 227, 223, 223, 223, 221, 221, 221, 221, 207, 199, 207, 207, 207, 199, 207,
    199, 226, 212, 186, 211, 211, 226, 221, 207, 201, 221, 247, 255, 255, 138, 10,
    37, 46, 66, 67, 112, 76, 34, 59, 34, 16, 34, 67, 45, 28, 77, 75,
    27, 35, 106, 35, 31, 66, 31, 66, 34, 31, 255, 146, 53, 78, 25, 255,
    73, 73, 134, 73, 142, 134, 134, 0, 143, 143, 143, 0, 0, 0, 0, 143,
    108, 143, 213, 187, 152, 254, 0, 143, 0, 160, 165, 188, 255, 123, 218, 255,
    255, 255, 197, 206, 187, 0, 0, 143, 0, 187, 190, 213, 201, 222, 221, 210,
    218, 218, 227, 225, 225, 238, 238, 238, 238, 238, 238, 238, 186, 225, 225, 238,
    238, 227, 227, 218, 218, 226, 223, 210, 210, 223, 210, 210, 210, 223, 222, 223,
    226, 212, 185, 238, 180, 225, 218, 223, 175, 201, 207, 210, 246, 255, 255, 197,
    37, 255, 169, 88, 43, 75, 34, 34, 112, 76, 34, 67, 76, 35, 75, 77,
    66, 75, 18, 106, 75, 74, 35, 64, 30, 64, 62, 76, 255, 166, 18, 12,
    134, 133, 134, 142, 84, 73, 143, 143, 143, 0, 143, 0, 0, 0, 0, 0,
    0, 143, 255, 102, 0, 0, 154, 165, 0, 122, 41, 236, 162, 211, 255, 255,
    255, 215, 216, 0, 0, 143, 0, 187, 195, 198, 207, 221, 199, 222, 223, 223,
    173, 227, 211, 225, 225, 186, 238, 212, 238, 212, 212, 212, 246, 180, 238, 212,
    186, 211, 211, 225, 227, 218, 218, 173, 226, 210, 222, 226, 173, 226, 223, 218,
    186, 185, 186, 186, 212, 211, 223, 226, 210, 222, 221, 221, 223, 186, 255, 255,
    138, 11, 46, 49, 153, 16, 34, 76, 112, 67, 34, 76, 27, 75, 34, 117,
    31, 35, 35, 66, 35, 64, 31, 75, 110, 30, 31, 66, 137, 20, 59, 67,
    84, 14, 84, 134, 142, 134, 143, 134, 0, 143, 0, 143, 0, 0, 0, 0,
    0, 0, 0, 143, 118, 187, 141, 255, 143, 0, 240, 92, 128, 243, 255, 255,
    215, 209, 0, 0, 187, 142, 195, 213, 202, 207, 221, 210, 222, 225, 235, 239,
    241, 230, 242, 220, 246, 255, 242, 232, 255, 241, 197, 255, 231, 255, 243, 212,
    185, 255, 230, 211, 251, 252, 241, 232, 226, 248, 248, 180, 230, 186, 8, 255,
    255, 255, 252, 186, 180, 226, 218, 210, 210, 210, 210, 222, 222, 223, 232, 255,
    255, 169, 46, 255, 255, 88, 88, 34, 28, 76, 34, 34, 77, 34, 67, 35,
    75, 77, 66, 74, 35, 75, 75, 96, 22, 31, 52, 95, 34, 36, 255, 255,
    84, 145, 84, 84, 143, 73, 143, 142, 0, 143, 143, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 76, 0, 0, 168, 255, 163, 173, 255, 255, 255, 251,
    209, 143, 0, 187, 168, 195, 205, 202, 221, 221, 221, 222, 234, 213, 187, 195,
    191, 198, 203, 199, 232, 191, 207, 197, 191, 210, 222, 194, 239, 198, 204, 255,
    249, 190, 202, 255, 222, 187, 191, 223, 255, 190, 205, 227, 187, 222, 201, 198,
    207, 195, 221, 220, 226, 211, 223, 223, 223, 223, 223, 218, 226, 223, 226, 250,
    255, 255, 128, 46, 31, 100, 196, 112, 62, 77, 34, 76, 55, 76, 77, 35,
    35, 66, 75, 35, 64, 64, 30, 96, 31, 22, 32, 32, 30, 118, 25, 100,
    84, 84, 141, 143, 73, 143, 142, 143, 134, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 146, 175, 0, 52, 199, 186, 255, 255, 252, 222,
    190, 0, 191, 177, 163, 201, 207, 221, 221, 222, 222, 222, 233, 219, 187, 0,
    0, 205, 0, 205, 225, 0, 205, 231, 187, 223, 221, 143, 220, 190, 191, 255,
    232, 143, 202, 181, 143, 201, 201, 143, 242, 191, 191, 180, 187, 199, 207, 190,
    195, 190, 207, 167, 226, 223, 223, 223, 223, 226, 223, 226, 218, 227, 226, 211,
    242, 255, 255, 255, 113, 20, 255, 78, 82, 59, 34, 77, 67, 35, 66, 77,
    31, 75, 35, 35, 74, 75, 64, 74, 64, 32, 95, 110, 96, 46, 66, 64,
    72, 142, 61, 84, 61, 142, 142, 142, 0, 142, 143, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 187, 62, 74, 187, 177, 173, 255, 255, 169, 233, 194,
    0, 194, 207, 221, 221, 221, 221, 221, 221, 221, 222, 210, 222, 196, 207, 143,
    221, 255, 143, 200, 223, 187, 202, 180, 0, 186, 222, 191, 242, 204, 195, 255,
    231, 191, 199, 248, 143, 227, 210, 0, 180, 198, 204, 182, 0, 201, 255, 210,
    143, 212, 255, 173, 218, 223, 218, 223, 226, 226, 218, 218, 227, 226, 218, 227,
    238, 255, 255, 255, 105, 83, 53, 33, 255, 114, 38, 45, 77, 94, 28, 114,
    75, 74, 75, 74, 74, 74, 96, 31, 52, 52, 95, 31, 95, 52, 74, 46,
    0, 93, 73, 142, 134, 133, 0, 143, 133, 0, 143, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 143, 0, 143, 37, 105, 211, 255, 255, 215, 216, 187,
    190, 207, 226, 223, 222, 221, 221, 222, 221, 221, 222, 222, 221, 234, 214, 0,
    160, 255, 0, 213, 222, 0, 192, 223, 0, 183, 221, 187, 197, 204, 203, 255,
    184, 187, 221, 184, 187, 199, 255, 197, 255, 195, 198, 179, 203, 201, 255, 221,
    187, 210, 212, 226, 226, 218, 223, 226, 218, 226, 218, 218, 227, 211, 225, 227,
    211, 220, 255, 255, 100, 255, 158, 34, 255, 59, 125, 67, 35, 35, 27, 74,
    67, 66, 27, 64, 30, 64, 39, 30, 96, 110, 32, 95, 22, 74, 52, 24,
    127, 0, 101, 84, 134, 61, 134, 142, 143, 142, 142, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 187, 161, 155, 160, 123, 254, 255, 254, 223, 191, 0,
    209, 233, 234, 226, 223, 223, 222, 221, 221, 221, 221, 221, 221, 233, 202, 143,
    202, 255, 219, 191, 202, 195, 198, 221, 187, 197, 207, 191, 197, 204, 195, 255,
    184, 191, 207, 184, 191, 221, 203, 187, 212, 192, 204, 202, 203, 207, 255, 207,
    143, 210, 212, 218, 226, 226, 223, 226, 218, 218, 227, 225, 225, 225, 225, 227,
    225, 8, 255, 255, 105, 9, 121, 120, 70, 33, 255, 92, 26, 75, 35, 75,
    31, 64, 64, 35, 64, 31, 74, 22, 96, 23, 110, 32, 113, 30, 113, 52,
    6, 0, 187, 142, 73, 134, 143, 143, 142, 142, 143, 143, 0, 143, 143, 0,
    0, 0, 0, 0, 0, 143, 219, 162, 199, 211, 255, 255, 184, 216, 0, 194,
    233, 180, 180, 218, 223, 210, 222, 221, 222, 221, 221, 221, 221, 233, 200, 0,
    214, 255, 214, 187, 191, 222, 195, 208, 191, 255, 207, 187, 242, 204, 195, 255,
    197, 191, 199, 183, 187, 218, 211, 187, 220, 198, 204, 255, 187, 207, 255, 207,
    0, 223, 185, 226, 226, 218, 218, 227, 226, 211, 225, 225, 225, 225, 238, 180,
    225, 212, 242, 255, 255, 153, 35, 255, 181, 58, 41, 148, 96, 112, 31, 66,
    66, 75, 118, 64, 64, 30, 64, 95, 64, 39, 95, 95, 52, 113, 113, 124,
    143, 160, 255, 143, 142, 142, 84, 143, 142, 134, 143, 143, 0, 0, 143, 0,
    0, 0, 0, 0, 0, 1, 168, 214, 175, 251, 255, 255, 234, 187, 190, 221,
    227, 212, 238, 218, 223, 223, 210, 221, 207, 221, 221, 221, 221, 233, 205, 187,
    214, 255, 201, 0, 187, 212, 198, 190, 194, 255, 202, 187, 197, 198, 193, 226,
    231, 190, 207, 231, 143, 211, 210, 187, 251, 204, 198, 184, 187, 199, 255, 201,
    0, 210, 249, 218, 218, 218, 218, 227, 227, 225, 225, 180, 238, 180, 186, 186,
    238, 186, 184, 255, 255, 255, 131, 33, 25, 113, 126, 43, 255, 153, 57, 34,
    64, 31, 64, 74, 64, 64, 74, 22, 30, 52, 22, 113, 74, 52, 30, 52,
    99, 162, 255, 142, 0, 143, 145, 84, 61, 142, 143, 134, 0, 143, 0, 0,
    0, 0, 0, 0, 143, 1, 155, 214, 123, 255, 255, 181, 221, 191, 217, 223,
    180, 212, 212, 227, 226, 222, 210, 222, 221, 221, 221, 221, 221, 234, 205, 0,
    200, 255, 221, 0, 0, 243, 201, 0, 190, 255, 198, 143, 230, 194, 190, 187,
    180, 187, 198, 255, 192, 0, 192, 191, 212, 194, 194, 186, 0, 200, 255, 201,
    0, 222, 245, 218, 227, 211, 225, 227, 180, 225, 238, 180, 212, 186, 238, 238,
    249, 212, 185, 254, 255, 6, 49, 131, 48, 255, 255, 65, 34, 76, 153, 113,
    30, 74, 114, 23, 66, 64, 74, 64, 113, 52, 64, 52, 113, 74, 22, 46,
    57, 143, 0, 150, 255, 134, 143, 143, 142, 134, 61, 134, 0, 143, 142, 0,
    0, 0, 0, 0, 187, 161, 155, 160, 173, 255, 255, 251, 207, 194, 221, 234,
    212, 212, 212, 225, 218, 223, 221, 222, 221, 221, 221, 221, 222, 222, 223, 229,
    229, 237, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    243, 255, 255, 255, 255, 181, 255, 255, 255, 255, 255, 255, 255, 181, 242, 254,
    243, 225, 227, 211, 227, 227, 225, 227, 225, 180, 186, 238, 212, 238, 212, 212,
    232, 185, 8, 253, 255, 144, 13, 255, 157, 26, 43, 153, 123, 57, 255, 170,
    87, 34, 31, 32, 66, 64, 30, 96, 22, 96, 110, 30, 52, 32, 96, 124,
    0, 103, 11, 0, 12, 143, 73, 143, 134, 84, 142, 101, 187, 143, 142, 143,
    0, 0, 143, 0, 0, 161, 162, 199, 186, 255, 255, 212, 217, 189, 223, 238,
    183, 185, 212, 227, 226, 223, 210, 210, 222, 222, 221, 221, 222, 222, 228, 224,
    0, 143, 187, 179, 190, 190, 203, 204, 204, 195, 198, 192, 195, 205, 190, 247,
    255, 194, 198, 193, 198, 200, 198, 208, 192, 200, 200, 204, 192, 205, 193, 190,
    195, 254, 211, 227, 180, 211, 225, 186, 212, 238, 212, 186, 238, 212, 212, 249,
    185, 232, 184, 242, 255, 255, 49, 33, 64, 184, 97, 9, 255, 86, 21, 62,
    250, 166, 35, 30, 64, 64, 96, 74, 74, 22, 30, 113, 30, 95, 52, 124,
    140, 143, 94, 141, 143, 145, 255, 125, 143, 142, 73, 142, 142, 142, 142, 143,
    134, 0, 0, 0, 143, 161, 162, 199, 249, 255, 255, 225, 195, 216, 233, 212,
    183, 185, 186, 211, 218, 223, 222, 222, 221, 222, 222, 222, 222, 229, 200, 0,
    0, 187, 191, 190, 194, 193, 204, 198, 192, 192, 192, 198, 205, 192, 191, 184,
    255, 190, 205, 208, 205, 208, 208, 200, 202, 200, 202, 200, 202, 200, 192, 204,
    191, 202, 255, 211, 180, 238, 186, 212, 249, 212, 249, 212, 249, 212, 249, 232,
    8, 184, 171, 252, 255, 6, 253, 92, 74, 255, 131, 70, 53, 33, 197, 89,
    6, 255, 57, 62, 118, 64, 74, 74, 52, 96, 32, 32, 95, 110, 52, 33,
    85, 155, 0, 120, 255, 143, 75, 134, 155, 93, 133, 73, 143, 142, 133, 0,
    143, 143, 0, 0, 0, 168, 162, 175, 139, 255, 255, 218, 192, 209, 234, 235,
    183, 248, 235, 225, 218, 226, 223, 223, 222, 223, 210, 222, 234, 226, 0, 187,
    187, 0, 0, 187, 187, 190, 190, 194, 194, 190, 190, 190, 208, 202, 190, 230,
    255, 194, 200, 200, 190, 190, 203, 189, 189, 189, 193, 193, 195, 189, 194, 192,
    201, 187, 227, 2, 180, 212, 249, 212, 212, 212, 232, 212, 232, 232, 232, 185,
    248, 231, 184, 252, 255, 138, 255, 255, 90, 53, 62, 197, 122, 33, 255, 106,
    48, 78, 105, 255, 35, 75, 30, 23, 22, 96, 52, 74, 52, 113, 52, 46,
    97, 255, 141, 0, 29, 140, 98, 0, 255, 118, 0, 143, 134, 142, 73, 134,
    0, 142, 143, 0, 142, 219, 214, 175, 250, 255, 255, 218, 216, 222, 180, 178,
    231, 184, 180, 225, 227, 226, 223, 226, 223, 223, 226, 233, 229, 0, 0, 187,
    0, 238, 227, 211, 225, 225, 180, 238, 238, 238, 238, 232, 195, 200, 190, 215,
    255, 194, 200, 204, 232, 238, 180, 212, 212, 185, 212, 212, 212, 212, 220, 192,
    192, 200, 190, 255, 220, 249, 185, 232, 248, 8, 185, 232, 8, 232, 185, 185,
    184, 231, 247, 253, 255, 255, 121, 30, 253, 158, 38, 255, 174, 26, 57, 52,
    255, 122, 51, 255, 125, 76, 23, 52, 64, 64, 64, 46, 74, 52, 95, 33,
    0, 101, 141, 120, 101, 141, 255, 0, 133, 133, 159, 76, 143, 73, 143, 133,
    134, 0, 143, 143, 0, 135, 214, 175, 250, 255, 255, 233, 201, 210, 235, 239,
    215, 171, 238, 227, 227, 226, 226, 226, 226, 233, 223, 242, 213, 0, 191, 0,
    218, 255, 220, 181, 253, 242, 253, 181, 181, 243, 169, 255, 203, 205, 190, 184,
    255, 194, 200, 194, 255, 255, 253, 254, 254, 255, 255, 255, 255, 6, 255, 197,
    190, 201, 204, 192, 255, 185, 231, 248, 185, 185, 248, 232, 185, 185, 248, 248,
    184, 184, 184, 253, 255, 255, 255, 113, 12, 255, 78, 90, 53, 255, 185, 59,
    255, 131, 38, 48, 37, 255, 114, 76, 30, 96, 52, 74, 113, 32, 113, 33,
    132, 40, 0, 255, 99, 143, 134, 108, 37, 143, 255, 251, 0, 143, 187, 143,
    142, 134, 0, 143, 7, 168, 162, 175, 250, 255, 255, 233, 201, 223, 235, 185,
    231, 247, 212, 218, 218, 218, 226, 218, 226, 226, 243, 221, 0, 190, 0, 201,
    255, 225, 235, 249, 212, 185, 248, 232, 248, 185, 245, 253, 203, 208, 190, 247,
    255, 194, 205, 203, 197, 184, 248, 185, 185, 184, 184, 250, 250, 171, 249, 255,
    173, 190, 207, 190, 210, 255, 185, 184, 248, 185, 185, 185, 185, 184, 184, 184,
    247, 184, 247, 253, 255, 255, 255, 121, 88, 63, 10, 255, 125, 12, 255, 126,
    88, 35, 255, 158, 23, 128, 106, 39, 114, 22, 74, 74, 46, 52, 124, 46,
    51, 20, 187, 65, 143, 103, 99, 143, 255, 0, 0, 134, 157, 254, 0, 142,
    143, 143, 134, 143, 134, 85, 163, 175, 8, 255, 255, 225, 207, 233, 212, 183,
    184, 183, 212, 225, 227, 226, 226, 218, 218, 232, 232, 187, 190, 187, 191, 255,
    186, 212, 185, 185, 231, 231, 185, 184, 231, 231, 184, 181, 203, 205, 190, 231,
    255, 190, 205, 194, 252, 251, 171, 251, 251, 251, 250, 251, 251, 220, 251, 171,
    255, 201, 198, 201, 190, 212, 255, 185, 184, 248, 185, 248, 185, 184, 250, 184,
    251, 184, 247, 181, 255, 255, 100, 52, 255, 157, 33, 255, 83, 71, 63, 255,
    255, 36, 17, 131, 66, 80, 51, 255, 131, 21, 32, 113, 52, 113, 52, 46,
    142, 84, 120, 113, 0, 100, 46, 0, 134, 140, 255, 0, 159, 255, 0, 0,
    143, 84, 142, 142, 61, 161, 163, 199, 121, 255, 255, 212, 210, 226, 235, 183,
    184, 184, 186, 227, 218, 218, 226, 227, 227, 243, 187, 191, 189, 191, 255, 252,
    212, 185, 231, 185, 248, 184, 244, 184, 247, 248, 247, 243, 203, 205, 190, 184,
    255, 194, 200, 203, 6, 251, 247, 251, 251, 220, 174, 251, 251, 251, 220, 220,
    252, 255, 206, 201, 200, 194, 255, 184, 184, 231, 248, 184, 184, 247, 220, 184,
    220, 247, 220, 169, 255, 255, 181, 46, 255, 25, 38, 70, 17, 255, 149, 24,
    20, 66, 127, 19, 255, 181, 48, 69, 122, 139, 113, 32, 33, 32, 46, 33,
    46, 134, 95, 6, 143, 133, 142, 131, 113, 0, 255, 73, 187, 0, 163, 255,
    40, 143, 134, 142, 154, 85, 98, 199, 49, 255, 255, 239, 223, 233, 178, 231,
    251, 231, 186, 227, 218, 218, 227, 186, 212, 6, 210, 0, 204, 190, 181, 252,
    248, 184, 185, 231, 184, 184, 184, 247, 184, 247, 247, 255, 195, 200, 190, 231,
    255, 194, 200, 195, 243, 252, 251, 220, 197, 252, 252, 252, 252, 252, 252, 252,
    253, 255, 192, 201, 195, 222, 255, 185, 247, 184, 184, 184, 251, 184, 251, 220,
    251, 184, 220, 255, 255, 255, 128, 46, 59, 19, 255, 174, 53, 13, 114, 39,
    82, 6, 255, 89, 35, 24, 186, 112, 33, 255, 124, 53, 64, 46, 124, 52,
    12, 73, 0, 134, 107, 255, 0, 75, 100, 0, 0, 134, 255, 27, 135, 255,
    133, 0, 143, 101, 134, 135, 102, 160, 173, 255, 255, 196, 226, 218, 235, 184,
    171, 247, 212, 238, 225, 225, 212, 212, 184, 185, 255, 190, 193, 190, 200, 255,
    232, 248, 247, 184, 231, 247, 247, 247, 247, 184, 230, 255, 195, 200, 190, 230,
    255, 194, 200, 195, 255, 197, 220, 252, 220, 197, 252, 197, 252, 197, 252, 220,
    255, 210, 193, 201, 193, 255, 220, 184, 251, 184, 184, 247, 251, 220, 230, 220,
    220, 220, 252, 255, 255, 253, 32, 9, 255, 71, 51, 25, 83, 150, 24, 255,
    158, 48, 33, 22, 158, 89, 255, 255, 57, 62, 35, 243, 37, 74, 33, 46,
    143, 101, 255, 40, 164, 255, 187, 134, 187, 41, 169, 0, 110, 36, 0, 187,
    98, 255, 111, 0, 134, 84, 98, 160, 123, 254, 255, 169, 225, 233, 232, 139,
    184, 251, 212, 238, 238, 238, 212, 249, 183, 185, 255, 218, 187, 202, 187, 238,
    254, 250, 182, 247, 184, 184, 184, 251, 184, 247, 220, 255, 195, 200, 190, 220,
    255, 203, 200, 195, 255, 197, 252, 220, 252, 252, 197, 252, 197, 252, 252, 181,
    255, 189, 207, 195, 210, 255, 184, 251, 247, 251, 184, 251, 182, 251, 220, 251,
    247, 220, 197, 255, 255, 255, 144, 33, 20, 114, 127, 26, 255, 255, 90, 52,
    96, 139, 71, 13, 255, 66, 57, 62, 2, 166, 76, 255, 121, 89, 39, 15,
    46, 0, 254, 54, 134, 0, 89, 255, 134, 214, 69, 142, 0, 0, 255, 255,
    143, 130, 140, 135, 93, 61, 99, 50, 159, 250, 255, 255, 212, 227, 235, 184,
    230, 184, 249, 180, 225, 180, 232, 249, 184, 184, 231, 255, 194, 190, 189, 210,
    255, 184, 184, 250, 247, 247, 247, 184, 230, 184, 247, 255, 195, 200, 194, 230,
    255, 203, 202, 195, 255, 253, 220, 220, 197, 220, 252, 220, 252, 220, 251, 255,
    210, 204, 201, 193, 255, 252, 247, 230, 251, 184, 251, 220, 220, 220, 220, 220,
    251, 220, 138, 255, 255, 9, 121, 92, 90, 20, 255, 118, 62, 74, 92, 124,
    27, 255, 174, 82, 76, 15, 255, 89, 12, 255, 59, 36, 67, 255, 251, 30,
    124, 143, 142, 134, 255, 22, 187, 12, 143, 101, 0, 148, 255, 72, 142, 102,
    141, 143, 134, 255, 25, 187, 143, 60, 127, 186, 255, 255, 220, 180, 238, 182,
    230, 251, 212, 238, 225, 238, 212, 212, 212, 184, 185, 197, 247, 252, 255, 255,
    232, 184, 184, 247, 184, 184, 247, 247, 247, 232, 255, 223, 190, 201, 190, 183,
    255, 203, 202, 195, 255, 253, 220, 220, 220, 252, 220, 252, 220, 220, 181, 255,
    189, 207, 189, 210, 255, 183, 220, 184, 247, 220, 220, 220, 220, 251, 220, 220,
    220, 252, 255, 255, 255, 121, 52, 255, 170, 63, 24, 114, 212, 90, 255, 255,
    90, 62, 34, 255, 96, 24, 255, 149, 48, 78, 13, 255, 112, 9, 128, 112,
    142, 69, 255, 187, 146, 60, 134, 187, 98, 255, 43, 143, 95, 134, 98, 143,
    6, 255, 0, 143, 142, 109, 71, 155, 56, 92, 255, 255, 181, 235, 212, 231,
    230, 251, 185, 238, 227, 225, 225, 225, 238, 238, 232, 212, 220, 220, 185, 185,
    231, 248, 231, 247, 184, 247, 247, 184, 248, 255, 184, 187, 201, 195, 201, 255,
    197, 195, 202, 193, 255, 197, 220, 252, 220, 197, 252, 220, 252, 247, 255, 210,
    193, 201, 193, 255, 220, 247, 251, 182, 251, 230, 251, 251, 220, 220, 220, 251,
    220, 242, 255, 255, 255, 255, 123, 74, 52, 49, 127, 69, 255, 124, 47, 53,
    11, 181, 62, 255, 169, 82, 57, 22, 255, 92, 69, 255, 114, 28, 120, 255,
    102, 162, 69, 0, 93, 143, 255, 255, 0, 94, 133, 164, 143, 89, 255, 70,
    0, 111, 155, 33, 143, 255, 6, 143, 155, 123, 252, 255, 255, 183, 235, 183,
    230, 220, 185, 186, 227, 227, 233, 225, 238, 225, 238, 212, 212, 232, 232, 231,
    185, 185, 248, 231, 231, 184, 184, 184, 252, 255, 190, 200, 200, 189, 255, 255,
    197, 195, 202, 195, 255, 242, 220, 220, 220, 220, 220, 220, 220, 253, 255, 189,
    207, 189, 210, 255, 183, 251, 230, 251, 247, 251, 220, 251, 220, 220, 220, 220,
    220, 169, 255, 255, 144, 100, 100, 100, 57, 255, 255, 58, 53, 23, 255, 55,
    51, 255, 132, 57, 38, 255, 176, 34, 6, 153, 83, 19, 11, 255, 46, 37,
    99, 40, 143, 131, 255, 187, 164, 62, 84, 85, 143, 255, 255, 143, 111, 134,
    151, 134, 130, 255, 187, 0, 143, 100, 20, 126, 49, 255, 255, 197, 212, 178,
    247, 220, 185, 238, 227, 218, 227, 234, 238, 238, 238, 234, 238, 246, 212, 235,
    232, 185, 185, 185, 231, 247, 184, 248, 255, 200, 195, 201, 190, 182, 255, 181,
    242, 195, 200, 193, 255, 253, 251, 220, 252, 220, 252, 197, 184, 255, 210, 193,
    201, 195, 255, 220, 251, 247, 251, 230, 220, 220, 220, 220, 220, 220, 220, 220,
    197, 255, 255, 255, 253, 113, 13, 255, 122, 57, 53, 3, 166, 16, 255, 100,
    58, 82, 11, 255, 127, 51, 10, 112, 120, 35, 255, 174, 34, 20, 149, 92,
    101, 255, 34, 143, 94, 145, 28, 0, 128, 255, 133, 0, 142, 109, 56, 101,
    255, 75, 143, 0, 102, 255, 134, 146, 255, 143, 175, 181, 255, 255, 184, 239,
    231, 251, 184, 212, 227, 226, 234, 238, 235, 239, 231, 235, 235, 238, 212, 246,
    238, 235, 232, 232, 248, 231, 185, 255, 221, 190, 201, 195, 226, 255, 184, 254,
    197, 195, 202, 195, 255, 242, 220, 220, 220, 220, 220, 220, 253, 255, 189, 207,
    194, 210, 255, 184, 247, 251, 230, 251, 251, 220, 220, 220, 220, 252, 251, 220,
    253, 255, 255, 128, 255, 105, 48, 62, 33, 255, 89, 9, 255, 90, 90, 62,
    255, 158, 35, 138, 35, 120, 86, 255, 255, 83, 25, 153, 52, 122, 25, 255,
    143, 94, 79, 122, 143, 159, 255, 63, 143, 140, 97, 123, 142, 255, 255, 143,
    142, 143, 255, 59, 79, 255, 134, 0, 84, 8, 255, 49, 255, 255, 197, 239,
    231, 247, 184, 212, 225, 218, 233, 238, 232, 245, 239, 231, 239, 235, 235, 212,
    235, 212, 246, 249, 235, 185, 232, 255, 202, 195, 202, 192, 255, 252, 230, 254,
    197, 195, 202, 193, 255, 197, 220, 220, 220, 252, 220, 184, 255, 222, 193, 201,
    193, 255, 220, 230, 230, 251, 220, 220, 220, 220, 220, 220, 252, 220, 220, 197,
    255, 255, 255, 10, 33, 66, 255, 113, 31, 255, 114, 63, 63, 6, 255, 88,
    13, 100, 71, 82, 30, 255, 92, 30, 104, 32, 46, 59, 255, 255, 83, 33,
    60, 99, 134, 255, 9, 143, 111, 134, 152, 134, 122, 255, 142, 143, 142, 123,
    13, 133, 255, 22, 187, 142, 40, 255, 102, 126, 6, 109, 253, 255, 255, 184,
    183, 247, 251, 249, 225, 218, 226, 238, 235, 239, 220, 241, 220, 230, 239, 245,
    235, 238, 235, 212, 246, 235, 249, 252, 242, 191, 201, 189, 218, 255, 184, 254,
    197, 195, 200, 195, 255, 197, 220, 220, 220, 197, 220, 253, 255, 189, 201, 189,
    210, 255, 184, 247, 251, 184, 220, 220, 220, 252, 220, 220, 220, 220, 220, 253,
    255, 255, 253, 105, 220, 34, 255, 105, 97, 63, 24, 255, 149, 33, 255, 120,
    71, 57, 255, 170, 62, 13, 46, 52, 89, 5, 255, 113, 22, 92, 100, 153,
    131, 255, 143, 133, 84, 115, 60, 108, 255, 12, 143, 143, 98, 255, 93, 104,
    255, 143, 0, 0, 255, 5, 142, 104, 82, 0, 0, 49, 255, 255, 255, 242,
    231, 184, 184, 248, 186, 227, 233, 233, 235, 231, 244, 220, 220, 220, 220, 231,
    239, 231, 246, 246, 212, 212, 235, 238, 255, 207, 195, 202, 204, 255, 251, 254,
    197, 195, 200, 195, 255, 252, 247, 251, 247, 220, 184, 255, 210, 193, 201, 195,
    255, 252, 247, 220, 184, 220, 220, 220, 220, 220, 220, 220, 220, 220, 252, 254,
    255, 255, 144, 10, 255, 67, 90, 48, 255, 174, 86, 255, 124, 36, 70, 13,
    255, 83, 30, 124, 66, 127, 31, 255, 167, 62, 124, 33, 8, 83, 9, 255,
    143, 84, 115, 17, 0, 255, 255, 0, 0, 134, 128, 23, 108, 255, 102, 0,
    142, 113, 255, 133, 112, 69, 0, 0, 142, 255, 128, 115, 167, 6, 255, 255,
    230, 231, 247, 183, 232, 180, 218, 218, 238, 239, 231, 230, 220, 252, 220, 252,
    247, 231, 231, 239, 235, 238, 212, 238, 220, 252, 187, 201, 194, 226, 255, 242,
    197, 203, 202, 195, 255, 197, 251, 230, 251, 251, 252, 255, 194, 207, 189, 210,
    255, 231, 220, 230, 251, 220, 220, 220, 220, 252, 220, 252, 220, 252, 242, 255,
    255, 255, 105, 64, 89, 33, 255, 120, 136, 136, 71, 38, 18, 255, 158, 53,
    104, 83, 118, 38, 255, 255, 89, 33, 52, 121, 39, 25, 255, 131, 59, 46,
    46, 73, 157, 255, 70, 0, 142, 114, 3, 133, 255, 17, 0, 143, 141, 255,
    59, 134, 255, 0, 143, 187, 255, 255, 133, 108, 126, 98, 199, 105, 255, 255,
    197, 184, 184, 250, 232, 225, 227, 226, 234, 238, 239, 247, 230, 220, 220, 220,
    220, 230, 247, 231, 239, 245, 238, 238, 225, 255, 207, 194, 200, 204, 255, 181,
    220, 195, 200, 195, 254, 220, 247, 220, 220, 182, 255, 210, 193, 201, 195, 255,
    220, 220, 251, 251, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 254, 255,
    255, 10, 37, 255, 37, 30, 255, 83, 71, 29, 255, 255, 90, 25, 118, 46,
    87, 25, 255, 92, 76, 64, 37, 49, 27, 255, 169, 71, 34, 46, 255, 131,
    255, 51, 0, 142, 101, 255, 72, 159, 255, 0, 143, 133, 255, 255, 143, 156,
    89, 187, 143, 106, 255, 82, 142, 147, 143, 73, 143, 255, 255, 28, 169, 255,
    255, 220, 231, 231, 185, 212, 227, 226, 233, 238, 235, 244, 230, 220, 197, 220,
    220, 220, 220, 230, 244, 231, 239, 212, 238, 245, 184, 191, 202, 194, 223, 255,
    220, 194, 200, 195, 243, 252, 220, 251, 220, 253, 255, 189, 201, 189, 210, 255,
    184, 251, 230, 220, 220, 220, 220, 252, 220, 252, 220, 220, 252, 181, 255, 255,
    255, 255, 96, 9, 100, 89, 54, 33, 255, 118, 45, 131, 28, 122, 21, 255,
    170, 48, 95, 64, 121, 83, 9, 255, 122, 83, 35, 253, 166, 31, 255, 100,
    142, 142, 137, 37, 97, 255, 91, 0, 0, 123, 255, 134, 165, 136, 0, 143,
    142, 255, 12, 143, 110, 141, 163, 143, 45, 255, 34, 142, 155, 123, 138, 255,
    255, 242, 184, 184, 231, 232, 180, 218, 233, 234, 238, 235, 231, 230, 241, 220,
    252, 220, 252, 220, 220, 230, 231, 245, 232, 234, 255, 207, 190, 208, 189, 255,
    197, 194, 200, 203, 181, 252, 184, 220, 184, 255, 210, 193, 201, 195, 255, 252,
    220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 252, 220, 197, 181, 255, 255,
    6, 128, 46, 59, 53, 255, 170, 57, 25, 112, 32, 82, 9, 255, 78, 78,
    77, 17, 157, 35, 255, 156, 48, 35, 17, 255, 122, 9, 255, 132, 112, 37,
    5, 134, 255, 255, 187, 0, 134, 254, 49, 134, 255, 101, 143, 143, 169, 255,
    143, 140, 129, 99, 61, 72, 255, 41, 0, 102, 145, 32, 98, 9, 255, 251,
    255, 255, 220, 184, 248, 232, 246, 211, 218, 226, 234, 246, 239, 230, 220, 220,
    220, 220, 220, 220, 220, 220, 247, 231, 248, 245, 244, 230, 190, 208, 190, 238,
    255, 190, 205, 195, 243, 220, 247, 220, 197, 255, 189, 201, 189, 210, 255, 184,
    230, 251, 220, 220, 251, 220, 220, 220, 252, 220, 220, 252, 242, 255, 255, 255,
    121, 122, 128, 255, 36, 33, 96, 89, 83, 18, 255, 158, 63, 45, 66, 250,
    19, 255, 255, 78, 34, 66, 255, 92, 25, 255, 113, 59, 36, 255, 255, 52,
    255, 134, 0, 143, 255, 255, 134, 176, 33, 143, 133, 119, 255, 115, 84, 51,
    143, 102, 187, 255, 255, 187, 0, 133, 132, 155, 47, 255, 74, 142, 32, 144,
    255, 255, 181, 230, 184, 248, 212, 180, 227, 218, 233, 234, 235, 231, 220, 220,
    252, 220, 220, 252, 230, 220, 243, 242, 231, 184, 244, 243, 203, 198, 190, 239,
    243, 190, 200, 203, 242, 220, 247, 184, 255, 210, 204, 201, 193, 255, 220, 220,
    251, 220, 220, 220, 220, 220, 252, 220, 220, 252, 220, 252, 243, 255, 255, 3,
    255, 20, 45, 146, 28, 118, 58, 255, 255, 58, 94, 34, 252, 120, 69, 255,
    96, 115, 62, 5, 176, 77, 255, 174, 71, 78, 25, 255, 124, 25, 128, 114,
    0, 115, 255, 38, 111, 254, 142, 142, 143, 255, 10, 187, 95, 108, 102, 134,
    131, 255, 70, 0, 134, 98, 39, 134, 255, 255, 143, 142, 72, 6, 39, 49,
    255, 255, 255, 220, 231, 183, 185, 249, 225, 226, 227, 234, 238, 245, 230, 230,
    220, 220, 220, 247, 255, 255, 220, 242, 252, 247, 220, 243, 203, 198, 190, 235,
    181, 190, 205, 194, 242, 220, 184, 252, 255, 189, 201, 189, 210, 255, 184, 220,
    220, 220, 220, 220, 220, 220, 197, 220, 220, 252, 220, 197, 255, 255, 255, 121,
    20, 124, 39, 80, 37, 255, 114, 78, 36, 100, 49, 62, 255, 144, 88, 59,
    33, 255, 106, 20, 255, 127, 62, 59, 255, 197, 35, 6, 92, 64, 21, 6,
    20, 133, 128, 53, 187, 187, 137, 255, 142, 126, 34, 140, 85, 93, 255, 100,
    143, 72, 140, 11, 142, 69, 255, 29, 143, 0, 37, 17, 93, 255, 49, 99,
    153, 255, 255, 254, 184, 231, 185, 212, 238, 227, 226, 233, 238, 235, 239, 230,
    230, 252, 220, 255, 221, 192, 190, 207, 255, 184, 220, 243, 195, 208, 190, 232,
    242, 190, 205, 194, 197, 230, 232, 255, 222, 193, 201, 195, 255, 252, 220, 220,
    220, 220, 220, 252, 220, 220, 220, 220, 220, 220, 197, 6, 255, 255, 253, 100,
    113, 34, 255, 174, 29, 34, 34, 251, 38, 9, 255, 57, 63, 36, 255, 158,
    35, 255, 131, 78, 71, 20, 255, 106, 20, 156, 114, 59, 33, 255, 158, 31,
    37, 143, 187, 97, 255, 30, 143, 13, 101, 102, 143, 255, 255, 187, 101, 108,
    92, 60, 87, 255, 33, 143, 0, 99, 6, 40, 51, 255, 143, 101, 82, 255,
    105, 10, 255, 255, 242, 185, 248, 232, 186, 225, 218, 226, 233, 238, 235, 247,
    220, 220, 230, 255, 210, 190, 207, 189, 197, 243, 252, 255, 195, 200, 190, 239,
    243, 190, 192, 194, 3, 244, 220, 255, 194, 201, 189, 210, 255, 184, 220, 247,
    220, 220, 220, 220, 252, 220, 252, 220, 220, 220, 242, 255, 255, 255, 49, 6,
    255, 88, 62, 76, 20, 152, 31, 255, 113, 58, 57, 131, 255, 59, 6, 138,
    78, 89, 23, 255, 153, 31, 6, 96, 122, 36, 255, 255, 120, 25, 124, 37,
    143, 255, 255, 143, 150, 88, 81, 133, 117, 255, 53, 143, 111, 19, 15, 133,
    255, 255, 0, 0, 134, 12, 55, 58, 255, 97, 143, 133, 104, 255, 72, 139,
    10, 152, 255, 255, 255, 230, 185, 232, 232, 186, 225, 218, 233, 234, 238, 231,
    230, 251, 251, 220, 255, 204, 202, 192, 207, 255, 220, 255, 213, 200, 190, 231,
    243, 190, 198, 194, 197, 185, 255, 222, 189, 201, 203, 255, 220, 251, 251, 220,
    220, 220, 220, 220, 220, 220, 220, 220, 220, 197, 169, 255, 255, 255, 139, 59,
    118, 37, 139, 29, 255, 169, 97, 87, 45, 255, 114, 33, 255, 106, 38, 88,
    6, 255, 76, 9, 153, 28, 89, 17, 255, 92, 30, 100, 92, 123, 22, 255,
    34, 0, 74, 98, 98, 79, 255, 9, 187, 133, 97, 105, 84, 149, 255, 134,
    0, 187, 95, 12, 108, 255, 136, 0, 143, 82, 255, 88, 126, 255, 142, 93,
    82, 255, 255, 255, 255, 197, 231, 185, 232, 212, 225, 227, 218, 233, 234, 235,
    244, 230, 230, 184, 255, 227, 194, 207, 189, 242, 255, 255, 193, 200, 194, 230,
    255, 190, 205, 194, 241, 241, 181, 190, 201, 194, 210, 255, 184, 230, 220, 251,
    220, 220, 220, 220, 220, 252, 220, 220, 220, 253, 255, 255, 6, 104, 15, 138,
    127, 15, 255, 132, 63, 82, 6, 167, 62, 255, 131, 71, 80, 46, 255, 114,
    25, 137, 56, 67, 76, 255, 174, 53, 104, 46, 49, 53, 6, 255, 112, 64,
    98, 56, 142, 136, 255, 134, 134, 63, 95, 28, 93, 255, 69, 0, 143, 89,
    255, 97, 36, 255, 79, 143, 0, 255, 137, 133, 255, 115, 143, 142, 25, 255,
    107, 152, 138, 252, 255, 255, 251, 232, 232, 212, 238, 211, 218, 226, 233, 238,
    232, 244, 215, 220, 230, 255, 193, 202, 192, 207, 255, 255, 204, 202, 190, 230,
    255, 194, 208, 194, 244, 255, 222, 194, 202, 194, 255, 247, 250, 184, 230, 220,
    220, 220, 220, 220, 220, 220, 220, 220, 252, 243, 255, 255, 255, 121, 52, 255,
    156, 65, 87, 15, 255, 71, 20, 255, 81, 87, 36, 255, 184, 45, 6, 96,
    67, 115, 9, 255, 76, 33, 124, 37, 159, 15, 255, 158, 36, 74, 49, 10, 
    108, 255, 51, 187, 111, 60, 20, 134, 167, 255, 187, 101, 40, 255, 22, 133, 
    252, 45, 187, 0, 75, 255, 40, 124, 144, 0, 143, 108, 255, 11, 134, 136, 
    40, 83, 127, 255, 255, 255, 181, 184, 232, 249, 232, 186, 218, 218, 233, 234, 
    246, 245, 184, 244, 183, 255, 225, 190, 207, 194, 181, 255, 195, 202, 194, 251, 
    255, 194, 208, 194, 242, 243, 191, 202, 190, 222, 255, 185, 247, 184, 247, 182, 
    251, 220, 230, 220, 220, 220, 220, 251, 242, 255, 255, 253, 255, 255, 89, 71, 
    21, 255, 131, 62, 255, 118, 48, 82, 20, 255, 83, 20, 100, 112, 89, 52, 
    255, 153, 35, 146, 64, 92, 59, 255, 255, 53, 66, 52, 6, 149, 20, 255, 
    73, 134, 97, 9, 40, 125, 255, 29, 143, 101, 104, 105, 101, 32, 128, 143, 
    187, 79, 255, 25, 93, 255, 72, 142, 143, 255, 255, 143, 165, 125, 141, 84, 
    95, 255, 46, 127, 242, 255, 255, 220, 232, 232, 232, 238, 225, 227, 226, 233, 
    234, 245, 231, 231, 244, 184, 255, 193, 202, 204, 207, 255, 195, 200, 194, 220, 
    255, 194, 200, 190, 255, 221, 194, 202, 194, 255, 247, 183, 250, 247, 247, 247, 
    230, 230, 251, 230, 251, 247, 220, 220, 254, 255, 255, 252, 113, 59, 9, 255, 
    80, 6, 144, 126, 63, 74, 255, 106, 33, 128, 76, 67, 53, 255, 255, 38, 
    146, 52, 131, 71, 20, 255, 96, 36, 122, 17, 121, 31, 255, 166, 76, 22, 
    83, 39, 79, 173, 136, 143, 70, 107, 255, 82, 126, 255, 134, 0, 142, 20, 
    255, 79, 157, 69, 142, 134, 115, 255, 47, 107, 100, 134, 40, 134, 255, 255, 
    143, 120, 56, 100, 10, 255, 255, 181, 185, 212, 212, 238, 225, 218, 226, 226, 
    227, 235, 239, 231, 247, 235, 255, 218, 194, 201, 190, 255, 205, 202, 194, 182, 
    255, 203, 208, 213, 255, 190, 206, 194, 221, 255, 232, 248, 231, 231, 184, 184, 
    247, 184, 247, 247, 184, 231, 245, 242, 255, 255, 138, 20, 255, 32, 69, 255, 
    89, 48, 58, 255, 242, 57, 105, 118, 67, 88, 17, 255, 67, 124, 131, 32, 
    39, 27, 255, 167, 53, 30, 96, 105, 34, 255, 255, 36, 76, 23, 255, 166, 
    115, 255, 133, 133, 72, 10, 32, 101, 180, 75, 143, 101, 89, 255, 60, 140, 
    128, 79, 143, 133, 255, 5, 134, 128, 111, 99, 142, 138, 255, 101, 101, 154, 
    115, 83, 71, 255, 144, 139, 255, 255, 220, 185, 212, 246, 180, 227, 218, 226, 
    233, 238, 246, 239, 231, 230, 231, 255, 203, 206, 193, 221, 201, 208, 190, 247, 
    255, 194, 205, 202, 210, 194, 200, 190, 255, 247, 248, 185, 248, 231, 245, 248, 
    231, 248, 184, 231, 247, 247, 220, 255, 255, 255, 253, 37, 255, 153, 38, 65, 
    13, 255, 115, 69, 104, 71, 53, 16, 255, 144, 88, 17, 64, 92, 71, 255, 
    255, 120, 75, 77, 49, 92, 33, 255, 92, 89, 59, 17, 255, 64, 6, 144, 
    143, 101, 74, 105, 101, 123, 137, 134, 79, 84, 255, 25, 0, 149, 86, 134, 
    0, 124, 255, 133, 149, 131, 101, 79, 107, 255, 33, 142, 117, 99, 110, 134, 
    255, 255, 93, 134, 50, 138, 255, 255, 255, 248, 212, 212, 238, 225, 226, 226, 
    218, 233, 246, 235, 235, 231, 232, 255, 218, 190, 201, 198, 208, 200, 190, 230, 
    255, 194, 200, 208, 204, 202, 190, 221, 255, 235, 232, 248, 245, 232, 185, 239, 
    245, 248, 231, 248, 184, 247, 253, 255, 255, 255, 138, 113, 59, 59, 255, 186, 
    53, 104, 27, 27, 54, 255, 255, 78, 37, 64, 92, 83, 25, 255, 153, 36, 
    75, 15, 171, 16, 255, 170, 38, 120, 22, 255, 113, 17, 255, 64, 66, 92, 
    20, 59, 133, 255, 54, 93, 79, 136, 255, 134, 127, 33, 93, 142, 93, 255, 
    51, 142, 128, 40, 54, 133, 255, 255, 187, 76, 111, 28, 79, 46, 255, 86, 
    0, 0, 59, 9, 66, 255, 255, 255, 255, 252, 232, 238, 180, 225, 226, 218, 
    226, 234, 234, 246, 235, 245, 244, 230, 255, 203, 208, 208, 200, 200, 190, 244, 
    255, 194, 200, 200, 208, 208, 190, 255, 244, 185, 239, 232, 183, 232, 245, 185, 
    248, 245, 231, 248, 232, 247, 255, 255, 255, 139, 64, 255, 255, 48, 136, 131, 
    83, 102, 25, 255, 114, 18, 131, 114, 39, 36, 255, 169, 80, 114, 110, 171, 
    28, 12, 255, 127, 36, 78, 255, 184, 35, 255, 153, 67, 83, 20, 255, 124, 
    49, 69, 142, 72, 48, 255, 82, 102, 136, 84, 73, 134, 152, 255, 133, 150, 
    36, 102, 134, 116, 255, 93, 140, 125, 60, 19, 101, 255, 9, 0, 133, 97, 
    254, 60, 37, 255, 71, 80, 131, 255, 255, 255, 184, 186, 238, 227, 218, 218, 
    233, 227, 238, 238, 238, 235, 239, 232, 255, 218, 191, 202, 208, 200, 190, 239, 
    243, 190, 208, 208, 200, 190, 221, 255, 212, 232, 245, 185, 245, 239, 185, 232, 
    239, 245, 231, 245, 231, 253, 255, 255, 255, 255, 131, 22, 144, 27, 89, 44, 
    255, 169, 58, 124, 106, 37, 38, 12, 255, 130, 59, 118, 11, 131, 31, 255, 
    158, 57, 36, 100, 255, 106, 12, 128, 83, 59, 23, 255, 139, 30, 128, 92, 
    101, 133, 255, 15, 133, 255, 29, 145, 134, 69, 255, 58, 108, 118, 102, 85, 
    101, 255, 13, 187, 146, 29, 39, 133, 255, 255, 134, 101, 108, 105, 22, 90, 
    255, 23, 134, 143, 56, 255, 92, 253, 255, 255, 242, 212, 180, 227, 218, 226, 
    226, 233, 234, 238, 235, 235, 245, 235, 239, 255, 203, 208, 208, 200, 190, 239, 
    255, 194, 200, 200, 208, 190, 255, 244, 232, 245, 245, 232, 248, 232, 245, 248, 
    248, 183, 239, 248, 252, 255, 255, 255, 11, 105, 15, 113, 54, 6, 255, 80, 
    76, 74, 64, 114, 35, 255, 156, 63, 64, 15, 252, 59, 255, 255, 88, 53, 
    34, 255, 153, 15, 255, 64, 83, 89, 9, 255, 28, 137, 100, 39, 122, 13, 
    5, 133, 100, 25, 84, 101, 97, 255, 25, 142, 110, 40, 102, 142, 51, 255, 
    133, 102, 120, 120, 40, 119, 255, 76, 143, 107, 132, 9, 101, 255, 255, 142, 
    143, 101, 255, 17, 78, 255, 110, 39, 254, 255, 255, 231, 225, 218, 218, 218, 
    226, 227, 234, 234, 246, 238, 235, 235, 246, 255, 226, 191, 206, 200, 190, 245, 
    243, 190, 208, 202, 191, 221, 255, 212, 232, 232, 248, 248, 232, 245, 239, 248, 
    245, 231, 248, 231, 242, 255, 255, 138, 121, 66, 52, 255, 100, 58, 124, 22, 
    151, 47, 255, 255, 80, 76, 62, 253, 152, 25, 255, 113, 88, 78, 2, 181, 
    34, 255, 121, 78, 71, 25, 255, 113, 69, 105, 114, 39, 27, 255, 254, 114, 
    104, 93, 97, 101, 255, 255, 142, 132, 57, 140, 79, 107, 255, 52, 133, 64, 
    115, 67, 133, 255, 255, 0, 111, 72, 6, 40, 157, 255, 93, 143, 134, 92, 
    255, 111, 255, 100, 133, 108, 39, 255, 144, 255, 255, 243, 238, 218, 226, 226, 
    226, 218, 234, 234, 234, 238, 235, 232, 239, 235, 255, 194, 192, 200, 190, 231, 
    243, 194, 200, 200, 190, 243, 231, 232, 248, 239, 239, 232, 239, 248, 231, 231, 
    231, 231, 231, 252, 255, 255, 255, 100, 255, 255, 81, 52, 27, 11, 80, 69, 
    255, 112, 53, 67, 25, 139, 76, 255, 105, 29, 120, 95, 255, 39, 51, 255, 
    127, 59, 89, 255, 170, 27, 144, 96, 113, 83, 13, 255, 114, 46, 92, 49, 
    134, 77, 255, 40, 141, 74, 60, 98, 133, 255, 255, 134, 102, 82, 114, 93, 
    83, 255, 72, 93, 97, 15, 15, 72, 255, 25, 143, 142, 120, 255, 29, 124, 
    255, 101, 101, 134, 255, 255, 54, 128, 49, 10, 255, 255, 250, 226, 223, 223, 
    226, 218, 227, 234, 234, 234, 238, 235, 235, 246, 243, 223, 0, 194, 0, 235, 
    255, 0, 190, 0, 221, 255, 246, 235, 232, 245, 185, 245, 248, 231, 245, 231, 
    184, 247, 220, 255, 255, 255, 255, 100, 96, 46, 49, 46, 53, 255, 176, 65, 
    78, 23, 255, 56, 13, 255, 120, 38, 36, 255, 171, 43, 255, 124, 120, 57, 
    9, 255, 28, 25, 100, 67, 112, 33, 255, 166, 55, 131, 124, 11, 27, 255, 
    54, 93, 136, 29, 71, 142, 136, 255, 79, 93, 82, 56, 47, 97, 255, 17, 
    0, 107, 90, 9, 101, 128, 255, 142, 79, 93, 255, 37, 82, 255, 89, 133, 
    143, 131, 255, 47, 113, 103, 40, 83, 122, 255, 255, 255, 255, 227, 210, 223, 
    226, 233, 227, 225, 227, 238, 246, 238, 238, 235, 235, 241, 210, 226, 210, 231, 
    241, 210, 226, 210, 241, 231, 232, 239, 232, 248, 239, 231, 231, 231, 247, 184, 
    247, 220, 253, 255, 255, 138, 144, 37, 121, 71, 6, 255, 102, 86, 78, 5, 
    131, 22, 255, 124, 48, 86, 20, 255, 127, 12, 105, 59, 71, 32, 255, 158, 
    35, 10, 114, 92, 89, 255, 255, 83, 124, 95, 17, 152, 51, 255, 157, 55, 
    60, 81, 101, 87, 255, 24, 0, 82, 82, 28, 101, 255, 255, 134, 108, 97, 
    13, 28, 108, 255, 57, 134, 101, 17, 255, 101, 174, 103, 142, 143, 140, 255, 
    17, 65, 170, 97, 54, 133, 255, 255, 107, 113, 128, 255, 255, 243, 223, 210, 
    226, 233, 227, 234, 234, 225, 238, 235, 238, 235, 238, 235, 243, 242, 243, 247, 
    247, 243, 243, 243, 239, 235, 232, 185, 239, 231, 248, 184, 247, 247, 184, 247, 
    247, 220, 255, 255, 255, 6, 92, 25, 255, 157, 70, 53, 17, 242, 80, 255, 
    255, 82, 86, 34, 255, 92, 52, 255, 114, 89, 63, 255, 255, 59, 104, 124, 
    46, 120, 20, 255, 96, 52, 37, 46, 49, 66, 255, 197, 56, 66, 37, 181, 
    82, 29, 71, 133, 163, 108, 52, 54, 117, 255, 34, 143, 108, 124, 11, 79, 
    255, 128, 142, 133, 107, 255, 81, 120, 255, 79, 134, 142, 255, 255, 108, 121, 
    118, 72, 79, 106, 255, 83, 108, 113, 56, 49, 46, 255, 255, 255, 245, 226, 
    226, 226, 227, 227, 225, 238, 235, 238, 212, 235, 232, 246, 246, 232, 235, 231, 
    244, 235, 246, 232, 249, 232, 232, 245, 248, 184, 184, 244, 247, 247, 247, 230, 
    220, 254, 255, 255, 105, 255, 255, 88, 59, 35, 255, 83, 69, 255, 78, 88, 
    87, 6, 254, 59, 255, 158, 36, 80, 17, 255, 110, 32, 104, 39, 55, 16, 
    255, 174, 78, 46, 113, 11, 67, 9, 255, 114, 34, 23, 138, 186, 33, 255, 
    102, 81, 90, 38, 40, 102, 255, 6, 0, 134, 47, 6, 102, 124, 254, 79, 
    79, 134, 138, 20, 101, 255, 106, 134, 142, 124, 255, 82, 125, 124, 72, 72, 
    133, 255, 255, 134, 146, 88, 39, 70, 121, 255, 83, 113, 255, 255, 255, 232, 
    226, 226, 227, 225, 234, 246, 238, 238, 246, 246, 232, 185, 232, 232, 232, 248, 
    231, 245, 232, 232, 232, 248, 244, 231, 184, 247, 247, 247, 247, 230, 247, 220, 
    254, 255, 255, 255, 121, 37, 67, 9, 186, 78, 255, 131, 54, 82, 92, 255, 
    106, 25, 170, 59, 71, 36, 255, 174, 53, 10, 96, 46, 38, 255, 255, 83, 
    74, 30, 49, 32, 15, 255, 180, 59, 39, 25, 181, 114, 255, 128, 28, 66, 
    29, 107, 60, 90, 48, 47, 101, 72, 17, 32, 111, 255, 22, 134, 79, 106, 
    255, 40, 131, 128, 101, 101, 101, 255, 10, 133, 159, 47, 98, 142, 169, 255, 
    79, 125, 106, 132, 38, 82, 255, 121, 133, 76, 113, 2, 49, 255, 255, 255, 
    235, 218, 227, 234, 225, 246, 238, 232, 232, 185, 185, 232, 232, 232, 232, 231, 
    231, 232, 232, 245, 231, 248, 184, 247, 247, 247, 220, 230, 251, 220, 220, 253, 
    255, 255, 255, 10, 49, 46, 36, 255, 169, 58, 63, 57, 255, 144, 76, 255, 
    55, 59, 47, 9, 255, 89, 37, 146, 32, 83, 30, 255, 158, 38, 124, 15, 
    166, 89, 255, 255, 132, 118, 46, 255, 92, 25, 255, 124, 59, 67, 6, 181, 
    82, 81, 80, 48, 90, 38, 107, 97, 137, 255, 134, 133, 93, 255, 27, 107, 
    255, 97, 72, 133, 138, 255, 101, 127, 120, 79, 84, 80, 255, 20, 101, 69, 
    48, 55, 101, 255, 255, 134, 65, 97, 128, 109, 77, 255, 131, 92, 255, 255, 
    255, 245, 180, 225, 238, 212, 185, 232, 185, 245, 232, 232, 232, 245, 235, 231, 
    244, 245, 245, 231, 248, 247, 230, 251, 230, 230, 251, 220, 220, 220, 253, 255, 
    255, 255, 105, 25, 33, 96, 23, 59, 107, 255, 255, 90, 9, 158, 38, 80, 
    64, 255, 37, 34, 121, 114, 64, 38, 255, 255, 71, 95, 64, 251, 76, 10, 
    255, 114, 28, 35, 5, 144, 31, 255, 144, 67, 83, 25, 255, 157, 17, 144, 
    60, 47, 80, 81, 47, 80, 88, 90, 97, 79, 20, 6, 79, 137, 124, 133, 
    133, 71, 255, 53, 97, 146, 99, 54, 133, 255, 255, 101, 106, 111, 67, 93, 
    131, 255, 119, 133, 111, 46, 11, 70, 255, 6, 133, 82, 32, 255, 105, 255, 
    255, 255, 247, 238, 235, 249, 185, 248, 248, 232, 232, 245, 232, 232, 232, 248, 
    184, 248, 231, 231, 184, 247, 230, 230, 251, 230, 251, 220, 220, 181, 255, 255, 
    255, 105, 100, 92, 95, 31, 75, 27, 78, 104, 144, 38, 89, 87, 255, 255, 
    53, 100, 96, 46, 71, 10, 255, 122, 62, 95, 49, 131, 35, 255, 144, 48, 
    76, 37, 255, 114, 9, 255, 67, 67, 106, 255, 184, 22, 169, 92, 39, 32, 
    81, 81, 90, 48, 90, 48, 90, 88, 48, 40, 124, 6, 79, 101, 133, 255, 
    5, 101, 146, 90, 47, 133, 25, 255, 63, 93, 102, 19, 80, 72, 255, 12, 
    134, 130, 71, 2, 54, 124, 255, 108, 72, 70, 255, 3, 71, 156, 20, 49, 
    255, 255, 255, 197, 248, 184, 185, 185, 232, 232, 245, 232, 245, 232, 232, 245, 
    244, 231, 231, 184, 247, 230, 220, 247, 220, 220, 220, 252, 181, 255, 255, 255, 
    5, 121, 15, 113, 39, 23, 75, 77, 67, 59, 58, 20, 255, 76, 74, 100, 
    39, 67, 59, 255, 128, 26, 124, 113, 250, 89, 255, 255, 132, 62, 66, 2, 
    153, 15, 255, 124, 83, 112, 5, 255, 55, 11, 156, 32, 127, 15, 255, 153, 
    107, 81, 86, 90, 80, 81, 88, 47, 80, 80, 82, 79, 37, 255, 70, 106, 
    124, 82, 72, 108, 255, 13, 142, 97, 107, 39, 101, 169, 255, 79, 97, 107, 
    49, 16, 102, 255, 110, 133, 65, 52, 255, 29, 149, 137, 97, 102, 114, 255, 
    255, 254, 255, 255, 169, 251, 231, 185, 232, 232, 232, 232, 232, 245, 239, 231, 
    247, 244, 247, 247, 251, 220, 184, 251, 230, 220, 197, 254, 255, 255, 255, 105, 
    121, 15, 32, 74, 75, 66, 35, 67, 75, 39, 76, 33, 156, 83, 92, 48, 
    6, 255, 89, 75, 114, 20, 55, 24, 255, 124, 57, 76, 20, 253, 59, 255, 
    174, 120, 59, 92, 255, 92, 69, 170, 46, 96, 16, 255, 255, 28, 11, 131, 
    81, 80, 80, 80, 88, 80, 88, 80, 47, 88, 80, 58, 115, 137, 40, 80, 
    133, 255, 255, 133, 99, 111, 122, 50, 132, 255, 69, 134, 86, 159, 20, 79, 
    255, 255, 101, 70, 58, 255, 66, 40, 169, 80, 70, 133, 25, 255, 59, 104, 
    139, 100, 255, 255, 255, 255, 242, 230, 231, 245, 235, 235, 235, 232, 245, 247, 
    230, 247, 184, 184, 220, 220, 220, 220, 252, 253, 255, 255, 255, 255, 105, 121, 
    124, 46, 32, 67, 66, 77, 55, 77, 75, 34, 23, 35, 90, 37, 255, 92, 
    38, 124, 46, 100, 71, 255, 255, 88, 83, 64, 255, 114, 17, 255, 106, 59, 
    45, 255, 242, 31, 169, 100, 39, 83, 20, 255, 123, 92, 121, 15, 123, 37, 
    60, 80, 80, 90, 80, 90, 57, 115, 81, 88, 90, 88, 82, 101, 112, 255, 
    57, 133, 89, 71, 39, 101, 255, 255, 133, 111, 102, 5, 29, 113, 255, 102, 
    79, 108, 121, 9, 108, 128, 100, 72, 101, 125, 255, 22, 126, 174, 71, 28, 
    120, 255, 255, 10, 255, 255, 255, 255, 242, 247, 231, 245, 245, 231, 231, 247, 
    220, 220, 220, 220, 220, 220, 252, 181, 255, 255, 255, 255, 255, 139, 100, 15, 
    32, 31, 35, 23, 27, 77, 55, 35, 27, 74, 64, 31, 31, 75, 131, 106, 
    11, 89, 20, 255, 112, 38, 34, 9, 166, 28, 255, 153, 38, 78, 11, 255, 
    55, 41, 176, 96, 67, 31, 255, 167, 83, 144, 46, 49, 67, 12, 255, 55, 
    81, 48, 80, 88, 80, 80, 80, 48, 88, 88, 80, 81, 38, 90, 29, 110, 
    82, 15, 72, 146, 255, 54, 101, 108, 37, 46, 97, 255, 104, 133, 65, 83, 
    255, 97, 75, 255, 54, 63, 70, 255, 255, 101, 83, 59, 19, 79, 124, 255, 
    77, 96, 121, 37, 5, 255, 255, 255, 255, 255, 254, 253, 242, 220, 252, 252, 
    242, 252, 197, 253, 243, 255, 255, 255, 255, 255, 255, 5, 121, 37, 33, 32, 
    96, 77, 75, 106, 28, 75, 34, 55, 75, 35, 66, 31, 64, 39, 36, 35, 
    255, 166, 47, 76, 33, 255, 83, 5, 255, 71, 36, 16, 255, 156, 22, 169, 
    113, 39, 19, 255, 255, 67, 25, 153, 49, 114, 25, 255, 153, 114, 46, 121, 
    81, 48, 71, 38, 88, 38, 71, 80, 48, 48, 38, 88, 48, 71, 71, 101, 
    89, 255, 25, 143, 101, 71, 3, 54, 104, 255, 101, 79, 97, 255, 46, 97, 
    255, 45, 70, 108, 118, 255, 47, 111, 124, 38, 47, 97, 255, 128, 72, 100, 
    59, 32, 71, 255, 255, 113, 139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 105, 121, 100, 37, 46, 32, 64, 
    66, 35, 28, 77, 75, 75, 66, 114, 66, 31, 74, 31, 64, 31, 118, 55, 
    75, 62, 255, 151, 31, 255, 96, 53, 88, 255, 255, 127, 128, 121, 77, 59, 
    37, 255, 153, 22, 121, 124, 92, 34, 255, 255, 83, 92, 46, 252, 39, 12, 
    80, 81, 38, 80, 88, 88, 48, 115, 48, 115, 71, 80, 119, 81, 71, 21, 
    82, 101, 108, 17, 22, 80, 255, 112, 133, 72, 92, 255, 40, 104, 144, 72, 
    40, 107, 255, 33, 79, 136, 71, 67, 101, 153, 255, 54, 77, 148, 76, 80, 
    67, 255, 46, 107, 113, 37, 5, 153, 255, 255, 251, 254, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 252, 138, 105, 92, 15, 33, 46, 64, 66, 35, 
    67, 35, 27, 35, 55, 77, 35, 75, 23, 27, 66, 66, 39, 64, 23, 96, 
    106, 16, 255, 167, 38, 125, 52, 255, 113, 46, 174, 64, 67, 16, 255, 255, 
    16, 121, 131, 100, 59, 5, 255, 152, 27, 124, 10, 49, 22, 255, 166, 106, 
    50, 88, 80, 88, 115, 88, 115, 89, 88, 80, 80, 80, 88, 86, 80, 81, 
    80, 48, 90, 255, 128, 133, 133, 29, 255, 83, 130, 255, 47, 54, 79, 255, 
    255, 101, 104, 114, 36, 40, 62, 255, 35, 111, 106, 88, 23, 79, 255, 255, 
    101, 118, 59, 10, 59, 20, 255, 67, 66, 131, 138, 255, 139, 255, 138, 144, 
    105, 6, 255, 252, 20, 255, 37, 131, 27, 255, 255, 71, 59, 114, 77, 75, 
    27, 75, 28, 35, 35, 55, 75, 31, 23, 64, 118, 64, 110, 23, 64, 118, 
    22, 23, 76, 78, 255, 252, 36, 128, 157, 35, 38, 13, 255, 114, 33, 153, 
    131, 52, 22, 255, 171, 59, 46, 131, 128, 55, 6, 255, 28, 66, 96, 10, 
    81, 88, 71, 125, 38, 89, 80, 57, 71, 80, 115, 53, 48, 88, 88, 38, 
    125, 89, 88, 108, 101, 5, 11, 111, 255, 110, 40, 72, 106, 255, 119, 127, 
    104, 80, 80, 72, 255, 138, 101, 147, 88, 39, 97, 33, 255, 47, 88, 130, 
    92, 32, 82, 255, 146, 72, 125, 15, 255, 59, 144, 169, 83, 113, 33, 255, 
    254, 46, 138, 121, 92, 77, 104, 255, 112, 64, 131, 23, 131, 16, 118, 35, 
    77, 66, 75, 35, 66, 55, 64, 66, 64, 66, 64, 23, 31, 110, 74, 31, 
    64, 52, 22, 34, 144, 166, 27, 83, 34, 255, 166, 28, 104, 113, 49, 59, 
    255, 255, 83, 30, 32, 9, 123, 17, 255, 92, 83, 27, 12, 181, 27, 255, 
    81, 80, 78, 38, 48, 80, 78, 80, 115, 71, 38, 80, 71, 80, 115, 38, 
    115, 80, 19, 71, 107, 104, 138, 79, 72, 72, 255, 11, 108, 128, 71, 38, 
    101, 13, 255, 79, 129, 78, 50, 35, 97, 255, 105, 79, 106, 127, 17, 70, 
    255, 255, 101, 63, 111, 255, 46, 76, 255, 112, 47, 82, 11, 255, 66, 20, 
    144, 114, 114, 35, 255, 250, 80, 17, 76, 46, 58, 255, 255, 63, 63, 67, 
    35, 67, 75, 66, 27, 75, 31, 66, 66, 64, 64, 64, 22, 114, 27, 32, 
    74, 22, 110, 96, 77, 71, 255, 255, 59, 17, 124, 37, 27, 25, 255, 131, 
    67, 32, 121, 11, 66, 255, 170, 16, 122, 15, 255, 157, 104, 169, 96, 96, 
    80, 80, 71, 71, 38, 71, 38, 71, 88, 88, 88, 38, 71, 80, 71, 88, 
    88, 89, 80, 89, 71, 82, 70, 11, 255, 70, 131, 110, 88, 54, 88, 255, 
    27, 108, 106, 71, 15, 70, 49, 255, 97, 76, 97, 20, 59, 112, 255, 89, 
    72, 65, 11, 254, 54, 255, 144, 72, 70, 34, 255, 52, 112, 128, 120, 83, 
    48, 255, 255, 58, 131, 95, 52, 80, 52, 255, 96, 58, 117, 46, 252, 59, 
    77, 75, 66, 27, 75, 31, 66, 31, 39, 64, 23, 110, 114, 31, 64, 64, 
    64, 113, 96, 32, 52, 66, 37, 131, 52, 92, 34, 255, 255, 120, 46, 32, 
    252, 55, 13, 255, 66, 28, 75, 255, 171, 52, 255, 153, 28, 127, 17, 255, 
    80, 80, 71, 71, 78, 38, 80, 71, 38, 71, 125, 88, 71, 78, 71, 89, 
    71, 71, 53, 71, 78, 36, 82, 95, 105, 82, 48, 79, 255, 255, 101, 124, 
    125, 15, 29, 112, 255, 120, 65, 107, 16, 37, 65, 255, 9, 101, 87, 59, 
    255, 88, 37, 255, 82, 65, 70, 255, 255, 111, 156, 122, 63, 54, 52, 255, 
    64, 59, 146, 62, 22, 58, 255, 255, 72, 76, 34, 242, 47, 20, 255, 71, 
    57, 67, 64, 31, 64, 39, 75, 31, 96, 31, 96, 64, 64, 22, 96, 110, 
    113, 22, 22, 22, 52, 52, 118, 62, 128, 255, 122, 114, 32, 11, 49, 52, 
    255, 158, 59, 127, 20, 255, 66, 105, 105, 66, 55, 23, 255, 251, 46, 255, 
    81, 71, 71, 38, 115, 80, 78, 71, 71, 53, 71, 71, 80, 125, 80, 78, 
    88, 38, 115, 71, 88, 88, 71, 90, 79, 124, 255, 47, 125, 118, 28, 59, 
    97, 255, 144, 101, 58, 107, 20, 38, 95, 255, 97, 82, 54, 9, 49, 80, 
    255, 52, 65, 79, 49, 255, 82, 75, 100, 40, 58, 82, 255, 138, 70, 100, 
    67, 52, 54, 20, 255, 82, 86, 76, 49, 46, 88, 255, 100, 70, 111, 64, 
    255, 113, 59, 118, 31, 118, 64, 74, 66, 64, 64, 66, 64, 110, 64, 52, 
    39, 30, 64, 64, 113, 64, 46, 113, 33, 113, 52, 167, 28, 255, 255, 59, 
    67, 22, 255, 153, 33, 255, 113, 23, 56, 255, 255, 67, 9, 174, 96, 64, 
    80, 71, 78, 78, 71, 71, 71, 38, 89, 71, 71, 71, 19, 71, 71, 56, 
    89, 71, 36, 71, 19, 89, 89, 36, 80, 89, 124, 82, 33, 72, 128, 255, 
    79, 108, 97, 37, 46, 88, 255, 124, 70, 97, 32, 255, 58, 138, 138, 40, 
    111, 82, 255, 49, 87, 144, 80, 59, 79, 128, 255, 47, 113, 118, 77, 36, 
    34, 255, 100, 54, 117, 75, 3, 82, 6, 255, 97, 119, 38, 255, 37, 35, 
    255, 122, 36, 106, 32, 31, 23, 64, 74, 114, 31, 96, 64, 32, 123, 110, 
    31, 113, 113, 52, 52, 46, 124, 33, 52, 34, 11, 255, 113, 112, 77, 105, 
    253, 66, 255, 166, 55, 56, 17, 255, 113, 25, 144, 113, 113, 67, 255, 255, 
    71, 59, 59, 83, 59, 120, 59, 59, 120, 59, 83, 120, 83, 59, 59, 59, 
    76, 83, 59, 83, 59, 59, 83, 76, 83, 59, 97, 23, 255, 117, 81, 88, 
    64, 9, 58, 128, 128, 29, 130, 82, 255, 64, 76, 255, 59, 59, 111, 9, 
    255, 107, 156, 113, 35, 90, 95, 255, 66, 112, 131, 76, 25, 81, 255, 255, 
    81, 95, 112, 13, 83, 32, 255, 66, 59, 89, 20, 255, 78, 138, 100, 59, 
    76, 23, 255, 49, 66, 52, 32, 46, 32, 46, 46, 52, 124, 52, 52, 46, 
    52, 124, 124, 124, 15, 92, 46, 33, 37, 131, 46, 96, 15, 255, 123, 20, 
    169, 113, 46, 39, 255, 167, 32, 105, 92, 131, 123, 17, 255, 131, 17, 166
};

#pragma pack()


//////////////////////////////////////////////////////
// exception win32 implementation                  //
////////////////////////////////////////////////////

static HBITMAP	eExceptionBitmap;
static long		eExceptionBitmapWidth;
static long		eExceptionBitmapHeight;
static long		eExceptionWindowWidth;
static long		eExceptionWindowHeight;
static HWND		eExceptionBitmapWindow;

static String	eExceptionCaption;
static String	eExceptionMethod;
static String	eExceptionFilename;
static String	eExceptionMessage;



static LONG APIENTRY ExceptionBitmap( HWND h, UINT m, UINT w, LONG l)
{
	switch ( m )
	{
		case WM_CREATE:
		{
			break;
		}

		case WM_ERASEBKGND:
		{
			HDC m = CreateCompatibleDC( (HDC) w );
			if ( !m ) break;

		    HBITMAP o = (HBITMAP)SelectObject( m, eExceptionBitmap );

			BitBlt( (HDC) w, 0, 0, eExceptionBitmapWidth, eExceptionBitmapHeight, m, 0, 0, SRCCOPY );

			SelectObject( m, o );
			DeleteDC( m );

			return 1;
		}

		case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint( h, &ps );
			EndPaint( h, &ps );
			return 0;
		}

		case WM_DESTROY:
		{
			if ( eExceptionBitmap )
			{
				DeleteObject( eExceptionBitmap );
			}
			break;
		}

		default:
		{
			return DefWindowProc(h, m, w, l);
		}
	}

	return 0;
}



static void ExceptionTextCaption( HDC hdc, long x, long y, char* s )
{
	if ( s )
	{
		HFONT o = (HFONT)SelectObject( hdc, (HFONT) GetStockObject( SYSTEM_FONT ) );
		TextOut( hdc, x, y, s, strlen(s) );
	 	SelectObject( hdc, o );
	}
}



static void ExceptionText( HDC hdc, long x, long y, char* s )
{
	if ( s )
	{
		HFONT oldfont = (HFONT)SelectObject( hdc, (HFONT) GetStockObject( DEFAULT_GUI_FONT ) );
		TextOut( hdc, x, y, s, strlen(s) );
	 	SelectObject( hdc, oldfont );
	}
}



static LONG APIENTRY ExceptionWindow( HWND h, UINT m, UINT w, LONG l)
{

	switch ( m )
	{

		case WM_CREATE:
		{
			eExceptionBitmapWindow = CreateWindow( "PR3DExceptionBitmapClass", NULL, WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN,
				0, 0, eExceptionBitmapWidth, eExceptionBitmapHeight, h, (HMENU) 1, GetModuleHandle( NULL ), NULL );

			HWND eButton = CreateWindow( "BUTTON", "Finish", WS_CHILD | WS_VISIBLE,
				420, 10, 82, 25, h, (HMENU) 120, GetModuleHandle( NULL ), NULL );

			SendMessage( eButton, WM_SETFONT, (WPARAM) GetStockObject( DEFAULT_GUI_FONT ), FALSE );

			break;
		}

		case WM_COMMAND:
		{
			switch( LOWORD( w ) )
			{
				case 120:
				{
					DestroyWindow( h );
					break;
				}
			}

			break;
		}

		case WM_ERASEBKGND:
		{
			RECT r;
			r.top = 0;
			r.left = 0;
			r.right = eExceptionWindowWidth;
			r.bottom = eExceptionWindowHeight;

			HBRUSH b = CreateSolidBrush( RGB( 255, 255, 255 ) );
			HBRUSH o = (HBRUSH)SelectObject( (HDC) w, b );

			FillRect( (HDC) w, &r, b );

			SelectObject( (HDC) w, o );
			DeleteObject( b );
			break;
		}


		case WM_PAINT:
		{
			PAINTSTRUCT ps;

			HDC hdc = BeginPaint(h, &ps);
			SetMapMode(hdc, MM_TEXT);

			SetBkColor(hdc, RGB(255, 255, 255));

			ExceptionTextCaption( hdc, 140, 8, (char*)eExceptionCaption);

			ExceptionText(hdc, 140, 30, "Method:");
			ExceptionText(hdc, 140, 44, "File:");
			ExceptionText(hdc, 140, 64, "Message:");

			ExceptionText(hdc, 200, 30, eExceptionMethod);
			ExceptionText(hdc, 200, 44, eExceptionFilename);
			ExceptionText(hdc, 200, 64, eExceptionMessage);

			EndPaint(h, &ps);

			return 0;
		}

		case WM_INITMENU:
		{
			break;
		}

		case WM_CLOSE:
		{
			DestroyWindow(h);
			break;
		}

		case WM_DESTROY:
		{
			PostQuitMessage( 0 );
			break;
		}

		default:
		{
			return DefWindowProc(h, m, w, l);
		}
	}

	return 0;
}


//////////////////////////////////////////////////////
// DrawDialog                                      //
////////////////////////////////////////////////////

void Exception::DrawDialog()
{
	eExceptionCaption  = "Software Exception";
	eExceptionMethod   = mMethod;
	eExceptionFilename = mFilename;
	eExceptionMessage  = mMessage;

	// main window
	WNDCLASS c;
    c.style = 0;
    c.lpfnWndProc = (WNDPROC)ExceptionWindow;
    c.cbClsExtra = 0;
    c.cbWndExtra = 0;
    c.hInstance = GetModuleHandle( NULL );
    c.hIcon = LoadIcon( NULL, IDI_EXCLAMATION );
    c.hCursor = LoadCursor(NULL, IDC_ARROW);
    c.hbrBackground = (HBRUSH) (COLOR_MENU + 1);
    c.lpszMenuName = NULL;
    c.lpszClassName = "PR3DExceptionWindowClass";

    RegisterClass( &c );

	// logo container
    c.lpfnWndProc = (WNDPROC)ExceptionBitmap;
    c.hIcon = NULL;
    c.hbrBackground = NULL;
    c.lpszClassName = "PR3DExceptionBitmapClass";

    RegisterClass( &c );


	// convert indexed logo into 24bit RGB logo
	const int pixels = mExceptionPixels;
	char logo[  pixels * 3 ];

	char* pLogo = logo;
	for ( int i=0; i<pixels; i++ )
	{
		unsigned char* pal = mExceptionPalette + mExceptionData[ i ] * 3;
		*pLogo++ = pal[ 2 ];
		*pLogo++ = pal[ 1 ];
		*pLogo++ = pal[ 0 ];
	}


	// convert the logo to a blittable win32 bitmap
	BITMAPINFO	cinfo;

	cinfo.bmiHeader.biSize = sizeof( BITMAPINFOHEADER );
 	cinfo.bmiHeader.biPlanes = 1;
 	cinfo.bmiHeader.biBitCount = 24;
 	cinfo.bmiHeader.biCompression = BI_RGB;
 	cinfo.bmiHeader.biSizeImage = 0;
 	cinfo.bmiHeader.biXPelsPerMeter = 0;
  	cinfo.bmiHeader.biYPelsPerMeter = 0;
  	cinfo.bmiHeader.biClrUsed = 0;
	cinfo.bmiHeader.biClrImportant = 0;

	eExceptionBitmapWidth  = mExceptionWidth;
	eExceptionBitmapHeight = mExceptionHeight;

	cinfo.bmiHeader.biWidth  = mExceptionWidth;
	cinfo.bmiHeader.biHeight = -( mExceptionHeight );

	HDC hdc = CreateDC( "DISPLAY", NULL, NULL, NULL ); 
	if ( !hdc ) 
		return;

	eExceptionBitmap = (HBITMAP)CreateCompatibleBitmap( hdc, mExceptionWidth, mExceptionHeight ); 
	if ( !eExceptionBitmap ) 
	{ 
		DeleteDC( hdc ); 
		return;
	}
	SetDIBits( hdc, eExceptionBitmap, 0, mExceptionHeight, logo, &cinfo, DIB_RGB_COLORS );
	DeleteDC( hdc );


	// let's calculate the window dimensions, and show it
	RECT r;

	r.left 	 = 0;
	r.top 	 = 0;
	r.right  = 512;
	r.bottom = 94;

	eExceptionWindowWidth  = (r.right - r.left);
	eExceptionWindowHeight = (r.bottom - r.top);

	long ex = (GetSystemMetrics(SM_CXFULLSCREEN) / 2) - eExceptionWindowWidth / 2;
	long ey = (GetSystemMetrics(SM_CYFULLSCREEN) / 2) - eExceptionWindowHeight / 2;

	if ( !AdjustWindowRectEx( &r, WS_SYSMENU | WS_CLIPCHILDREN | WS_POPUP | WS_CAPTION | WS_BORDER, FALSE, WS_EX_TOPMOST ) ) 
		return;

	eExceptionWindowWidth  = (r.right - r.left);
	eExceptionWindowHeight = (r.bottom - r.top);

	// create dialog window
	HWND eHwnd = CreateWindowEx( WS_EX_TOPMOST, "PR3DExceptionWindowClass", "The Prophecy 3D/Multimedia SDK Exception Handler",
		WS_CAPTION | WS_POPUP | WS_BORDER | WS_CLIPCHILDREN | WS_SYSMENU,
		ex, ey, (r.right - r.left), (r.bottom - r.top), NULL, NULL, GetModuleHandle( NULL ), NULL );

	ShowWindow( eHwnd, SW_SHOW );
	UpdateWindow( eHwnd );

	// message loop
	MSG eMsg;
	while ( ::GetMessage(&eMsg,NULL,0,0) )
	{
		::TranslateMessage(&eMsg);
   		::DispatchMessage(&eMsg);
	}
}


//////////////////////////////////////////////////////
// SetLogo                                         //
////////////////////////////////////////////////////

bool Exception::SetLogo(const Bitmap& logo)
{
	// get logo bitmap information
	const PixelFormat& format = logo.GetFormat();
	int width = logo.GetWidth();
	int height = logo.GetHeight();
	int pitch = logo.GetPitch();
	uint8* image = logo.GetImage();

	// check information
	if ( !format.IsIndexed() || 
		(width != mExceptionWidth) || 
		(height != mExceptionHeight) )
		return false;

	// copy image
	for ( int y=0; y<height; y++ )
	{
		memcpy( mExceptionData + width*y, image + pitch*y, width );
	}

	// copy palette
	Color32* palette = format.GetPalette();
	unsigned char* rgb = mExceptionPalette;
	for ( int i=0; i<256; i++ )
	{
		Color32 color = palette[ i ];
		rgb[0] = color.r;
		rgb[1] = color.g;
		rgb[2] = color.b;
		rgb += 3;
	}

	return true;
}
