/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		codec server

	revision history:
		Jan/20/2000 - Jukka Liimatta - initial revision
		Jan/24/2001 - Jukka Liimatta - renaissance build
*/
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// server                                          //
////////////////////////////////////////////////////

BitmapCodec CreateCodecTGA();
BitmapCodec CreateCodecPCX();
BitmapCodec CreateCodecRGB();
BitmapCodec CreateCodecBMP();
BitmapCodec CreateCodecJPG();
BitmapCodec CreateCodecPNG();
BitmapCodec CreateCodecFXT1();
BitmapCodec CreateCodecDXTC();


static void InitializeServer()
{
	static bool init = false;
	
	if ( !init )
	{
		RegisterBitmapCodec( CreateCodecTGA() );
		RegisterBitmapCodec( CreateCodecPCX() );
		RegisterBitmapCodec( CreateCodecRGB() );
		RegisterBitmapCodec( CreateCodecBMP() );
		RegisterBitmapCodec( CreateCodecJPG() );
		RegisterBitmapCodec( CreateCodecPNG() );
		RegisterBitmapCodec( CreateCodecDXTC() );

		#ifdef PRCORE_PLATFORM_WIN32
		RegisterBitmapCodec( CreateCodecFXT1() );
		#endif

		init = true;
	}
}


//////////////////////////////////////////////////////
// template                                        //
////////////////////////////////////////////////////

template <class T>
T* FindCodec(LinkedList<T>& list, const char* ext)
{
	if ( !ext )
		return NULL;
	
	// iterate through all codecs
	for ( int i=0; i<list.GetSize(); i++ )
	{
		T& node = list[ i ];

		// iterate through extensions in current codec
		int count = node.NumEXT();
		for ( int j=0; j<count; j++ )
		{
			if ( !stricmp(node.GetEXT(j),ext) )
				return &node;
		}
	}
	
	// found nothing
	return NULL;
}


//////////////////////////////////////////////////////
// BitmapCodec                                     //
////////////////////////////////////////////////////

static LinkedList<BitmapCodec> BitmapCodecList;


void prcore::RegisterBitmapCodec(const BitmapCodec& codec)
{
	BitmapCodecList.PushBack( codec );
}


int prcore::GetBitmapCodecCount()
{
	InitializeServer();
	return BitmapCodecList.GetSize();
}


BitmapCodec* prcore::GetBitmapCodec(int index)
{
	InitializeServer();
	assert( index>=0 && index<= BitmapCodecList.GetSize() );
	return &BitmapCodecList[ index ];
}


BitmapCodec* prcore::FindBitmapCodec(const char* ext)
{
	InitializeServer();
	assert( ext );
	return FindCodec(BitmapCodecList,ext);
}
