/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_BITMAP_HPP
#define PRCORE_BITMAP_HPP



namespace prcore
{
	
	class Bitmap : public Surface
	{
		public:
		
		// constructors
		Bitmap();
		Bitmap(const Bitmap& bitmap);
		Bitmap(const Surface& surface);
		Bitmap(int width, int height, const PixelFormat& pxf);
		Bitmap(const char* filename);
		~Bitmap();

		// operators
		void			operator = (const Bitmap& bitmap);

		// methods
		Bitmap			GetBitmap(const Rect& area) const;
		void			LoadImage(const char* filename);
		void			SaveImage(const char* filename);
		void			SetImage(int width, int height, const PixelFormat& pxf, void* image);
		void			ResizeImage(int width, int height, bool filter=true);
		void			ReformatImage(const PixelFormat& pxf);
		void			QuantizeImage(float quality=0.35f);
	};

} // namespace prcore



#endif