/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2000 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	Source:
		WindowBase example

	Revision history:
		Aug/24/2001 - Jukka Liimatta - initial revision
*/
#define PRCORE_IMPLEMENT_MAIN
#include <prcore/prcore.hpp>

using namespace prcore;




// ===========================================================================
// window declaration
// ===========================================================================

class TestWindow : public WindowBase
{
	public:

	TestWindow(int width, int height);
	~TestWindow();

	bool			EventMain();
	void			EventDraw();
	void			EventSize(int width, int height);
	void			EventKeyboard(int keycode, bool press);
	
	private:
	
	FrameBuffer		framebuffer;
	Bitmap			picture;
};


// ===========================================================================
// window implementation
// ===========================================================================

TestWindow::TestWindow(int width, int height)
{
	// open window
	Open(width,height,"TestWindow",WINDOW_NORMAL);
	
	// open framebuffer
	WinHandle handle = GetHandle();
	framebuffer.Open(handle);

	// picture
	picture.LoadImage("../h4x0r.jpg");
}


TestWindow::~TestWindow()
{
	// close framebuffer
	framebuffer.Close();
}


bool TestWindow::EventMain()
{
	EventDraw();
	return true;
}


void TestWindow::EventDraw()
{
	framebuffer.BlitWrite(0,0,picture);
	framebuffer.PageFlip();
}


void TestWindow::EventSize(int width, int height)
{
}


void TestWindow::EventKeyboard(int keycode, bool press)
{
	if ( keycode==KEYCODE_ESC && press )
		MainBreak();
}


// ===========================================================================
// prmain()
// ===========================================================================

int prmain(int argc, char** argv)
{
	TestWindow window(512,384);
	window.MainLoop();
  
	return 0;
}
