/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		vector example

	revision history:
		Jan/01/1999 - Jukka Liimatta - initial revision
*/
#include <prmath/prmath.hpp>
#include <iostream>

using namespace prmath;
using namespace std;



namespace
{

	void Average()
	{
		const int num = 20;
		Vector3 array[num];

		Vector3 average(0,0,0);
		for ( int i=0; i<num; i++ )
			average += array[i];

		average /= num;
	}


	// simple triangle type for the example
	struct MyTri
	{
		Vector3		v[3];
		Vector3		normal;
	};


	void CalculateNormal(MyTri& tri)
	{
		Vector3 s = tri.v[0] - tri.v[1];
		Vector3 t = tri.v[0] - tri.v[2];
		tri.normal = Normalize( CrossProduct(s,t) );
	}


	void LerpTest()
	{
		Vector3 a( 0.0f, 0.0f, 0.0f );
		Vector3 b( 2.0f, 2.0f, 2.0f );

		Vector3 average = Lerp( a, b, 0.5f );
	}
	
} // namespace



int main()
{
	MyTri tri;
	tri.v[0] = Vector3(0,1,2);
	tri.v[1] = Vector3(1,0,0);
	tri.v[2] = Vector3(2,0,1);
	
	CalculateNormal( tri );
	Average();
	LerpTest();

	cout << "Vector test complete." << endl;

	return 0;
}
