#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include <stdio.h>
#include <commctrl.h>
#include "h\AE3DS.h"
#include "h\AEUtils.h"
#include "h\console.h"
#include "resource.h"

HINSTANCE		hInstance;
HWND			hWnd;

bool			FULLSCREEN=false;
BOOL			g_bActive = FALSE;
HDC				hDC;
HFONT			font;
float			GlobalTimer=0;
float			FrameStep=1.0f;

AE3DS			*test;

RECT			Client;
DEVMODE			DevMode;

//OPENGL EXTENSION!!!!!!!
PFNGLACTIVETEXTUREARBPROC          glActiveTextureARB          = NULL;
PFNGLMULTITEXCOORD2FARBPROC        glMultiTexCoord2fARB        = NULL;
PFNGLCLIENTACTIVETEXTUREARBPROC	   glClientActiveTextureARB		= NULL;

struct {
    int id;
    char *String;
}  AE3DSError[] = {
	{0x201,	"AE3DS File Not Found!"},
	{0x202,	"AE3DS No Cameras defined!"},
	{0x203,	"AE3DS No Object defined!"},
	{0x801,	"ijlInit Failure"},
	{0x802, "ijlRead File Not Found"},
	{0x803, "JPG Is Incorrect Size"},
	{0x804, "ijlRead Invalide File Format"},
	{0x805, "ijlFree Failure"},
	{-1,	"AE3DS Internal Error"},
};


/********************/
void UpdateFrame(void)
/********************/
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	test->SetFrame((float)fmod(GlobalTimer,test->EndFrame));
	test->RenderFrame();
	GlobalTimer+=(float)FrameStep;
	if (GlobalTimer<0) GlobalTimer=(float)test->EndFrame;
	SwapBuffers(hDC);
}


LONG WINAPI WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ 
    static PAINTSTRUCT ps;
	static Vector dir;

    switch(uMsg) 
	{
	case WM_SIZE:
		GetClientRect(hWnd,&Client);
		glViewport(0, 0, LOWORD(lParam), HIWORD(lParam));
		PostMessage(hWnd, WM_PAINT, 0, 0);
		return 0;
	case WM_CHAR:
		// keys 1..9 change cameras
		if (wParam>48 && wParam<57) test->SetCamera(wParam-49);
		switch (wParam) 
		{
		case 27: // ESC
			ChangeDisplaySettings(NULL,0);
			PostQuitMessage(0);
			break;
		case '+': // speed up
			FrameStep+=0.01f;
			break;
		case '-': // slow down (you can change to backwards playing!)
			FrameStep-=0.01f;
			break;
		}
		return 0;
	case WM_ACTIVATE:
		if (!IsIconic(hWnd)) g_bActive=TRUE;
		return 0;

	case WM_CLOSE:
		PostQuitMessage(0);
		return 0;
	}

    return DefWindowProc(hWnd, uMsg, wParam, lParam); 
} 

HWND CreateOpenGLWindow(char* title, int width, int height, BYTE type, DWORD flags)
{
    int         n, pf;
	WNDCLASS    wc;
	LOGPALETTE* lpPal;
	PIXELFORMATDESCRIPTOR pfd;

	if (!hInstance) 
	{
		hInstance = GetModuleHandle(NULL);
		wc.style         = CS_OWNDC;
		wc.lpfnWndProc   = (WNDPROC)WindowProc;
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 0;
		wc.hInstance     = hInstance;
		wc.hIcon         = LoadIcon(NULL, IDI_WINLOGO);
		wc.hbrBackground = NULL;
		wc.lpszClassName = "3DS Player";

if (FULLSCREEN ) {
		wc.lpszMenuName  = NULL;
		wc.hCursor       = NULL;
} else {
		wc.lpszMenuName  = NULL;//"EngineMenu";
		wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
}

		if (!RegisterClass(&wc)) 
		{
			MessageBox(NULL, "RegisterClass() failed:  Cannot register window class.", "Error", MB_OK);
			return NULL;
		}
	}

if (FULLSCREEN) {
	Client.left=0;
	Client.right=width;
	Client.top=0;
	Client.bottom=height;
	hWnd = CreateWindowEx(
		WS_EX_APPWINDOW | WS_EX_TOPMOST, 
		"3DS Player", title, 
		WS_POPUP,
		Client.left, Client.top, Client.right-Client.left, Client.bottom-Client.top,
		NULL, NULL, hInstance, NULL);
} else {
	Client.left=0;//(GetSystemMetrics(SM_CXFULLSCREEN)-width)/2;
	Client.right=width;//(GetSystemMetrics(SM_CXFULLSCREEN)-width)/2+width;
	Client.top=0;//(GetSystemMetrics(SM_CYFULLSCREEN)-height)/2;
	Client.bottom=height;//(GetSystemMetrics(SM_CYFULLSCREEN)-height)+height;
	AdjustWindowRect(&Client,WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN , TRUE);
	hWnd = CreateWindowEx(
		WS_EX_APPWINDOW | WS_EX_WINDOWEDGE ,
		"3DS Player", title,
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		0,0, Client.right-Client.left, Client.bottom-Client.top,
//		Client.left, Client.top, Client.right-Client.left, Client.bottom-Client.top,
		NULL, NULL, hInstance, NULL);
}

	if (hWnd == NULL) 
	{
		MessageBox(NULL, "CreateWindow() failed:  Cannot create a window.",  "Error", MB_OK);
		return NULL;
	}

	hDC = GetDC(hWnd);
    memset(&pfd, 0, sizeof(pfd));
	pfd.nSize        = sizeof(pfd);
	pfd.nVersion     = 1;
	pfd.dwFlags      = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | flags;
	pfd.iPixelType   = type;
	pfd.cColorBits   = 32;
	pfd.cDepthBits   = 24;
	//pfd.cStencilBits = 8;

	pf = ChoosePixelFormat(hDC, &pfd);
	if (pf == 0) 
	{
		MessageBox(NULL, "ChoosePixelFormat() failed:  Cannot find a suitable pixel format.", "Error", MB_OK); 
		return 0;
	} 
 
	if (SetPixelFormat(hDC, pf, &pfd) == FALSE) 
	{
		MessageBox(NULL, "SetPixelFormat() failed:  Cannot set format specified.", "Error", MB_OK);
		return 0;
	} 

	DescribePixelFormat(hDC, pf, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

	ReleaseDC(hWnd,hDC);

	return hWnd;
}    


int APIENTRY WinMain(HINSTANCE hCurrentInst, HINSTANCE hPreviousInst,
	LPSTR lpszCmdLine, int nCmdShow)
{
	HGLRC hRC;
	HWND  hWnd;
	MSG   msg;
	DWORD buffer = PFD_DOUBLEBUFFER;
	BYTE  color  = PFD_TYPE_RGBA;

    font = CreateFont(24, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, NONANTIALIASED_QUALITY, VARIABLE_PITCH,"Arial");    

	if (FULLSCREEN) {
		memset(&DevMode,0,sizeof(DevMode));
		DevMode.dmSize=sizeof(DevMode);
		DevMode.dmBitsPerPel=32;
		DevMode.dmPelsWidth=640;
		DevMode.dmPelsHeight=480;
		DevMode.dmDisplayFrequency=70;
		//DevMode.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT|DM_DISPLAYFREQUENCY;
		DevMode.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
		ChangeDisplaySettings(&DevMode,0);
	}

	hWnd = CreateOpenGLWindow("3DS Player", 640, 480, color, buffer);
	if (hWnd == NULL) exit(1);
	hDC = GetDC(hWnd);
	hRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hRC);

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);

	glEnable(GL_DEPTH_TEST);
	glClear(GL_COLOR_BUFFER_BIT);
	glClear(GL_DEPTH_BUFFER_BIT);
	glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)wglGetProcAddress("glActiveTextureARB");
	glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC)wglGetProcAddress("glMultiTexCoord2fARB");
	glClientActiveTextureARB = (PFNGLCLIENTACTIVETEXTUREARBPROC)wglGetProcAddress("glClientActiveTextureARB");

	test=new AE3DS;
	test->Load3ds("test.3ds");
	test->InitAE(AE_AUTOFAR | AE_DONTSHADETRANSPARENT);

	SetFocus(hWnd);
	SwapBuffers(hDC);

	while (TRUE)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if (!GetMessage(&msg, NULL, 0, 0)) return msg.wParam;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		} 
		else if (g_bActive)
		{
			UpdateFrame();
		} 
		else
		{
			WaitMessage();
		}
	}
	ChangeDisplaySettings(NULL,0);

    wglMakeCurrent(NULL, NULL);
	ReleaseDC(hDC, hWnd);
	wglDeleteContext(hRC);
	DestroyWindow(hWnd);
	DeleteDC(hDC);
	return 0;
}