#ifndef _AECLASS_
#define _AECLASS_

#include <windows.h>

#include "Vector.h"
//#include "Wector.h"
#include "Matrix.h"
#include "Quat.h"
#include "FCol.h"
#include "aefiller.h"

#define PI 3.1415926535897932384626433832795
#define TRUE 1
#define FALSE 0

typedef unsigned char	byte;
typedef unsigned short	word;
typedef unsigned long	dword;
typedef signed char		sbyte;
typedef signed short	sword;
typedef signed long		sdword;


typedef char* AESTRING;


//********************
//*+----------------+*
//*| Material stuff |*
//*+----------------+*
//********************

class AEMAP {
public:
	int			Num,ID;
	AESTRING	File;
	AEMAP::AEMAP() { File=NULL; }
	AEMAP::~AEMAP() { if (File) delete File; }
};

class AEMAT {
public:
	AESTRING	Name;
	AEMAP		*TextureMap,*EnvMap,*LightMap;
	FCol		Ambient,Diffuse,Specular;
	float		Transparency;

	AEMAT::AEMAT() {
		Ambient=FCol(0,0,0);
		Diffuse=FCol(0,0,0);
		Specular=FCol(0,0,0);
		TextureMap=NULL;
		EnvMap=NULL;
		LightMap=NULL;
		Name=NULL;
	}

	AEMAT::~AEMAT() {
		if (TextureMap) delete TextureMap;
		if (EnvMap) delete EnvMap;
		if (LightMap) delete LightMap;
		if (Name) delete Name;
	}
};


//*******************
//*+---------------+*
//*| General stuff |*
//*+---------------+*
//*******************

typedef struct {
	float	u,v;
} FUV;

enum INITTYPE {
	AE_AUTOFAR=1,
	AE_DONTSHADE=2,
	AE_DONTSHADETRANSPARENT=4,
	AE_LIGHTDISTANCECOUNTS=8,
	AE_DRAWGLOWS=16,
	AE_FOG=32,
	AE_MASTERCOLOR=64,
	AE_TWOSIDED=128,
	AE_LIGHTMAPS=256,
	AE_WIREFRAME=512
};

enum VERTEXFLAG { 
	CLIPLEFT=1,CLIPRIGHT=2,
	CLIPTOP=4,CLIPBOTTOM=8,
	CLIPNEAR=16,CLIPFAR=32,
	CLIPANY=63
};

class AEVERTEX {
public:
	int		Stamp;
//	FUV		MapCoords;
	FUV		MapCoords2;
	FCol	Col;
};


enum FACEFLAGS {
	VISIBLE=64,
	DISABLED=128
};

class AEFACE {
public:
	int		a,b,c,Edges,Smooth;
	AEMAT	*Material;
	FUV		MapCoords[3];
	FUV		LightMapCoords[3];
	Vector	Normal;
	float	CullPoint;
	int		Flag;
};


//*****************
//*+-------------+*
//*| World stuff |*
//*+-------------+*
//*****************
enum OBJECTYPE {
	TRIMESH=1,
	CAMERA,
	LIGHT,
	DUMMY,
	AMBIENT
};

class AEOBJECT {
public:
	OBJECTYPE 	Type;
	AESTRING	Name;
	//void		*Obj;
	AEOBJECT::AEOBJECT() { Name=NULL; }
	AEOBJECT::~AEOBJECT() { if (Name) delete Name; }
};

class AETRIMESH:public AEOBJECT {
public:
	int		NumFaces,NumVert,NumMapped;
	bool	TwoSided;

	AEFACE		*Faces;
	Vector		*Vertices;
	Vector		*Normals;
	FUV			*MapCoords;
	AEMAT		*Material;
	Matrix		LocMatrix;
	Vector		BBox[8];
	int			BBoxFlags[8];
	AESTRING	ProcessName;

	AETRIMESH();
	~AETRIMESH();
	void CalcBBox();
	void CalcNormals();

};


class AEAMBIENT:public AEOBJECT { 
public:
	FCol	Col;
	//~AEAMBIENT();
};

class AELIGHT:public AEOBJECT { 
public:
	int		Spotlight;
	Vector	Pos;
	FCol	Col;
	Vector	Trg;
	float	Hotspot;
	float	Falloff;
	float	InnerRange, OuterRange;
	float	InnerRange2, OuterRange2;
	float	FadingRange;
	float	Fading;
	bool	Active;
	bool	Draw;

	AELIGHT();
	~AELIGHT();
};

class AECAMERA:public AEOBJECT {
public:
	Vector	Pos;
	Vector	Trg;
	Vector	Up;
	Vector	Front;
	float	Roll;
	float	Lens;
	float	Fov;

	float	NearClippingPlane,FarClippingPlane;
	
	Matrix WorldToCamera;
	Matrix WorldToScreen;
	Matrix Projection;

	AECAMERA();
	~AECAMERA();
	void InitCameraMatrix();
	void FOV();
};

class AEDUMMY:public AEOBJECT {
public:
	Matrix	LocMatrix;
};


//*************************
//*************************
//***  Class variables  ***
//*************************
//*************************
#include "AEKeyfr.h"

class AE {
public:
	float	CurrFrame;
	int		StartFrame,EndFrame;

	float	DefaultNearClippingPlane, DefaultFarClippingPlane;
	unsigned char *Screen;
	int		ScreenWidth, ScreenHeight;
	bool	MotionBlur;

	int	NumMats,NumMaps;	
	int	NumObjs,NumTrimeshes,NumCams,NumLights,NumAmbients,NumDummies;
	int	NumNodes,NumObjNodes,NumCamNodes,NumCTargetNodes;
	int	NumLightNodes,NumSpotlightNodes,NumLTargetNodes;
	int	NumAmbientNodes;
	int Stamp;

	AEFILLER	*swfiller;
	AECAMERA	*ActiveCamera;
	AEMAT		**Mat;
	AEMAP		**Map;
	AEMAP		*GlowMap;
	AEOBJECT	**World;
	AECAMERA	**Camera;
	AETRIMESH	**Trimesh;
	AELIGHT		**Light;
	AEAMBIENT	*Ambient;
	AENODE	**Nodes;
	AENODE	**ObjNode;
	AENODE	**CameraNode;
	AENODE	**CTargetNode;
	AENODE	**LightNode;
	AENODE	**LTargetNode;
	AENODE	**SpotlightNode;
	AENODE	**AmbientNode;
	AENODE	Eve;

	AE();
	~AE();
	int	 LoadTexture(char *TName, unsigned char *Texels);
	int	 InitAE(int InitFlag=0);
	void SetCamera(int i);
	void SetFrame(float t);
	void RenderFrame();

private:
	void CalcMatrix(AENODE *Parent);

};

#endif