#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "..\h\AEUtils.h"
#include "..\h\console.h"


// These routines are not part of the engine,
// but some useful things when working with it.


// turns postcoloring ON for the current node (see aenode for further explanation)
void EnablePostColoring(AENODE *node)
{
int i,numvert;
	if (!node->PostColors) {
		numvert=((AETRIMESH*)(node->Obj))->NumVert;
		node->PostColor=true;
		node->PostColors=new FCol[numvert];
		for (i=0;i<numvert;node->PostColors[i++].Set(1,1,1));
	}
}


// searches for the substring "splinter" in the
// names of the meshes, and returns the number of
// the first hit (src->Trimesh[x])
int FindTrimesh(AE3DS *src, char *splinter)
{
	for (int i=0;i<src->NumTrimeshes;i++) {
		if (strstr(src->Trimesh[i]->Name,splinter)) return(i);
	}
	return(-1);
}


// same as above, but for nodes (src->Nodes[x])
int FindNode(AE3DS *src, char *splinter)
{
	for (int i=0;i<src->NumNodes;i++) {
		if (strstr(src->Nodes[i]->Name,splinter)) return(i);
	}
	return(-1);
}