#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "..\h\AE.h"
#include "..\h\console.h"

AECAMERA::AECAMERA()
{
}

AECAMERA::~AECAMERA()
{
}

void AECAMERA::FOV()
{
  int i;
  static struct 
  {
    float lens, fov;
  } lens_table[] = {
    {15.0f,  115.0f}, {20.0f, 94.28571f}, {24.0f, 84.0f}, {28.0f,  76.36364f},
    {35.0f,  63.0f},  {50.0f, 46.0f},     {85.0f, 28.0f}, {135.0f, 18.0f},
    {200.0f, 12.0f}
  };

  for (i=0;i<9;i++) 
	  if (Lens == lens_table[i].lens) Fov = lens_table[i].fov;
	  else Fov = 15.0f / Lens * 160.f;
}

void AECAMERA::InitCameraMatrix()
{
	Vector  N, U, V;
	Matrix  ct, cr;
	float cF,sF,ctF;
	float n,f,k;
	GLint	params[4];
	float	Ratio;

	glGetIntegerv(GL_VIEWPORT, &params[0]);
	Ratio=(float)params[2]/(float)params[3];

	N=Pos-Trg;
	if (fabs(N.z)<0.00001f) N.z=0.00001f;
	Front=N;
	Up.Set((float)sin((float)Roll*PI/180.f),(float)cos((float)Roll*PI/180.f),0);

	N.Normalize();
	U=N%Up;
	U.Normalize();
	V=U%N;

	cr.m[0][0]=U.x;	cr.m[0][1]=V.x;	cr.m[0][2]=N.x;	cr.m[0][3]=0;
	cr.m[1][0]=U.y;	cr.m[1][1]=V.y;	cr.m[1][2]=N.y;	cr.m[1][3]=0;
	cr.m[2][0]=U.z;	cr.m[2][1]=V.z;	cr.m[2][2]=N.z;	cr.m[2][3]=0;
	cr.m[3][0]=0;	cr.m[3][1]=0;	cr.m[3][2]=0;	cr.m[3][3]=1;

	ct.Translate(-Pos);

	cF=(float)cos(Fov*PI/360.f);
	sF=(float)sin(Fov*PI/360.f);
	ctF=cF/sF;

	n=NearClippingPlane;
	f=FarClippingPlane;
	k=n-f;

	Projection.m[0][0]=ctF; Projection.m[0][1]=0;	Projection.m[0][2]=0;		Projection.m[0][3]=0;
	Projection.m[1][0]=0;	Projection.m[1][1]=ctF*Ratio;	Projection.m[1][2]=0;   Projection.m[1][3]=0;
	Projection.m[2][0]=0;	Projection.m[2][1]=0;	Projection.m[2][2]=(n+f)/k;	Projection.m[2][3]=-1;
	Projection.m[3][0]=0;	Projection.m[3][1]=0;	Projection.m[3][2]=(2*n*f)/k;	Projection.m[3][3]=1;

	WorldToCamera=ct*cr;
	WorldToScreen=WorldToCamera*Projection;
}
