#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include <ijl.h>
#include "..\h\AE.h"
#include "..\h\console.h"

extern PFNGLACTIVETEXTUREARBPROC          glActiveTextureARB;
extern PFNGLMULTITEXCOORD2FARBPROC        glMultiTexCoord2fARB;

AE::AE() 
{
	swfiller=NULL;
	//swfiller=new AEFILLER(160,100);
	NumNodes=0;
	NumDummies=0;
	NumObjs=0;
	NumCams=0;
	NumTrimeshes=0;
	NumLights=0;
	NumAmbients=0;
	NumMats=0;
	NumMaps=0;
	Stamp=0;

	NumObjNodes=0;
	NumCamNodes=0;
	NumCTargetNodes=0;
	NumSpotlightNodes=0;
	NumLightNodes=0;
	NumLTargetNodes=0;
	NumAmbientNodes=0;
	CurrFrame=0;

	Ambient=new AEAMBIENT;
	Ambient->Col.Set(1,1,1);

	GlowMap=NULL;

	DefaultNearClippingPlane=1.0;
	DefaultFarClippingPlane=10000.0;

	MotionBlur=false;
}


AE::~AE()
{
/*	int i;
	
	for (i=0;i<NumTrimeshes;i++) 
		delete Trimesh[i];
	for (i=0;i<NumNodes;i++) 
		delete Nodes[i];
	delete Nodes;
	delete ObjNode;
	delete CameraNode;
	delete CTargetNode;
	delete LightNode;
	delete LTargetNode;
	delete SpotlightNode;
	delete AmbientNode;
	delete Ambient;
	NumNodes=0;	
	NumDummies=0;	
	NumObjs=0;	
	NumCams=0;	
	NumTrimeshes=0;
	NumLights=0;
	NumAmbients=0;
	NumMats=0;
	NumMaps=0;
	Stamp=0;

	NumObjNodes=0;
	NumCamNodes=0;
	NumCTargetNodes=0;
	NumSpotlightNodes=0;
	NumLightNodes=0;
	NumLTargetNodes=0;
	NumAmbientNodes=0;*/
}

// Set active camera (0..max-1)
void AE::SetCamera(int i)
{
	if (i>=NumCams) i=NumCams-1;
	ActiveCamera=Camera[i];
}

// Preparing the renderer for given frame "t"
void AE::SetFrame(float t)
{
	int i;
	Vector v;
	float f;
	FCol c;

	// class member "CurrFrame"
	CurrFrame=t;

	// evaluating attributes for the given frame
	for (i=0;i<NumNodes;i++) 
	{
		if (Nodes[i]->Obj->Type==TRIMESH || Nodes[i]->Obj->Type==DUMMY)
		{
				Nodes[i]->Hidden=Nodes[i]->HideTrack.GetStatus(t);
				Nodes[i]->LocalToWorld=Nodes[i]->RotTrack.Evaluate(t);
				v=Nodes[i]->PosTrack.Evaluate(t);

				Nodes[i]->LocalToWorld.Location(v);
				Nodes[i]->LocalToWorld.ScaleRows(Nodes[i]->ScaleTrack.Evaluate(t));
		} else
		switch (Nodes[i]->Type)
		{
			case CAMERANODE:
				Nodes[i]->LocalToWorld.Identity();
				v=Nodes[i]->PosTrack.Evaluate(t);
				((AECAMERA*)Nodes[i]->Obj)->Pos=v;
				
				f=Nodes[i]->RollTrack.Evaluate(t);
				((AECAMERA*)Nodes[i]->Obj)->Roll=f;
				
				f=Nodes[i]->FovTrack.Evaluate(t);
				((AECAMERA*)Nodes[i]->Obj)->Fov=f;
				break;

			case CTARGETNODE:
				Nodes[i]->LocalToWorld.Identity();
				v=Nodes[i]->PosTrack.Evaluate(t);
				((AECAMERA*)Nodes[i]->Obj)->Trg=v;
				break;

			case LIGHTNODE:
				Nodes[i]->LocalToWorld.Identity();
				v=Nodes[i]->PosTrack.Evaluate(t);
				((AELIGHT*)Nodes[i]->Obj)->Pos=v;

				c=Nodes[i]->ColTrack.Evaluate(t);
				((AELIGHT*)Nodes[i]->Obj)->Col=c;
				break;

			case AMBIENTNODE:
				c=Nodes[i]->ColTrack.Evaluate(t);
				((AEAMBIENT*)Nodes[i]->Obj)->Col=c;
				break;
		}
	}

	// calculating local matrices by travelling the tree
	CalcMatrix(&Eve);

	// transforming cameras and lights to world-space
	for (i=0;i<NumCamNodes;i++) {
		((AECAMERA*)CameraNode[i]->Obj)->Pos=CameraNode[i]->LocalToWorld*((AECAMERA*)CameraNode[i]->Obj)->Pos;
	}
	for (i=0;i<NumCTargetNodes;i++) {
		((AECAMERA*)CTargetNode[i]->Obj)->Trg=CTargetNode[i]->LocalToWorld*((AECAMERA*)CTargetNode[i]->Obj)->Trg;
	}
	for (i=0;i<NumLightNodes;i++) {
		((AELIGHT*)LightNode[i]->Obj)->Pos=LightNode[i]->LocalToWorld*((AELIGHT*)LightNode[i]->Obj)->Pos;
	}
}

// recursive local matrix calculator
void AE::CalcMatrix(AENODE *Parent)
{
AENODE *Current=Parent->FirstDaughter;

	while (Current) {
		Current->LocalToWorld=Current->LocalToWorld*Parent->LocalToWorld;
		if (Current->FirstDaughter) CalcMatrix(Current);
		Current=Current->NextSister;
	}
}


// Renders the given frame
void AE::RenderFrame()
{
	int i,prevID;
	AEMAT *Mat;
	GLint	params[4];

	Stamp++;
	ActiveCamera->InitCameraMatrix();

	// Querying viewport parameters for possible further use
	glGetIntegerv(GL_VIEWPORT, &params[0]);
	ScreenWidth=params[2]; ScreenHeight=params[3];

	// Initializing the projection matrix
	// I don't use the corresponding opengl functions,
	// to prevent collision between opengl's and my transformations
	// (eg: visibility checking)
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixf(&ActiveCamera->Projection.m[0][0]);

	// Init modelview to camera matrix
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixf(&ActiveCamera->WorldToCamera.m[0][0]);

	// pass 1 - solid objects
	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);

	prevID=-1;
	for (i=0;i<NumNodes;i++) 
	{
		if ((Nodes[i]->Type==OBJECTNODE) && (!Nodes[i]->Hidden))
		{
			Mat=((AETRIMESH*)(Nodes[i]->Obj))->Material;
			if (Mat!=NULL) 
			{ // has material
				if (Mat->Transparency==0) 
				{// opaque
					glActiveTextureARB(GL_TEXTURE0_ARB);  // current texture level = 0
					if (Mat->TextureMap==NULL) {// no texture
						glDisable(GL_TEXTURE_2D);
					} else {
						glEnable(GL_TEXTURE_2D);
						if (Mat->TextureMap->ID!=prevID) { // switch textures only if it differs from the previous
							glBindTexture(GL_TEXTURE_2D,Mat->TextureMap->ID);
							prevID=Mat->TextureMap->ID;
						}
					}
					glActiveTextureARB(GL_TEXTURE1_ARB); // current texture level = 1
					if (Mat->EnvMap) { // if envmapped
						glEnable(GL_TEXTURE_2D);
						glBindTexture(GL_TEXTURE_2D,Mat->EnvMap->ID);
					} else {
						glDisable(GL_TEXTURE_2D);
					}
					Nodes[i]->Render(ActiveCamera,Ambient,Light,NumLights,Stamp);
				}
			}
			else 
			{ // has no material (something's wrong with this object...)
				Nodes[i]->Render(ActiveCamera,Ambient,Light,NumLights,Stamp);
			}
		}
	}

	// pass 2 - additive objects (no other type of blending is supported in this release)
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_BLEND);						// enable blending
	glBlendFunc(GL_ONE, GL_ONE);
	glDepthMask(GL_FALSE);
	glActiveTextureARB(GL_TEXTURE1_ARB); 
	glDisable(GL_TEXTURE_2D);
	prevID=-1;
	for (i=0;i<NumNodes;i++) 
	{
		if ((Nodes[i]->Type==OBJECTNODE) && (!Nodes[i]->Hidden))
		{
			Mat=((AETRIMESH*)(Nodes[i]->Obj))->Material;
			if (Mat!=NULL)
			{
				if (Mat->Transparency!=0)
				{ // transparent
					glActiveTextureARB(GL_TEXTURE0_ARB); 
					if (Mat->TextureMap==NULL) 
					{// no texture
						glDisable(GL_TEXTURE_2D);
					} else { // textured
						glEnable(GL_TEXTURE_2D);
						if (Mat->TextureMap->ID!=prevID) { // switch textures only if it differs from the previous
							glBindTexture(GL_TEXTURE_2D,Mat->TextureMap->ID);
							prevID=Mat->TextureMap->ID;
						}
					}
					Nodes[i]->Render(ActiveCamera,Ambient,Light,NumLights,Stamp);
				}
			}
		}
	}
	glDepthMask(GL_TRUE);
}

// QUICK HACK TO PASS TEXTURE DIMENSIONS - ANNIHILATE IT!!!!!!:))
int texx, texy;

// Decompresses a JPEG texture from given filename to a memory buffer
int AE::LoadTexture(char *TName, unsigned char *Texels) {
	JPEG_CORE_PROPERTIES jcprops;
	int res;

	res=ijlInit(&jcprops);
	if (res!=IJL_OK)
	{
		ijlFree(&jcprops);
		return(0x801);		//	ijlInit Failure
	}

	jcprops.JPGFile=TName;
	res=ijlRead(&jcprops,IJL_JFILE_READPARAMS);
	if (res != IJL_OK) // no such file, trying to fall back to "default.jpg"
	{
		jcprops.JPGFile="default.jpg\0";	
		res=ijlRead(&jcprops,IJL_JFILE_READPARAMS); // if unsuccesful, nothing happens, error should be handled - but in this release
	}

	// no bigger than 1024*1024
	if (jcprops.JPGWidth>1024 || jcprops.JPGHeight>1024) 
		return(0x803);// incorrect size

	texx=jcprops.JPGWidth;
	texy=jcprops.JPGHeight;
	jcprops.DIBWidth=jcprops.JPGWidth;
	jcprops.DIBHeight=jcprops.JPGHeight;
	jcprops.DIBChannels=3;
	jcprops.DIBColor=IJL_RGB;
	jcprops.DIBPadBytes=0;
	jcprops.DIBBytes=Texels;

	res=ijlRead(&jcprops,IJL_JFILE_READWHOLEIMAGE);
	if (res != IJL_OK)
	{
		ijlFree(&jcprops);
		return(0x804); //ijlRead Invalid File Format
	}

	res=ijlFree(&jcprops);
	if (res != IJL_OK) return(0x805); //ijlFree Failure
	return(0);
}


// Initializes the engine, mass clean-up and workarounds :)
int AE::InitAE(int InitFlag) {
Vector Min((float)999999.,(float)999999.,(float)999999.);
Vector Max((float)-999999.,(float)-999999.,(float)-999999.);
Vector Diff;
int	i,j;

	// default camera = first camera
	ActiveCamera=Camera[0];

	// this routine was supposed to calculate an approximated
	// far clipping plane, but as i removed the world-to-local
	// initalization from here, it went wrong.
	// anyways, it works like this: takes the whole world's
	// bounding box, multiplies the diagonal's length by 1.5.
	// works in 95% of cases, if the initial vertex coordinates
	// are in world-space, unlike here.
	if (InitFlag & AE_AUTOFAR) {
		for (i=0;i<NumTrimeshes;i++) {
			for (j=0;j<Trimesh[i]->NumVert;j++) {
				if (Trimesh[i]->Vertices[j].x<Min.x) Min.x=Trimesh[i]->Vertices[j].x;
				if (Trimesh[i]->Vertices[j].x>Max.x) Max.x=Trimesh[i]->Vertices[j].x;
				if (Trimesh[i]->Vertices[j].y<Min.y) Min.y=Trimesh[i]->Vertices[j].y;
				if (Trimesh[i]->Vertices[j].y>Max.y) Max.y=Trimesh[i]->Vertices[j].y;
				if (Trimesh[i]->Vertices[j].z<Min.z) Min.z=Trimesh[i]->Vertices[j].z;
				if (Trimesh[i]->Vertices[j].z>Max.z) Max.z=Trimesh[i]->Vertices[j].z;
			}
		}
		Diff=Max-Min;
		DefaultFarClippingPlane=Diff.Length()*(float)1.5;
	}

	// mass node-initalizations
	for (i=0;i<NumNodes;i++) {
		// LocalToWorld matrix to identity
		Nodes[i]->LocalToWorld.Identity();
		// Initializing node tracks
		if (Nodes[i]->HideTrack.NumKeys>0) Nodes[i]->HideTrack.Init();
		if (Nodes[i]->RotTrack.NumKeys>0) Nodes[i]->RotTrack.Init();
		if (Nodes[i]->PosTrack.NumKeys>0) Nodes[i]->PosTrack.Init();
		if (Nodes[i]->ScaleTrack.NumKeys>0) Nodes[i]->ScaleTrack.Init();
		if (Nodes[i]->RollTrack.NumKeys>0) Nodes[i]->RollTrack.Init();
		if (Nodes[i]->FovTrack.NumKeys>0) Nodes[i]->FovTrack.Init();
		if (Nodes[i]->HotspotTrack.NumKeys>0) Nodes[i]->HotspotTrack.Init();
		if (Nodes[i]->FalloffTrack.NumKeys>0) Nodes[i]->FalloffTrack.Init();
		if (Nodes[i]->ColTrack.NumKeys>0) Nodes[i]->ColTrack.Init();
		// if the node has an object....
		if (Nodes[i]->Obj) {
			if ((Nodes[i]->Obj)->Type==DUMMY) ((AEDUMMY*)Nodes[i]->Obj)->LocMatrix.Location(Nodes[i]->Pivot);
			if ((Nodes[i]->Obj)->Type==TRIMESH) {
				AETRIMESH *tmesh=(AETRIMESH*)Nodes[i]->Obj;
				AEMAT *tempmat=tmesh->Material;
				if (tempmat) { // material depending initializations
					// doublemapping jeloles
					if (tempmat->EnvMap) Nodes[i]->DoubleMapped=TRUE;
					if (tempmat->Transparency!=0) {
						// transparent things are NOT shaded by default
						if (InitFlag & AE_DONTSHADETRANSPARENT) Nodes[i]->Shaded=false;
						// transparent things are two-sided by default
						((AETRIMESH *)Nodes[i]->Obj)->TwoSided=true;
					}
				}
				// set twosided attribute if desired
				if (InitFlag & AE_TWOSIDED) ((AETRIMESH *)Nodes[i]->Obj)->TwoSided=true;
				// fog on/off by default
				if (InitFlag & AE_FOG) Nodes[i]->FogEnabled=true;
				// pre-multiplied mastercolor on/off
				if (InitFlag & AE_MASTERCOLOR) Nodes[i]->MasterColor=true;
				// include light-distances in lighting calculations if desired
				if (InitFlag & AE_LIGHTDISTANCECOUNTS) Nodes[i]->LightDistanceCounts=TRUE;
				// shading on/off
				if (InitFlag & AE_DONTSHADE) Nodes[i]->Shaded=FALSE;
				// wireframe on/off
				if (InitFlag & AE_WIREFRAME) Nodes[i]->WireFrame=TRUE;
				// swfiller pointer
				Nodes[i]->swfiller=swfiller;
				// generate default bbox & normal
				tmesh->CalcBBox();
				tmesh->CalcNormals();
				for (j=0;j<tmesh->NumFaces;j++) tmesh->Faces[j].Flag=0;
			}
		}
	}

	// Initialize lights (sets some precalced informations for speeding up the lighting process)
	for (i=0;i<NumLights;i++) {
		Light[i]->InnerRange2=Light[i]->InnerRange*Light[i]->InnerRange;
		Light[i]->OuterRange2=Light[i]->OuterRange*Light[i]->OuterRange;
		Light[i]->FadingRange=1.0f/Light[i]->OuterRange-Light[i]->InnerRange;
		Light[i]->Fading=0.5f;
		if (InitFlag & AE_DRAWGLOWS) Light[i]->Draw=true;
	}

	// set default near/far clipping planes for every camera
	for (i=0;i<NumCams;i++) {
		Camera[i]->NearClippingPlane=DefaultNearClippingPlane;
		Camera[i]->FarClippingPlane=DefaultFarClippingPlane;
	}

	// perspective correction / filtering ON
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_DEPTH_TEST);
	// switches opengl to material tracking mode, eg
	// any color settings will be set immediately
	glEnable(GL_COLOR_MATERIAL);

	// creating a temporary texture storage
	unsigned char *Texels=new unsigned char[1024*1024*3];
	
	// generating "NumMaps" texture IDs
	GLuint *TextInt=new GLuint[NumMaps];
	glGenTextures(NumMaps,TextInt);

	// loading textures
	for (i=0;i<NumMaps;i++)
	{
		Map[i]->ID=TextInt[i];
		int res=LoadTexture(Map[i]->File,&Texels[0]);
		if (res!=0) 
		{
			Map=NULL;
			return(res);
		}

		// bind to texture stage 0, may be buggy when an envmap
		// is bound, mainly on 3dfx cards (voodoo2/3) although
		// i had no problems with it
		glActiveTextureARB(GL_TEXTURE0_ARB); 
		// set active texture ID
		glBindTexture(GL_TEXTURE_2D,TextInt[i]);
		// build mipmaps from the loaded texture and upload to opengl texture pool
		gluBuild2DMipmaps(GL_TEXTURE_2D, 3, texx, texy, GL_RGB, GL_UNSIGNED_BYTE, &Texels[0]);
		// texture wrapping mode = repeat
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		// bilinear mipmapping
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_PRIORITY, 1);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
	}
	delete TextInt;
	delete Texels;
	return(0);
}
