// -*- C++ -*-
//
// $Id: main.cc,v 1.3 2000/04/15 13:50:18 alcibiade Exp $
//
// Copyleft (c) 2000, Brioche/Aspirine <brioche@linuxbe.org>
// 
// Demonstration program to show how to use dynamicaly loadable
// Objects in a C++ program 
//
// This example illustrate the Proxy-based solution although
// the Adpater class is provided (see adapter.h)
//
// Feedback is welcome!
//



#include <iostream>
#include <cstdio>
#include <unistd.h>

#include "proxy.h"


// Awful C-like string hack with horrible possible buffer overrun  :)
const char* make_path(char* plugin_name)
{
  enum { buff_size = 256 };
  static char buff[buff_size];
  sprintf(buff, "%s/%s", getcwd(buff, buff_size), plugin_name);
  return buff;
}



int main(int argc, char* argv[])
{
  try {

    cout << "Starting an eleet piece of software..." << endl;
    cout << "Loading plugins..." << endl;
    Plugin_proxy p1(make_path("plugin1.so"));
    Plugin_proxy p2(make_path("plugin2.so"));

    cout << "Listing plug-ins..." << endl;
    cout << p1.info() << endl;
    cout << p2.info() << endl;

    cout << "Testing plug-ins..." << endl;
    p1.greet("Colas/Aspirine^Move");
    p2.greet("all the readers of Hugi's Coding Corner"); 

    cout << "Bye!" << endl;

  } catch (exception& e) {

    cerr << e << endl;
    return 1;

  }

  return 0;
}

