function randomGenerator(seed) {
  // xorshift-based prng
  let s = seed.reduce((acc, val) => ((acc * 31) + val) >>> 0, 1);
  return function() {
    s ^= (s << 13);
    s ^= (s >>> 17);
    s ^= (s << 5);
    return (s >>> 0) / 4294967296;
  };
}

function lightenColor(hex, amt) {
  const num = parseInt(hex.slice(1), 16);
  let r = (num >> 16) + amt;
  let g = ((num >> 8) & 0xff) + amt;
  let b = (num & 0xff) + amt;
  if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;
  return "#" + ((r<<16)|(g<<8)|b).toString(16).padStart(6,"0");
}

function randomColor(rng) {
  const palette = ["#5E1675", "#EE4266", "#BC723F", "#337357", "#246", ""];
  return palette[Math.floor(rng() * palette.length)];
}

/**
 * draw a ring of petals for the rosette
 */
function drawPetalRing(ctx, pCount, ringSize, ringShift, rng, colors) {
  ringShift*=0.;
  for (let i = 0; i < pCount; i++) {
    ctx.rotate((2 * Math.PI) / pCount);

    ctx.beginPath();
  
    ctx.fillStyle = colors[Math.floor(rng() * colors.length)];
    let ext = 0.2 + rng() * 0.15;
    ext += rng() * 0.5;
    ext += ringShift;
    ctx.moveTo(0, -ringSize * 0.25);
    ctx.bezierCurveTo(
      ringSize * 0.1, -ringSize * (0.3 + ext),
      ringSize * 0.25, -ringSize * (0.1 + rng() * 0.2),
      0, -12 + rng()*0
    );
    ctx.fill();
  }
}

function drawCenterRosette(ctx, cx, cy, size, rng, colors) {
  ctx.save();
  ctx.translate(cx, cy);

  // random petal count from these evens
  const possibleCounts = [3, 5, 7, 9, 11];
  const petalCount = possibleCounts[Math.floor(rng() * possibleCounts.length)];

  // main ring
  drawPetalRing(ctx, petalCount, size, 0, rng, colors);

  // center button
  ctx.beginPath();
  ctx.fillStyle = colors[Math.floor(rng() * colors.length)];
  ctx.arc(0, 0, size * 0.1 * (rng()+0.5), 0, 2 * Math.PI);
  ctx.fill();

  ctx.restore();
}

function drawTile(ctx, size, seed) {
  const rng = randomGenerator(seed);

  // pick base color
  const base = randomColor(rng);
  const colors = [lightenColor(base, 110), base, lightenColor(base, 60)];

  // fill white
  ctx.fillStyle = "#ffffff";
  ctx.fillRect(0, 0, size, size);

  // center rosette
  const rosetteCount = 3;
  for (let i = 0; i < rosetteCount; i++) {
    const centerX = Math.sin(i * (2 * Math.PI) / rosetteCount) * 30;
    const centerY = Math.cos(i * (2 * Math.PI) / rosetteCount) * 30;
    // ctx.rotate((2 * Math.PI) / 3);
    drawCenterRosette(ctx, size * 0.5 + centerX, size * 0.5 + centerY, size * 0.45, rng, colors);
  }

// add curve at top to show orientation
  ctx.beginPath();
  ctx.moveTo(5,0);
  ctx.fillStyle = colors[Math.floor(rng() * colors.length)];
  ctx.bezierCurveTo(
      0+rng()*10, 10+rng()*10,
      100-rng()*10, 10+rng()*10,
      95, 0
  );
  ctx.fill();
}

function draw(ctx, seed) {
  drawTile(ctx, 100, seed);
}
// usage:
draw(ctx, seed);

