;	BOMBER in only 256 bytes
; 	Coded by Ko-Ko in 2025. e-mail: kolma.kornel@gmail.com
;	Commodore 64 version.
;
; 	If you like it, send me a real postcard just like in the good old days.
; 
; 	NAME:
;	Kornel Kolma (Ko-Ko)
;
; 	ADDRESS:
; 	Frigyes u. 10.
; 	Budapest
; 	H1039
; 	Hungary
;
;	DESCRIPTION:
;
;	HOW TO LOAD, START AND PLAY:
;	load "bomber256.prg",8,1
;	sys 4096
;	The game starts immediately. 

!to "bomber256.prg",cbm
*= $1000 					; sys 4096


plane 		= $e0			; position of the plane
building	= $e2			; current building position
bomb 		= $e4			; bomb screen coords
clrbomb		= $e6
tmp			= $e8
tmp2		= $e9
planespeed	= $ea
score 		= $fb

rasterline	= $d012
hscroll		= $d016
bordercolor	= $d020
screencolor	= $d021

keyporta 	= $dc02			;io column
keyportb 	= $dc03			;io raw
keycol 		= $dc00 		;portA -> keyboard matrix column
keyrow 		= $dc01			;portB -> keyboard matrix raw
getin		= $ffe4			;Kernal GETIN
clrscrn		= $e544
plot		= $e50C			;moves cursor to (y,x)
printnum	= $bdcd			

start:
	lda #0
	sta score
	sta score+1

onemoreround:
	jsr clrscrn
	lda #$00				;init
	sta tmp
	;sta bordercolor
	sta planespeed
	sta clrbomb
	lda #$04
	sta plane
	sta plane+1
	sta clrbomb+1
	
	ldx #40
onemorebuilding:
	clc
	lda #$c0
	adc tmp
	sta building
	lda #$07
	sta building+1
	lda $dc04				;"random" number generator for the buildings
	and #%00001111			
	lsr
	sta tmp2 				;tm2 = random number
	inc tmp2 				;make at least 1
drawbuildings:
	ldy #$00
buildingtype:				;change building type with eor
	lda #$bd
	sta (building),y
	sec
	lda building
	sbc #40
	sta building
	bcs nonewseg
	dec building+1
nonewseg:
	dec tmp2 	
	bne drawbuildings
	; lda buildingtype+1
	; eor #$1f
	; sta buildingtype+1
	inc tmp
	dex
	bne onemorebuilding

resetbombing:
	lda #$00				;tmp = 0 no bombing
	sta tmp					
	sta tmp2				;under bombing
gameloop:	

	ldy	#$00				; print score
	ldx #$00
	jsr plot
	ldx score
	lda score+1
	jsr printnum

	ldy #$00	
	lda #$20
	sta (plane),y
	iny
	lda #$62
	sta (plane),y
	iny
	lda #$df
	sta (plane),y
	iny
	lda (plane),y			;check collusion
	cmp #$20
	beq	nocollusion
gameover:
	inc bordercolor			;booomm!!!
	jsr getin
	cmp #$0d				;enter to start again
	bne gameover			;game over
	jmp start
nocollusion:

	jsr getin
	cmp #$20		  		;space pressed?
	bne nospace
	lda #$01
	sta tmp					;start bombing
	lda tmp2
	;cmp #$00				;reset bomb counter?
	bne nospace
	lda plane+1				;set starting coords of the bomb for the first time
	sta bomb+1
	clc
	lda plane
	adc #42					;1 line under the middle of the plane
	sta bomb
	bcc noccbmb
	inc bomb+1
noccbmb:
	sta tmp2				;any but not zero
nospace: 	
	ldy #10					;game speed -> good for leveling			
waitsync:
    ldx rasterline
    inx
    bne waitsync
	dey
	cpy #$00
	bne waitsync

	lda tmp
	;cmp #$00
	beq	nobombing
	lda #$20
	sta (clrbomb),y
bombcharchange:
	lda #$56				;bomb char (version:2b eor 01, 5b eor 56)
	sta (bomb),y
	lda bombcharchange+1
	eor #$0d
	sta bombcharchange+1
	lda bomb
	sta clrbomb
	lda bomb+1
	sta clrbomb+1
	clc
	lda bomb
	adc #40
	sta bomb
	bcc noccbombing:
	inc bomb+1
noccbombing:
	lda bomb+1				; if bomb position is greater than screen (07f8)
	cmp #08
	bne nobombing
	lda #$20
	sta (clrbomb),y
	jmp resetbombing
	
nobombing:
	inc planespeed
	lda planespeed
	cmp #$02
	bne nonewblock
	lda #$00
	sta planespeed
	inc score
	bne noscorePlus1
	inc score+1
noscorePlus1:
	inc plane
	bne nonewblock
	inc plane+1
nonewblock:
	jmp gameloop