;------------------------------
;Watching the Moon
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;1024b intro
;Lovebyte 2025
;
;647 bytes of code
;359 bytes of data
;2 bytes of header
;1008 bytes total 
;------------------------------

.TARGET_SIZE=1024

s1=$80
s2=$81
s3=$82
s4=$83
b3=$84
b4=$85
CycleStep=$86

Pointer=$40
Table=$3000
Blocks=Table << 1
CustomCharset=$2000


*=$900-4 ; SYS 2300

.CODE_START
   sei 
   jmp Init

Tree
!byte $00,$10,$00,$00,$18,$00,$00,$18,$00,$00,$3c,$00,$00,$3c,$00,$00
!byte $7e,$00,$00,$7e,$00,$00,$ff,$00,$01,$ff,$80,$00,$fe,$00,$01,$ff
!byte $00,$03,$ff,$80,$07,$ff,$c0,$0f,$ff,$e0,$00,$ff,$00,$01,$ff,$80
!byte $03,$ff,$c0,$07,$ff,$e0,$0f,$ff,$f0,$1f,$ff,$f8,$3f,$ff,$fc,$01

!byte $03,$ff,$c0,$07,$ff,$e0,$0f,$ff,$f0,$1f,$ff,$f8,$3f,$ff,$fc,$7f
!byte $ff,$fe,$ff,$ff,$ff,$00,$18,$00,$00,$18,$00,$00,$18,$00,$00,$18
!byte $00,$00,$18,$00,$00,$18,$00,$00,$18,$00,$00,$18,$00,$00,$18,$00
!byte $00,$18,$00,$00,$18,$00,$00,$18,$00,$00,$18,$00,$00,$18,$00,$01\

Deer
!byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$08,$04,$00,$10
!byte $02,$00,$1c,$0e,$00,$10,$03,$00,$30,$03,$00,$30,$03,$00,$30,$03
!byte $00,$10,$02,$00,$19,$26,$00,$0f,$38,$00,$03,$30,$00,$0f,$fc,$00
!byte $07,$f8,$00,$01,$e0,$00,$01,$e0,$00,$01,$f0,$00,$01,$f0,$00,$01

!byte $01,$f0,$00,$00,$f8,$00,$00,$ff,$e0,$00,$ff,$f8,$00,$ff,$fc,$00
!byte $ff,$fe,$00,$ff,$fe,$00,$ff,$fe,$00,$7f,$fc,$00,$7f,$fc,$00,$3f
!byte $dc,$00,$35,$cc,$00,$34,$cc,$00,$34,$cc,$00,$14,$64,$00,$14,$24
!byte $00,$14,$22,$00,$14,$42,$00,$14,$42,$00,$14,$42,$00,$14,$42,$01


Moon
!byte $00,$50,$00,$03,$1d,$00,$0a,$f0,$80,$1c,$1c,$40,$13,$33,$10,$35
!byte $00,$10,$41,$00,$10,$68,$01,$e8,$21,$90,$9c,$20,$86,$bc,$00,$9f
!byte $ec,$00,$8e,$fc,$01,$37,$e8,$13,$0a,$f8,$00,$a7,$f8,$02,$07,$f0
!byte $00,$43,$f0,$00,$26,$e0,$04,$87,$c0,$03,$f7,$00,$00,$38,$00;,$01

Init
   lsr $d011
   ldx #$ff
   stx $d01b
   stx $d00e ;Moon X
   inx
   stx $d020
   stx CycleStep
   stx $fc
   stx $d027  
   inx
   stx $d021
   stx $07f8    
   txa
   jsr $e536

   
;CopyRomCharset
   lda #$33
   sta $01

   lda #>CustomCharset
   sta $fd
   
   ldx #15
--  
   lda Chars,x
   sta $fa
   lda Chars+16,x
   sta $fb
   
   ldy #7
-
   lda ($fa),y
   and Mask,y
   sta ($fc),y
   dey
   bpl -
   
   lda $fc
   clc
   adc #8
   sta $fc
   bcc +
   inc $fd
+
   dex
   bpl --
   
   lda #$55
   sta CustomCharset+120
   sta CustomCharset+124
   lda #$44
   sta CustomCharset+122
   sta CustomCharset+126
   
   lda #$37
   sta $01
;---


   lda #11
   ldx #5
-
   sta $d028,x
   dex
   bpl -
   
   lda #12
   sta $d02f

   
;Clear memory   
   ldx #$30
   stx $d021
   stx $2c
- 
   jsr $e416
   lda $2c
   bpl -   
;--- 
  
      
;Create sprite-scanner   
   ldx #63
   stx $d00f ;Moon Y
   asl
-
   sta Pointer,x
   dex
   bpl -
   
   ldx #79
   lda #1
-
   sta Blocks+80*50,x
   dex
   bpl -   
   
   lda #$f0
   sta Pointer+0
   sta Pointer+3
   sta Pointer+6
   sta Pointer+9
;--- 
   
;Set screen and sprites
   lda #((($0400 & $3fff) / $0400) << 4) + (((CustomCharset & $3fff) / $0800) << 1)
   sta $d018
   
   lda #%01111111
   sta $d015
   lda #%11100110
   sta $d017
   sta $d01d
   
;Trees
   ldx #Tree/64
   stx $07f9
   stx $07fb
   inx
   stx $07fa
   stx $07fc

;Deer
   inx 
   stx $07fd
   inx
   stx $07fe
   
;Moon
   inx
   stx $07ff
      

;Tree 1   
   lda #24+14*4
   sta $d002
   sta $d004
   
;Tree 2   
   lda #24+29*4
   sta $d006
   sta $d008
      
;Deer   
   lda #24+43*4
   sta $d00a
   sta $d00c 
   
;Tree 1 and Deer
   lda #250-2*42
   sta $d003
   sta $d00b
   lda #250-42
   sta $d005
   sta $d00d   
;Tree 2  
   sta $d007
   lda #250-21
   sta $d009
;--- 
   


;CreateMask
   lda #>(Table+29*80)
   sta $fb

   lda #>(Blocks+29*80)
   sta $fd   
   
   lda #<(Table+29*80)
   sta $fa
   sta $fc
   
   ldy #29
MaskLoopY
   ldx #0
MaskLoopX      
   tya
   pha
   
   clc
   asl
   asl
   adc #50
   sta $d001
   
   lda #0
   sta $d010
   txa
   adc #24/4
   asl
   asl
   rol $d010
   sta $d000
   
   
   tya
   adc #56
-
   cmp $d012
   bne -
   
   dec $d020
   
   lda #56+50
-
   cmp $d012
   bne - 
   
   inc $d020 
   
   
   lda $d01e
   ldy #0
   sta ($fc),y
   tya
   sta ($fa),y
   
   inc $fa
   inc $fc
   bne +
   inc $fb
   inc $fd
+

   pla
   tay
   
   inx
   cpx #80
   bne MaskLoopX

   
   iny
   cpy #50
   bne MaskLoopY
;--- 
 
   asl $d011

   clc
   rol $d015
   
   
Loop
;Cycle
   lda #>Table
   sta $fb
   asl
   ;lda #>Blocks
   sta $fd   

   ldx #0
   stx $02
   lda CycleStep ;0 or 81
   sta $fa   
   sta $fc

LoopY   
   ldx #0
LoopX   
   ldy #81
   lda ($fa),y
   sta s4
   lda ($fc),y
   sta b4
   dey
   lda ($fa),y
   sta s3
   lda ($fc),y
   sta b3  
   ldy #1
   lda ($fa),y
   sta s2
   dey
   lda ($fa),y
   sta s1
   
   
   lda s3
   ora s4
   ora b3
   ora b4
   bne .CheckDown


   lda s1
   beq +
   
   jsr ClearTL
   jsr SetDL
      
   bvc .EndCheckUp

+

   lda s2
   beq .EndCheckUp
   
   jsr ClearTR
   jsr SetDR   
   
   bvc .EndCheckUp


.CheckDown
   lda s3
   ora b3
   bne .CheckS4
   
   lda s1
   beq +
   
   jsr ClearTL
   jsr SetDL   
   
   bvc .CheckS4
   
+   
   lda s2
   beq .EndCheckDown
   lda b4
   bne .EndCheckDown
   
   jsr ClearTR
   jsr SetDL    
   
   jmp .EndCheckDown
   
.CheckS4
   lda s4
   ora b4
   bne .EndCheckDown

   lda s2
   beq +
   
   jsr ClearTR
   jsr SetDR    
   
   bvc .EndCheckDown

+ 
   lda s1
   beq +
   lda b3
   bne +
   
   jsr ClearTL
   jsr SetDR     
+

.EndCheckDown 
.EndCheckUp
     

;DrawPoint
   txs
   stx .y
   
   ldx $02
   jsr $e9f0

   lda $fa
   sec
   sbc CycleStep
   sta $90
   lda $fb
   sbc #0
   sta $91
   

   ldy #81
   lda ($90),y
   asl
   dey
   ora ($90),y
   asl
   ldy #1
   ora ($90),y
   asl
   dey
   ora ($90),y
.y=*+1
   ldy #0
   sta ($d1),y
   
   lax $fa
   sbx #256-2
   stx $fa
   stx $fc
   bcc +
   inc $fb
   inc $fd
+   

   tsx
   

   inx
   cpx #40
   beq +
   jmp LoopX
+
   

   lax $fa
   sbx #256-80
   stx $fa
   stx $fc
   bcc +
   inc $fb
   inc $fd
+     

  
   lda #25
   isc $02
   bcc +
   jmp LoopY
+   


   lda CycleStep
   eor #81
   sta CycleStep
;   

-   
   lda $dc04
   eor $d012
   adc $dc05
   cmp #80
   bcs -
   tax
   lda #1
   sta Table,x
        
   jmp Loop
   
   
ClearTR
   ldy #1
   !byte $2c
ClearTL
   ldy #0
   lda #0
   sta ($fa),y
   rts

SetDR
   ldy #81
   !byte $2c
SetDL
   ldy #80
   lda #1
   sta ($fa),y
   rts

   
.CODE_END   
   
.DATA_START

Chars
;160,254,252,98,251,225,127,108,236,255,97,123,226,124,126,32
!byte <($d000+160*8),<($d000+254*8),<($d000+252*8),<($d000+98*8),<($d000+251*8),<($d000+225*8),<($d000+127*8),<($d000+108*8),<($d000+236*8),<($d000+255*8),<($d000+97*8),<($d000+123*8),<($d000+226*8),<($d000+124*8),<($d000+126*8),<($d000+32*8)
!byte >($d000+160*8),>($d000+254*8),>($d000+252*8),>($d000+98*8),>($d000+251*8),>($d000+225*8),>($d000+127*8),>($d000+108*8),>($d000+236*8),>($d000+255*8),>($d000+97*8),>($d000+123*8),>($d000+226*8),>($d000+124*8),>($d000+126*8),>($d000+32*8)

Mask
!byte $00,$aa,$44,$aa,00,$aa,$44,$aa
.DATA_END


!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   