
#ifdef VERTEX_SHADER
layout (location = 0) in vec3 aPos;  // Vertex position
layout (location = 1) in vec4 aColor; // Vertex color
layout (location = 2) in vec2 aTexcoord; // Texture coords

uniform mat4 modelMatrix; // Model matrix,
uniform mat4 viewMatrix; // View matrix
uniform mat4 projectionMatrix; // Projection matrix

out vec4 vertexColor; // Output color to fragment shader
out vec2 texcoord; // Output texture coords

void main() {
    gl_Position = projectionMatrix * viewMatrix * modelMatrix * vec4(aPos, 1.0f);
    vertexColor = aColor; // Pass color to fragment shader
    texcoord = aTexcoord; // Pass texture coords to fragment shader
}

#endif // VERTEX_SHADER

#ifdef FRAGMENT_SHADER
// Fragment Shader source

in vec4 vertexColor; // Input color from vertex shader
in vec2 texcoord; // Input texture coords
out vec4 FragColor; // Final output color

uniform sampler2D tex; // Texture sampler

void main() {
    vec4 texColor = texture(tex, texcoord); // Sample texture
    if(texColor.a < 0.5)
        discard;
    FragColor = texColor * vertexColor; // Set output color
}
#endif // FRAGMENT_SHADER