function renderCharacterToCanvas(character) {
  const size = 128;

  const canvas = document.createElement('canvas');
  canvas.width = size;
  canvas.height = size;

  const context = canvas.getContext('2d');
  context.font = `${size/2}px monospace`;
  context.textAlign = 'center';
  context.textBaseline = 'middle';
  context.textRendering = 'geometricPrecision';
  context.fillText(character, size/2, size/2, size);

  return canvas;
}

Demo.prototype.scenesCommonInit = function () {
  // https://unicode.org/emoji/charts/full-emoji-list.html#1f922
  const emojiList = [
    '😂', '😃', '😎', '🤔', '😢', '😡', '😍', '🥳', '🤯', '😴','😬','😈','🙈','✊','👀','🐍','😳',
    //bread emoji
    '🍞','😵‍💫','😊','😟','😠','🤬', '😭','💩','🫶', '🍆','🚢','🥇','🤪','🤑','🫠','🤖','🤓','👻','🌈','🤨','💅'
  ];
  emojiList.forEach((emojiChar) => {
    const emoji = new DemoEngine.Image();
    emoji.loadCustom(emojiChar, renderCharacterToCanvas);
  });
};

Demo.prototype.sceneBackground = function () {
  this.setScene('background');

//return;
  const deg2rad = 0.01745329251;
  const localCamPos = [0.0, 0.0, 0.0];
  const localCamDir = [0.0, 0.0, 0.1];
  const camFov = 75.0 * deg2rad;
  this.loader.addAnimation({
    start:8,
    image: ['_embedded/defaultTransparent.png'],
    perspective: '3d',
    //position:[{"x":0.0,"y":0.0,"z":1.0}],
    scale: [{ uniform2d: 1.0}],
    color:[{a:1.0}],
    /*"material":{
      depthTest: false,
      depthWrite: false,
      blending: 'NormalBlending'
    },*/
    "shader":{
      "name":["multiSceneEffects/rayMarcher.vs","multiSceneEffects/rayMarcher.fs"],
      "variable":
      [          
        {"name":"MAX_STEPS","type":"float","value":[45.0]},
        {"name":"MAX_DIST","type":"float","value":[30.0]},
        {"name":"inCamPos","type":"vec3","value":[localCamPos]},
        {"name":"camDirection","type":"vec3","value":[localCamDir]},
        {"name":"camNear","type":"mat4","value":[.05]},
        {"name":"camFar","type":"mat4","value":[100]},
        {"name":"camFov","type":"mat4","value":[camFov]},
        {"name":"effectType","type":"int","value":[2]}
      ]
    }
});

const alpha = 0.97;
this.loader.addAnimation({
    image: '_embedded/defaultWhite.png',
    color: [
      {r:0.1, g:0.1, b:0.1, a:0}
      ,{duration:8, r:238/255, g:175/255, b:97/255, a:alpha}
      ,{duration:2, r:251/255, g:144/255, b:98/255, a:alpha}
      ,{duration:2, r:238/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:106/255, g:13/255, b:131/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:251/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:251/255, g:144/255, b:98/255, a:alpha}
      ,{duration:2, r:238/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:106/255, g:13/255, b:131/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:251/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:251/255, g:144/255, b:98/255, a:alpha}
      ,{duration:2, r:238/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:106/255, g:13/255, b:131/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:251/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:251/255, g:144/255, b:98/255, a:alpha}
      ,{duration:2, r:238/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:106/255, g:13/255, b:131/255, a:alpha}
      ,{duration:2, r:206/255, g:73/255, b:147/255, a:alpha}
      ,{duration:2, r:251/255, g:93/255, b:108/255, a:alpha}
      ,{duration:2, r:251/255, g:144/255, b:98/255, a:alpha}
    ]
  });
}