local onebird={}
local okImage=false
local image=nil
local imgW,imgH=1,1
local W,H=1920,1080
local started=false
local useTimeline=false
local startT=0.0
local tSinceStart=0.0
local lastTimelineT=nil
local function tryLoadImage(path,minFilter,magFilter)
local ok,imgOrErr=pcall(function()
local img=love.graphics.newImage(path)
img:setFilter(minFilter or "linear",magFilter or "linear")
return img end)
if ok and imgOrErr then
return imgOrErr,nil
else
return nil,(imgOrErr or "failed to load image") end end
function onebird.load()
W,H=love.graphics.getWidth(),love.graphics.getHeight()
image,_=tryLoadImage("onebird.png","linear","linear")
okImage=image~=nil
if okImage then
imgW,imgH=image:getWidth(),image:getHeight()
else
imgW,imgH=1,1 end
started=false
useTimeline=false
startT=0.0
tSinceStart=0.0
lastTimelineT=nil end
function onebird.start(now)
started=true
tSinceStart=0.0
lastTimelineT=nil
if type(now)=="number" then
useTimeline=true
startT=now
else
useTimeline=false
startT=0.0 end end
function onebird.stop(now) end
function onebird.update(dt,timelineT)
W,H=love.graphics.getWidth(),love.graphics.getHeight()
if not started then
onebird.start(nil) end
if timelineT~=nil then
if not useTimeline then
useTimeline=true
startT=timelineT end
if(lastTimelineT==nil)or(timelineT>=lastTimelineT)then
lastTimelineT=timelineT
else
startT=timelineT
lastTimelineT=timelineT end end
if useTimeline and lastTimelineT~=nil then
tSinceStart=math.max(0.0,lastTimelineT-startT)
else
tSinceStart=tSinceStart+dt end end
local function layoutImage(imgW,imgH,winW,winH,scaleToFit,center)
local sx,sy=1,1
if scaleToFit then
local s=math.min(winW/imgW,winH/imgH)
sx,sy=s,s end
local dw,dh=imgW*sx,imgH*sy
local x,y=0,0
if center then
x=math.floor((winW-dw)*0.5+0.5)
y=math.floor((winH-dh)*0.5+0.5) end
return x,y,sx,sy end
function onebird.draw()
local showing=started and(tSinceStart<4.66)
if not showing then
return
end
if not okImage then
love.graphics.setColor(1,0.25,0.25,1)
love.graphics.print("onebird.png not found (place it next to main.lua)",20,20)
love.graphics.setColor(1,1,1,1)
return
end
local x,y,sx,sy=layoutImage(imgW,imgH,W,H,true,true)
love.graphics.setColor(1,1,1,1)
love.graphics.draw(image,x,y,0,sx,sy) end
return onebird
