;==============================================================================
; VINTAGE COMPUTING CHRISTMAS CHALLENGE 2024 (VC3 2024)
; platform    - Amstrad CPC 6128 Plus
; language    - Z80 assembly
; contributor - SYMBIOSIS
; credits     - BSC (ideas), PRODATRON (code, ideas, optimization)
; date        - December 2024
;------------------------------------------------------------------------------
; size        - 46 bytes
;==============================================================================

;from Basic start with...
;MEMORY &13FE
;LOAD"XC24SYMB"
;CALL &13FF

;as the gift consists mainly of 1+8+1+8+1 characters in both dimensions, the
;idea of this approach is to shift two 9-bit patterns for both the rows and
;columns to find out if we hit a row, a column, a node or nothing (4 different
;combinations)
;the two leading row/column bits are used to create an index for selecting the
;correct character for each position
;to save one byte (RET) the text and data behind the code is arranged and
;placed in a way, that it can be reused as an endless loop

txtout  equ #bb5a

adr_run equ 19*256+255      ;call address is #13ff and predefines DE;
                            ;A=0, CF=0, D=row counter, E,CF=9bit row pattern
adr_org equ #1f00-31        ;31 (see "len_sub") is the size until "txt_chars"
                            ;which has to be placed at #1f00
        org adr_org

        ld hl,txt_bow       ;plot bow (H=#1f)
gift1   rst #18             ;plot bow or just cr/lf
        dw rom_print
        ld bc,19*256+255    ;B=column counter, C,CF=9bit column pattern
        adc a               ;build row index (A=rowbit9), CF=0
gift2   rla                 ;add column index (A=2*rowbit9+1*columnbit9)
        ld l,a              ;HL=#1f0x
        ld a,(hl)           ;load char from indexed table
        call txtout         ;print it
        ld a,l              ;restore A
        rra                 ;restore column CF from A, A=row index
        rr c                ;move through column 9bit pattern
        djnz gift2          ;column loop
        rra                 ;restore row CF from A
        ld a,b              ;A is 0 again
        rl e                ;move through row 9bit pattern
        ld l,14             ;HL=#1f0e=txt_crlf
        dec d
        jr nz,gift1         ;row loop

len_sub equ $-adr_org
                            ;here the address is #1f00
txt_chars
        db "+","-","!"," "  ;as opcodes this is dec hl;dec l;ld hl,x;jp #1f00
                            ;so this will just loop forever
rom_print
        dw #c38b            ;prints 0-terminated string at HL (6128 specific)
        db 0
txt_bow
        db #1f,9,25,"\o/"   ;placing and plotting the bow
txt_crlf
        db 13,10            ;CR/LF for both the bow and the rows
                            ;(always followed by zeros)

len_all equ $-adr_org
