; A submission to the 'Vintage Computing Christmas Challenge 2024'
; for the 16/48k ZX Spectrum, assembled using sjasmplus assembler.
; https://logiker.com/Vintage-Computing-Christmas-Challenge-2024
;
; Written by spaceWumpus, December 2024.
;
; 

    DEVICE ZXSPECTRUM48

    CSPECTMAP "build/main.map"

;   From https://worldofspectrum.net/pub/sinclair/games-info/z/ZXSpectrumAssembler.txt
;       "In the Spectrum, the address of the first character after the REM in a REM
;       statement in line 1 of a program is always 23760, unless microdrives are in use.""

    org $5cd0 ; 23760 First char after REM in line 1 REM in a BASIC program.

    ; Note that SAVE### directives have 'main' listed as entry point.
main:
  di  ; Disable rupts so we can finish with halt

present:
  ; Char codes used in current row
  ; '+' $2b and '-' $2d
  ; Would normally need following line, but hl already contains this value!
  ; ld hl, $2d2b ; 3B

  ;ld d, $1 ; d is number of rows in active block
  ;ld e, $5	; Outer row block counter. 5 blocks of rows
  ld de, $0105 ; 3B

rowBlockOuter:
  ; Set number of rows in this block
  ld b, d 

  ; Update block size d to toggle between 1 and 8 rows in successive blocks
  ld a, d
  xor $9  
  ld d, a

rowBlockInner:
  push bc ; Store b.

;--------------------
; Print row
; Params:
;   H Repeated char
;   L Solo char
; Internal
;   B Char loop counter
;   C Block loop counter

  ; Print carriage return
  ld a, $0d
  rst $10	; Carriage return


  ; Print entire row
  ld c, $3  ; 3 times around the double chunk loop...
  jr lateIn ; ...with late start, gives 5 chunks altogether

  ; Print 8 copies of char in h  ("-" or " ")
rowDoubleChunkLoop:					;h =5	4	3	2	1
	ld b, $8					; Big chunk is always 8 char repeats
rowChunkCharLoop:
	ld a, h
	rst $10	; Print '-' or ' '
	djnz rowChunkCharLoop ; 2B
lateIn:
  ; Print char in l
  ld a, l
  rst $10 ; Print '+' or '!'

  dec c
	jr nz, rowDoubleChunkLoop

  pop bc
  djnz rowBlockInner


  ; Update for next row block

  ; Update chars
  ld a, $0d
  xor h ; '-'^' ' ; Toggle H between '-' and ' ' char code
  ld h, a

  ld a, l
  xor $0a ; '+'^'!' ; Toggle L between '+' and '!' char code
  ld l, a

  ; Loop back for next block
  dec e
  jr nz, rowBlockOuter


  ; Finally draw the bow at the top.
  ; We do this AFTER the main present, so that
  ; we can use the init value of hl on entry to 'present',
  ; rather than having to load it. (The call below trashes it)
bow: ; 15B
  ; 6B Set cursor pos to 9 characters across
  ld bc, $1719 ; 9 characters across. $1821 is (top? left)
  ;push de 1B (A1/2)
  call $0dd9

  ; 9B  Print '\O/'
  ld a, '\' ; $5c  2B
  rst $10   ;      1B
  ld a, 'O' ; $4f  2B
  rst $10   ;      1B
  ld a, '/' ; $2f  2B
  rst $10   ;      1B

  ; Finish
  halt ; 1B

codeEnd

; To query code length:
; In debug console:
;   -eval codeEnd - main
; e.g. report
;   58, 3Ah, 111010b
; means 58 bytes of code


; Top of stack
stack_top:

    ; Deployment, using 'main' as entrypoint
    SAVESNA "main.sna", main

    EMPTYTAP "main.tap"
    SAVETAP "main.tap", main

    ; Save machine code out as a code file:
    ; This file contains 2 bytes loading address, then 88 bytes of code:
    EMPTYTAP "code.tap"
    SAVETAP "code.tap", CODE, "code", main, $-main

    ; To create REM embedded BASIC version (compo submission):
    ;
    ; 1. In Spectrum emulator, create the following BASIC program (58 digits here in first line - need enough to hold the code):
    ;   1 REM 1234567890123456789012345678901234567890123456789012345678
    ;     REM is 'e'
    ;   2 RANDOMIZE USR 23760
    ;     RANDOMIZE is 'T'
    ;     USR is Ctrl-Shift 'L'
    ;     
    ;
    ; 2. 'Insert' the 'code.tap' file into the emulator
    ;
    ; 3. Load the assembled code into the REM:
    ;   LOAD "" CODE            J, Ctrl-P, Ctrl-P, Shift-Ctrl, I
    ;
    ; 3b. In Fuse: Media->Tape->Clear
    ;
    ; 4. Save the BASIC program with the embedded assembly:
    ;   SAVE "x"
    ;
    ; 4b. In Fuse: Media->Tape->Write, save as "submit.tap".
    ;
    ; 5. Run it
    ;   RUN
    ;
    ; Result is standard 19 byte header, followed by 84 bytes of BASIC containing embedded assembly (including flag byte and checksum byte),
    ;  so 82 bytes of combined BASIC loader code + assembly.
    ;
    ;
    ; Alternately, for 4, to create auto-runner, though this doesn't clear the screen before running:
    ;   SAVE "x" LINE 2
    ;     LINE is Ctrl-Shift Ctrl-3

