; =============================================================================
; Vintage Computing Christmas Challenge 2024 (VC³ 2024)
; Z80 assembly for Amstrad CPC
; desc. Draws a gift box. It uses a function to get the character from a set
;       of 4 "+-! ". a=2*(row divby 9) + (col divby 9)
; comments. I tried to make it small but readable. Enjoy it!
; author. issalig
; date. 22/12/24
; =============================================================================

        ORG     #8000                  ; Program start address

; =============================================================================
; Constants
; =============================================================================

PRINT_CHAR      EQU     #BB5A          ; Firmware print routine
CR              EQU     13             ; Carriage return
LF              EQU     10             ; Line feed
BOX_SIZE        EQU     18             ; Size of the box
DIV_VALUE       EQU     9              ; Divisible value for pattern

; =============================================================================
; Main Program
; =============================================================================

START:
        LD      HL, RIBBON             ; Print the decorative ribbon
        CALL    PRINT_STR

        LD      B, BOX_SIZE            ; Initialize row counter

LOOP_ROW:
        LD      C, BOX_SIZE            ; Initialize column counter

LOOP_COL:
        LD      A, B                   ; Get row
        CALL    DIVBY9                 ; divisible by 9
        ADD     A, A                   ; Multiply by 2
        LD      D, A                   ; Store result

        LD      A, C                   ; Get column
        CALL    DIVBY9                 ; divisible by 9
        ADD     A, D                   ; a=2*(row divby 9) + (col divby 9)

        LD      HL, CHARS              ; Get character address
        ADD     A, L                   ; Add offset
        LD      L, A                   ; Update it
        LD      A, (HL)                ; Load character
        CALL    PRINT_CHAR             ; Print the character

        DEC     C                      ; Next column
        JP      P, LOOP_COL            ; Continue if columns remain

        LD      HL, CRLF               ; Print newline
        CALL PRINT_STR

        DEC     B                      ; Next row
        JP      P, LOOP_ROW            ; Continue if rows remain

        RET                            ; End program

; =============================================================================
; Subroutines
; =============================================================================

; -----------------------------------------------------------------------------
; PRINT_STR - Print null-terminated string
; Input  HL = Address of string
; Output None
; -----------------------------------------------------------------------------
PRINT_STR:
        LD      A, (HL)                ; Get character
        AND     A                      ; Check for terminator
        RET     Z                      ; Return if end of string
        CALL    PRINT_CHAR             ; Print character
        INC     HL                     ; Next character
        JR      PRINT_STR              ; Continue printing

; -----------------------------------------------------------------------------
; DIVBY9 - Compute if divisible by 9
; Input  A = value
; Output A = 0 if input mod 9 is 0, otherwise 1
; -----------------------------------------------------------------------------

DIVBY9:
        CP      DIV_VALUE              ; Compare with 9
        JR      C, DIVBY9_LESS         ; If A < 9
        SUB     DIV_VALUE              ; Subtract 9
        JR      DIVBY9                 ; Repeat until A < 9

DIVBY9_LESS:
        OR A; CP      0                ; Check if 0, OR A saves 1 byte
        JR      Z, DIVBY9_ZERO         ; If A = 0, return 0
        LD      A, 1                   ; Else return 1 for non-zero results
DIVBY9_ZERO:
        RET

; =============================================================================
; Data Section
; =============================================================================

CHARS:  DB      '+-!'  ; Pattern characters. use first space from ribbon to 
                       ; save 1 byte
RIBBON: DB      '        \O/'
CRLF:   DB CR, LF, 0   ; Newline. 

        END

; =============================================================================
; Cheatsheet for size reduction
; =============================================================================

;    CP 0 -> OR A
;    LD A,0 -> XOR A
;    CALL nn -  RET -> JP NN
;    JR -> JP
