; Vintage Computing Christmas Challenge 2024
; entry for the Atari 8 bit home computer line
; (c) 2024 Irgendwer
; assembler: ca65
; build: cl65 -C atari-asm-xex.cfg ChristmasChallenge2024Readable.s -o CC24.xex
; Produces a file with 78 bytes, with 66 bytes of executed code/data

;.include "atari.inc"

.export start

.zeropage
currentAddress:
.res 2

.code
.proc start
	
	; working with hard-coded addresses is shorter		
	lda #$EA				; instead of "lda SAVMSC" + offset
	sta currentAddress
	lda #$BC				; instead of "lda SAVMSC+1" + offset
	sta currentAddress+1

	ldx #18
NextFullRow:
	ldy #18
NextHorLine:
	lda #13					; 11+2 = internal code for '-'
	sta (currentAddress),y

	; abuse part of the loop to display bow							
	
	; rely that data beyond defintion is clear
	; otherwise uncomment the following 2 lines
	; cpy #3
	; bcs cont							
	lda	BowData, y			; (three times, who cares?)
	sta $BCCA, y 			; again, hard coded address is shorter

cont:
	dey
	bpl NextHorLine
	lda #11					; internal code for '+'

MiddleAndOuterChars:
	ldy #0
	sta (currentAddress),y
	ldy #9
	sta (currentAddress),y
	ldy #18
	sta (currentAddress),y

EndOfRow:
	lda currentAddress
	clc
	adc #40
	sta currentAddress
	bcc addressReady
	inc currentAddress+1

addressReady:
	dex
endless:
	bmi endless				; done with printing
	beq	NextFullRow			; last line
	cpx #9					; middle line
	beq NextFullRow

VerticalElementRow:
	lda #1					; internal code for '!'
	bne	MiddleAndOuterChars	; like bra

BowData:
.byte	60,47,15			; internal codes for "\O/"

.endproc