; LIST USR 59656

	org 	233*256+8		; 59656

; display the knot
	call	#201c			; use TAB function, use the trick of skipping B-reg for TAB
	ld	a,d			; d is preset "\", saves 1 byte
	rst	16
	sub	b			; preset value in B makes "O", saves 1 byte
	rst	16
	ld	a,"/"			;  "/"
	rst	16			; knot now displayed

	call	fulllin			; display the topline

	call	halfbox			; now display half a box (and on return the second half)

halfbox	ld	e,c			; preset for 9 lines to display
linedis	push	hl			; first time stack last line, then stack midlines
	ld	hl,#2021		; make HL point to midlines
	dec	e
	call	p,linedis		; recursively preset the display, USE P-flag. WE NEED 9 lines!

	pop	hl			; retrieve current line to display recursively from halfbox

fulllin	ld	a,13			; set newline
	rst	16

	ld	a,l			; set first character on 
	rst	16

	call	halflin			; just 3 bytes to double "--------+" or "        !"
halflin	ld	b,c			; 8 characters to display, c preset saves a byte
lp8	ld	a,h			; " " or "-" 
	rst	16			; show repeating character
	djnz	lp8
	ld	a,l			; end the line with first character
	rst	16
	ret