import json, os, subprocess

BASEURL="https://www.rtz23.de/secretDemo/"

with open("config.minified.json","r") as f:
	j = json.load(f)

def parent(path):
	assert "/" in path, path
	return path[:path.rindex("/")]

def mkdirs(path):
	if os.path.isdir(path): return
	if "/" in path: mkdirs(parent(path))
	os.mkdir(path)

def download(v):
	if "/" in v["url"]:
		mkdirs(parent(v["url"]))
	if not os.path.exists(v["url"]):
		cmd = ["wget", "-O", v["url"], BASEURL+v["url"]+"?t="+v["hash"]]
		print(cmd)
		subprocess.call(cmd)
	if "variants" in v:
		for var in v["variants"].values():
			download(var)

for k,v in j["assets"].items():
	if v["file"] is None: continue
	download(v["file"])