﻿in vec2 uv;
in vec2 uvn;

out vec4 C;

uniform int tex_render;
uniform int tex;

#define SPAN_MAX   (8.0)
#define REDUCE_MIN (1.0/128.0)
#define REDUCE_MUL (1.0/32.0)
vec4 FXAA(sampler2D tex, vec2 uv) {
    vec2 size = R;
    vec2 px = 1.0 / size;
    vec3 col   = texture(tex, uv).rgb;
    vec3 col00 = texture(tex, uv + vec2(-0.5) * px).rgb;
    vec3 col11 = texture(tex, uv + vec2( 0.5) * px).rgb;
    vec3 col10 = texture(tex, uv + vec2(0.5, -0.5) * px).rgb;
    vec3 col01 = texture(tex, uv + vec2(-0.5, 0.5) * px).rgb;

    float lum = luma(col);
    float lum00 = luma(col00);
    float lum11 = luma(col11);
    float lum10 = luma(col10);
    float lum01 = luma(col01);

    vec2 dir = vec2((lum01 + lum11) - (lum00 + lum10),
    (lum00 + lum01) - (lum10 + lum11));

    float dirReduce = max((lum00 + lum10 + lum01 + lum11) * REDUCE_MUL, REDUCE_MIN);

    float rcpDir = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);

    dir = clamp(dir * rcpDir, -SPAN_MAX, SPAN_MAX) * px;

    vec4 A = 0.5 * (
    texture(tex, uv - dir * (1.0/6.0)) +
    texture(tex, uv + dir * (1.0/6.0)));

    vec4 B = A * 0.5 + 0.25 * (
    texture(tex, uv - dir * 0.5) +
    texture(tex, uv + dir * 0.5));

    float lumMin = min(lum, min(min(lum00, lum10), min(lum01, lum11)));
    float lumMax = max(lum, max(max(lum00, lum10), max(lum01, lum11)));

    float lumB = luma(B.rgb);

    return ((lumB < lumMin) || (lumB > lumMax)) ? A : B;
}

void main() {
    vec2 u = uvn;
    
    C=pow(max(FXAA(textures[tex_render], u),0.),vec4(.4545));

    C.w = 1.0;
}
