#include scene_sessions24/util.glsl

vec2 cube_main(vec2 UV, float t) {
    float i_t = floor(t);
    float f_t = fract(t);

    float cam_rot = t*1.0;

    vec2 lookat = vec2(cos(cam_rot), sin(cam_rot))*0.2;
    vec3 cam = vec3(4);
    vec3 ray = normalize(vec3(UV,-1));
    ray.yz *= rot(lookat.x-PI/4.0);
    ray.xz *= rot(lookat.y-PI/4.0);

    float dist = 99.;
    
    bvec3 snapped = bvec3(ray.x<ray.y && ray.x<ray.z,
                          ray.y<ray.x && ray.y<ray.z,
                          ray.z<ray.x && ray.z<ray.y);
    if(snapped.x) {
        dist = abs((cam+ray).x)/abs(ray.x);
    }
    else if(snapped.y) {
        dist = abs((cam+ray).y)/abs(ray.y);
    }
    else {
        dist = abs((cam+ray).z)/abs(ray.z);
    }

    vec3 po = ray*dist;
    vec2 p = vec2(0);
    if(snapped.x) {
        p = po.zy;
    }
    else if(snapped.y) {
        p = po.zx + 1.0;
    }
    else {
        p = po.xy + 2.0;
    }

    p = p-vec2(0.8,0.1)*(sin(t))*4.0;
    return max(po.x,max(po.y,po.z))<1.0?p:vec2(0);
}