﻿#version 430	/* version ディレクティブが必要な場合は必ず 1 行目に書くこと */
/* Copyright (C) 2020 Yosshin(@yosshin4004) */

/*
	サウンド出力サンプルコード。
*/

layout(location = 0) uniform int waveOutPosition;
#if defined(EXPORT_EXECUTABLE)
	/*
		shader minifier が compute シェーダに対応していない問題を回避するためのハック。
		以下の記述はシェーダコードとしては正しくないが、shader minifier に認識され
		minify が適用されたのち、work_around_begin: 以降のコードに置換される。
		%s は、shader minifier によるリネームが適用されたあとのシンボル名に
		置き換えらえる。

		buffer にはレイアウト名を付ける必要がある。ここでは、レイアウト名 = ssbo と
		している。レイアウト名は shader minifier が生成する他のシンボルと衝突しては
		いけないので、極端に短い名前を付けることは推奨されない。
	*/
	#pragma work_around_begin:layout(std430,binding=0)buffer ssbo{vec2 %s[];};layout(local_size_x=1)in;
	vec2 waveOutSamples[];
	#pragma work_around_end
#else
	layout(std430, binding = 0) buffer SoundOutput{ vec2 waveOutSamples[]; };
	layout(local_size_x = 1) in;
#endif


#define NUM_SAMPLES_PER_SEC 48000.
#define pi2 6.283185307179586

float siren_sound(float t)
{
//luma network
//Chunksds: 8, omega: 20, hidden_features: 32, hidden_layers: 1
vec4 f0_0 = sin((t * vec4(-14.12,-3.766,-5.301,4.837) + vec4(.5799,-16.86,-3.652,4.505)) * vec4(.9991,1.001,.9994,1.001));
vec4 f0_1 = sin((t * vec4(-8.837,5.475,-8.253,14.72) + vec4(16.81,13.12,11.29,-5.278)) * vec4(.9964,.9938,1.002,.9993));
vec4 f0_2 = sin((t * vec4(8.256,11.08,-7.266,-.6818) + vec4(18.06,-6.547,3.507,11.27)) * vec4(1.001,.9995,.9999,1.003));
vec4 f0_3 = sin((t * vec4(-14.98,-17.79,2.55,-3.467) + vec4(20.3,-19.02,-13.93,10.45)) * vec4(1.002,.9987,.9997,.999));
vec4 f0_4 = sin((t * vec4(-9.328,8.482,-2.925,.9277) + vec4(-5.179,-6.422,1.389,14.5)) * vec4(1.002,.9997,1.001,1.008));
vec4 f0_5 = sin((t * vec4(11.48,11.6,-11.41,-3.441) + vec4(15.61,18.23,15.67,10.33)) * vec4(1,.9996,1.001,.9986));
vec4 f0_6 = sin((t * vec4(12.89,14,-7.394,6.646) + vec4(1.645,15.21,-4.525,-15.47)) * vec4(.9989,.9989,.998,.9991));
vec4 f0_7 = sin((t * vec4(9.703,-6.723,19.32,-1.943) + vec4(5.014,-16.29,8.881,2.689)) * vec4(1.001,.9925,.9995,.9997));
vec4 f1_0 = sin(
    mat4(-.313,-.531,.194,.464,-.0347,-.0342,.133,.793,-.0514,.916,.00123,.127,-.31,.435,.45,.301) * f0_0 +
    mat4(.91,.0381,-.179,-.552,.00735,.687,.16,-.688,-.367,.0997,.0568,.586,-.621,-.231,-.00122,.112) * f0_1 +
    mat4(1.06,-.214,.0153,-.0283,-.251,.694,.538,-.186,-.0273,.176,.155,-1.67,.436,-.334,.951,.766) * f0_2 +
    mat4(-.575,.515,.158,-.42,-.28,-.266,-.356,-.213,-.681,.177,-.252,-.77,-.114,1.01,-.197,.485) * f0_3 +
    mat4(1.01,-.372,-1.08,.367,-.0773,-.151,-.45,-.611,-.606,1.1,.392,-.423,-.783,.397,.101,-.285) * f0_4 +
    mat4(-.232,.245,-.842,.135,-.561,-.839,.688,-.0597,-.836,-.299,-.274,.595,-.45,.445,.666,-.293) * f0_5 +
    mat4(-.0354,-.0479,.348,-.192,.132,-.0963,-.151,.272,.017,1.17,-.112,.661,.352,.481,-.847,-.094) * f0_6 +
    mat4(.506,-.365,-.272,-.311,.228,.355,-.0641,-.515,.401,-.27,.33,-.127,-.272,1,-.133,.448) * f0_7 +
    vec4(1.605,2.818,-3.265,-1.278) * vec4(1.062,1.051,1.025,1.03));
vec4 f1_1 = sin(
    mat4(-.348,-.74,-.502,.617,.423,.761,-.653,-.803,.402,-.24,-.46,.176,.357,-.516,-.833,-.0425) * f0_0 +
    mat4(-.179,-.182,-.559,-.768,-.46,.536,.0512,.0611,.792,.268,-.327,.516,-.914,-.194,.0177,.378) * f0_1 +
    mat4(-.199,.278,-.383,.204,.514,.446,.086,-.15,.464,-.951,-.402,-.0826,-.276,.0434,.846,-.105) * f0_2 +
    mat4(-.451,.569,.394,-.376,.201,.024,.128,-.362,.717,-.334,.316,.575,-.973,.59,-.906,.053) * f0_3 +
    mat4(-.355,-.156,.305,-.46,-.567,.205,-.427,-.198,-.375,.0389,-.701,-.0358,.209,-.818,-.24,1.09) * f0_4 +
    mat4(-.13,.104,-.12,-.113,-.285,-.322,.485,.0844,-.329,-.989,-.625,.25,.517,-1.07,-.756,.701) * f0_5 +
    mat4(.577,-.128,.269,.0563,.0932,-.396,.471,-.328,.44,-.377,.0752,-.568,.117,.148,-.242,1.13) * f0_6 +
    mat4(-.685,-.163,.599,-.426,.388,.8,-.166,-.779,-.067,.137,-.0757,.373,.165,.524,.592,.0463) * f0_7 +
    vec4(1.036,.9695,-1.305,1.234) * vec4(1.057,1.061,1.047,1.044));
vec4 f1_2 = sin(
    mat4(.0727,-.115,-.672,.274,-.0303,.988,-.0617,.986,.735,-.779,-.798,.0502,-.508,.119,.649,-.43) * f0_0 +
    mat4(-.331,-.141,.18,-.00265,.817,.0317,-.0101,1.04,.212,.0873,-.276,.681,.361,.526,-.302,.0891) * f0_1 +
    mat4(.187,-.0874,.0338,-.459,-.455,1.23,-.443,-.527,-.827,.194,.393,-1.08,.209,-.141,-.204,-.756) * f0_2 +
    mat4(.22,-.104,.418,-.126,-.277,-.229,-.576,.616,.692,.0485,-.291,1.26,-.235,-.324,.3,-.14) * f0_3 +
    mat4(-.236,-.187,-.75,-.541,.498,-.0424,-.345,.457,-.402,-.725,-.276,.84,-.792,-.0241,-.637,-.551) * f0_4 +
    mat4(-.478,.0124,.654,.188,.0521,-.111,-.455,-.409,-.188,-.26,-.0648,.0753,-.755,-.367,-.441,-.729) * f0_5 +
    mat4(-.489,.129,.387,.268,-.664,.261,.15,-.54,.0439,.536,.653,.309,-.5,.167,-.204,-.158) * f0_6 +
    mat4(.206,.256,.438,-.567,-.643,-.408,.631,.496,.517,.274,-.0982,-.0228,.15,.391,-.00292,-.585) * f0_7 +
    vec4(3.368,-.5298,3.53,-.4644) * vec4(1.031,1.052,1.046,1.057));
vec4 f1_3 = sin(
    mat4(-.0256,.489,-.573,-.425,-.176,-.703,-.136,.52,-.799,-.192,-.42,.439,-.521,.387,-.782,-.355) * f0_0 +
    mat4(-.0455,-.327,-.433,.0255,-1.43,-.239,-.761,.196,.0443,.801,-.162,-.71,.433,.0444,.383,.738) * f0_1 +
    mat4(.352,-.898,.523,.153,.59,-.291,-.0465,.0356,.555,.746,.63,-.396,.224,.355,.477,-1.22) * f0_2 +
    mat4(.298,-.395,.444,-.634,-.151,.0463,-.249,-.103,-1.23,.136,-1.23,.199,.248,-.233,.688,.21) * f0_3 +
    mat4(-.437,.967,.444,-.00481,.0688,-.6,-.215,-.161,-.0545,-.131,-.709,1.12,.226,-.151,-.158,.0157) * f0_4 +
    mat4(.252,-.574,.449,.483,.0575,.784,-.823,-.183,-.268,.0431,.169,.199,.932,1.13,.321,-.169) * f0_5 +
    mat4(-.463,-.453,.334,1.03,.333,-.306,-.0136,-.386,.684,.339,.622,.107,-.154,.468,-.718,.56) * f0_6 +
    mat4(.0381,-.653,.627,.624,.525,-.682,.349,-.197,-.133,-.266,-.236,-.498,-.389,.305,.948,-.381) * f0_7 +
    vec4(-1.804,.2904,2.326,.5466) * vec4(1.034,1.033,1.037,1.056));
vec4 f1_4 = sin(
    mat4(.23,-.663,.75,-.437,.95,.708,.243,-.187,-.349,-.175,-.631,-.229,1.08,.694,.274,.237) * f0_0 +
    mat4(.21,-.288,.503,-.108,.0243,-.425,.402,-.329,.00772,-.0928,-1.02,-.0399,-.164,.899,-.915,.102) * f0_1 +
    mat4(-.382,.302,.29,.821,.0748,-.141,.358,-.135,-.121,-.275,.785,.393,.715,.55,.715,-.854) * f0_2 +
    mat4(-.2,.0742,-.598,-.13,-.13,-.00633,.0941,.0754,.213,.0849,.282,-.952,.289,.444,-.00158,.052) * f0_3 +
    mat4(.709,.411,-.036,-.273,-.386,.117,.0445,.649,-.132,.138,.115,-.124,-.0804,.32,-.466,-.933) * f0_4 +
    mat4(-.512,.272,-.18,-.578,-.033,.381,-.473,.273,-.36,.146,-.423,.689,-.288,-.402,-.104,-.611) * f0_5 +
    mat4(-.457,.405,-.217,.192,.223,.328,.169,-.414,.347,-.48,-.0116,.591,-.282,-.622,-.164,-.18) * f0_6 +
    mat4(.0328,-.428,-.518,-.415,.0553,.611,-.309,.671,.179,-.214,.0492,-.248,.681,-.378,-1.23,.438) * f0_7 +
    vec4(1.781,2.115,-1.478,.6328) * vec4(1.034,1.036,1.049,1.037));
vec4 f1_5 = sin(
    mat4(.423,.602,-.11,.49,.406,-1.13,-.315,-.751,-.404,-.324,.124,-.00757,.794,.486,-.519,.271) * f0_0 +
    mat4(.532,.0244,-.0578,.11,-.444,.257,-.0301,.0238,.612,.903,.997,.278,.368,-.269,-.0805,.749) * f0_1 +
    mat4(-.592,-.454,-.359,.399,.884,.323,.819,-.728,1.07,.0962,.874,.497,-.0587,-.957,-.23,1.07) * f0_2 +
    mat4(-.0747,.0917,-.0973,.734,.109,.474,-.131,-.437,.571,-.908,-.255,.0668,-.181,.226,.4,.452) * f0_3 +
    mat4(-.268,.0106,-.0146,-.283,.494,.271,.357,-1.1,-.853,-1.3,-.0567,.454,1.08,.0617,.068,.787) * f0_4 +
    mat4(.222,.323,.0191,.0606,.0518,.367,-.658,-.969,-.405,.0529,-.145,-.403,.543,-.147,.522,.374) * f0_5 +
    mat4(.333,-.573,-.0667,.148,-.426,-.219,-.213,.11,.22,-.967,-.502,-.217,.709,.00878,-.956,-.701) * f0_6 +
    mat4(-.325,-.00288,.195,-.347,.302,-.281,.29,-.619,-.257,.0655,.0153,-.0805,-.00793,-1.41,.0995,.176) * f0_7 +
    vec4(-3.137,.3591,-.7798,-2.865) * vec4(1.058,1.102,1.022,1.062));
vec4 f1_6 = sin(
    mat4(-.154,-.482,-.233,.507,-.146,.112,.44,-.529,.409,-.221,-.0221,.976,-.694,.479,-.399,-1.02) * f0_0 +
    mat4(-1.04,.582,-.0929,-.116,.0119,.612,-.504,.222,-.866,-.0771,.585,-.43,-.224,-.61,-.079,-.149) * f0_1 +
    mat4(.441,-.173,.354,-.268,.723,-1.23,1.02,.304,.639,-.55,.0149,-1,.331,-1.36,-.776,-.0916) * f0_2 +
    mat4(.081,-.186,-.246,-.358,.429,.109,.57,-.354,.732,.723,-.168,-.334,-.0814,-1.1,-.676,.702) * f0_3 +
    mat4(-.449,.496,-.563,-.4,.0472,.605,.0687,.688,-.685,-.18,.784,-.107,-.572,.505,-.0266,-1.37) * f0_4 +
    mat4(.822,-.67,.121,.673,-.266,.186,.46,-.5,.0686,-.107,-.584,-.0296,-.178,-.787,-.583,-.281) * f0_5 +
    mat4(-.126,-.609,-.38,1.24,.586,-.129,.204,-.24,-.301,-.373,.0468,-.453,.402,-.114,-.758,.651) * f0_6 +
    mat4(-.158,-.213,.226,.648,.135,.638,.0941,-.898,.261,.0984,-.167,.151,-.225,.4,-.0108,-.334) * f0_7 +
    vec4(2.309,-2.226,-2.151,2.655) * vec4(1.027,1.04,.9752,1.041));
vec4 f1_7 = sin(
    mat4(.301,.192,-.287,.01,.131,.213,.135,.285,-.743,-.639,-.262,.671,-.108,-.0124,-.447,.157) * f0_0 +
    mat4(.235,.484,-.887,.396,-.515,-.164,-.303,-.766,-.478,.847,-.0964,-.391,.137,.176,.316,-.147) * f0_1 +
    mat4(-.0311,-.712,.554,.304,.283,.0649,.0243,-.48,.308,-.812,.458,.66,.346,1.23,-.767,-.425) * f0_2 +
    mat4(-.336,.411,-.422,.3,.33,.216,-.502,-.121,.703,-.735,.657,-.53,-.523,.0937,-.238,-1.15) * f0_3 +
    mat4(.135,-.763,-.251,.384,-.0535,-.505,.00861,-.118,-.696,.366,-.114,-1.14,.489,.336,-.808,.419) * f0_4 +
    mat4(-.373,.923,.924,.599,-.213,-.892,-.759,.229,.00631,-.165,-.428,.0131,-.331,-.567,.589,.477) * f0_5 +
    mat4(-.198,.672,-.309,.273,.171,1.16,.119,-.098,.195,-.0559,.56,-.0681,.162,.287,.888,-.547) * f0_6 +
    mat4(.942,-.363,.0517,.152,.0488,-.0328,-.562,.525,.488,.424,-.0362,-.543,-.0257,.252,.336,-.493) * f0_7 +
    vec4(3.061,2.186,-1.987,1.04) * vec4(1.026,1.043,1.008,1.086));
float f = dot(f1_0, vec4(.05823,-.05623,-.05379,.05906)) +
    dot(f1_1, vec4(-.05752,-.06477,-.05063,-.0515)) +
    dot(f1_2, vec4(.05146,-.06738,-.06208,.05529)) +
    dot(f1_3, vec4(-.05023,.0615,-.0564,.05882)) +
    dot(f1_4, vec4(-.06418,-.05931,.05232,.0626)) +
    dot(f1_5, vec4(.05611,.05194,.07032,-.05161)) +
    dot(f1_6, vec4(-.05192,-.0558,-.05503,.04773)) +
    dot(f1_7, vec4(-.06908,.05374,-.05441,.06388)) +
    0.01199511531740427;
    return f;
}

float additiveWave(float amp, float baseFreq, float t) {
    float st = mod(t * baseFreq, 200.0) - 100.0;
    return (siren_sound(st) / 1.07) * amp;
}

vec2 dist(vec2 s, float d) {
    return clamp(s * d, -1., 1.);
}

float quan(float s, float c) {
    return floor(s / c) * c;
}

float nse(float x) {
    return fract(sin(x * 110.082) * 19871.8972);
}

float kick(float tb, float t) {
    tb = sqrt(fract(tb / t) * .3 * 5.) / 5.;
    float amp = exp(max(tb - .15, 0.) * -10.);
    float v = sin(tb * 100. * pi2) * amp;
    v = clamp(v * 4., -1., 1.) * amp;
    v += nse(quan(tb, .001)) * nse(quan(tb, .00001)) * exp(tb * -20.) * 2.5;
    return v;
}

float hat(float tb) {
    tb = fract(tb / 4.) * .5;
    return nse(sin(tb * 4e3) * .0001) * smoothstep(0., .01, tb - .25) * exp(tb * -5.);
}

vec2 mainSound(float time) {
    float tf2 = step(42.0, time);
    float factor = exp(-0.08 * (time - 40.0) * tf2);
    float time2 = time * factor;

    float tb = mod(time2 * 8., 16.), ki = smoothstep(.01, 0., abs(mod(time2 * 4., 256.) - 32. - 64.) - 64.);
    vec2 mx = vec2(hat(tb) * 1.5);
    float sc = sin(pi2 * tb) * .4 + .6, k = kick(tb, 8.) * .3 * sc * ki;
    k -= kick(tb, 4.0) * .3 * sc;
    mx += vec2(k);

    float voice = smoothstep(.01, .0, abs(mod(time2, 32.0) - 32.0) - 16.0);
    float fv = smoothstep(.0, .01, abs(mod(time2, 1.0) - 1.0) - 0.5);

    float timeFactor = step(24.0, time2);
    float mix1 = mix(mod(time2, 0.5 + 0.5 * voice) + 0.5 * voice, mod(time2, 1.0), timeFactor);
    float mix2 = mix(fv, 1.0, timeFactor);

    mx += additiveWave(1.0, 200.0, mix1) * mix2 * ki;
    return dist(mx, 1.);
}

void main(){
	int offset = int(gl_GlobalInvocationID.x) + waveOutPosition;
	float sec = float(offset) / NUM_SAMPLES_PER_SEC;
	//waveOutSamples[offset] = sin(vec2(sec * 440 * 6.2831)) * exp(-sec);
	waveOutSamples[offset] = mainSound(sec);
}

