-- adapted from https://github.com/Yonaba/delaunay
-- vurpo

m=math

f=0

function circumcircle(t)
 t0=t.a
 t1=t.b
 t2=t.c
 D=((t0.x-t2.x)*(t1.y-t2.y)-(t1.x-t2.x)*(t0.y-t2.y))
 x=(((t0.x-t2.x)*(t0.x+t2.x)+(t0.y-t2.y)*(t0.y+t2.y))/2*(t1.y-t2.y)-((t1.x-t2.x)*(t1.x+t2.x)+(t1.y-t2.y)*(t1.y+t2.y))/2*(t0.y-t2.y))/D
 y=(((t1.x-t2.x)*(t1.x+t2.x)+(t1.y-t2.y)*(t1.y+t2.y))/2*(t0.x-t2.x)-((t0.x-t2.x)*(t0.x+t2.x)+(t0.y-t2.y)*(t0.y+t2.y))/2*(t1.x-t2.x))/D
 radius=m.pow(t2.x-x,2)+m.pow(t2.y-y,2)
 return {x=x,y=y,radius2=radius}
end

function incircle(p,c)
  d=m.pow(p.x-c.x,2)+m.pow(p.y-c.y,2)
  return d<c.radius2
end

-- point equals
function peq(p1,p2)
 return p1.x==p2.x and p1.y==p2.y
end

-- edge equals
function eeq(e1,e2)
 return (peq(e1.a,e2.a) and peq(e1.b,e2.b))or(peq(e1.a,e2.b) and peq(e1.b,e2.a))
end

function triangulate(points)
  local vertices = points
  local nvertices = #vertices
  --assert(nvertices > 2, "Cannot triangulate, needs more than 3 vertices")
  if nvertices == 3 then
    return {a=vertices[1],b=vertices[2],c=vertices[3]}
  end

  local trmax = nvertices * 4

  local minX, minY = vertices[1].x, vertices[1].y
  local maxX, maxY = minX, minY

  for i = 1, #vertices do
    local vertex = vertices[i]
    vertex.id = i
    if vertex.x < minX then minX = vertex.x end
    if vertex.y < minY then minY = vertex.y end
    if vertex.x > maxX then maxX = vertex.x end
    if vertex.y > maxY then maxY = vertex.y end
  end

	local convex_mult = 1000
  local dx, dy = (maxX - minX) * convex_mult, (maxY - minY) * convex_mult
  local deltaMax = m.max(dx, dy)
  local midx, midy = (minX + maxX) * 0.5, (minY + maxY) * 0.5

  local p1 = {x=midx - 2 * deltaMax, y=midy - deltaMax}
  local p2 = {x=midx, y=midy + 2 * deltaMax}
  local p3 = {x=midx + 2 * deltaMax, y=midy - deltaMax}
  p1.id, p2.id, p3.id = nvertices + 1, nvertices + 2, nvertices + 3
  vertices[p1.id] = p1
  vertices[p2.id] = p2
  vertices[p3.id] = p3

  local triangles = {}
  triangles[#triangles + 1] = {a=vertices[nvertices + 1],
                               b=vertices[nvertices + 2],
                               c=vertices[nvertices + 3]}

  for i = 1, nvertices do
  
    local edges = {}
    local ntriangles = #triangles

    for j = #triangles, 1, -1 do
      local curTriangle = triangles[j]
      cc = circumcircle(curTriangle)
      if incircle(vertices[i],cc) then
        edges[#edges + 1] = {a=curTriangle.a,b=curTriangle.b}
        edges[#edges + 1] = {a=curTriangle.b,b=curTriangle.c}
        edges[#edges + 1] = {a=curTriangle.c,b=curTriangle.a}
        table.remove(triangles, j)
      end
    end

    for j = #edges - 1, 1, -1 do
      for k = #edges, j + 1, -1 do
        if edges[j] and edges[k] and eeq(edges[j],edges[k]) then
          table.remove(edges, j)
          table.remove(edges, k-1)
        end
      end
    end

    for j = 1, #edges do
      local n = #triangles
      --assert(n <= trmax, "Generated more than needed triangles")
      triangles[n + 1] = {a=edges[j].a, b=edges[j].b, c=vertices[i]}
    end
   
  end

  for i = #triangles, 1, -1 do
    local triangle = triangles[i]
    if (triangle.a.id > nvertices or 
        triangle.b.id > nvertices or 
        triangle.c.id > nvertices) then
      table.remove(triangles, i)
    end
  end

  for _ = 1,3 do table.remove(vertices) end

  return triangles

end

-- sort points
function sortfunc(p1,p2)
 if p1.x == p2.x then return p1.y < p2.y
 else return p1.x < p2.x end
end

function clamp(f,min,max)
 return m.max(m.min(f,max),min)
end

function h2r(h)
 r = clamp(3*m.abs(((h)/180)%2-1)-1,0,1)
 g = clamp(3*m.abs(((h-120)/180)%2-1)-1,0,1)
 b = clamp(3*m.abs(((h+120)/180)%2-1)-1,0,1)
 return r, g, b
end

function TIC()
 f=0
 fn=15
 for i=0,fn do
  f=f+fft(i)
 end
 f=f/(fn*0.6)
 t=time()/700 + 45 + f*2
 t2=time()
 
	vbank(1)
	poke(0x3ffb,0)
	for y=0,15 do
  pix(0,y,y)
	end
	
	vbank(0)
	poke(0x3ffb,0)
 for i=0,14 do
  f2=clamp(f*3-0.2,0,0.5)
  r,g,b=h2r(i*2.5+t2/30)
  
  r=0.5-f2+r*(0.3+0.8*f2)
  g=0.5-f2+g*(0.3+0.8*f2)
  b=0.5-f2+b*(0.3+0.8*f2)
  trace(f)
  poke(16320+i*3,r*255)
  poke(16321+i*3,g*255)
  poke(16322+i*3,b*255)
 end
 
 cls(16)
 
 points={ }
 for x=0,7 do for y=0,5 do
  x1=(x*50 + 12*m.sin(y)*t*(y%2*2-1) + 17*m.sin(y)*m.sin(t))%350 -40-- + y*5+10*m.sin(y/1+t),
  y1=(y*50 + 12*m.sin(x)*t*(x%2*2-1) + 17*m.sin(x)*m.sin(t))%250 -40-- + 30*m.cos(1.5*(x+y)) + 7*m.sin(x+t)

  table.insert(points,{x=x1,y=y1})
 end end
 for i,p in pairs(points) do
  points[i] = {x=m.floor(p.x),y=m.floor(p.y)}
 end
 table.sort(points,sortfunc)
 triangles = triangulate(points)
	
	poke(16365,255)
	poke(16366,255)
	poke(16367,255)
	for _,t in pairs(triangles) do
	 ymin = m.min(t.a.y,t.b.y,t.c.y)
		ymax = m.max(t.a.y,t.b.y,t.c.y)
		h = ymax-ymin
		y1 = (t.a.y-ymin)/(h/15)
		y2 = (t.b.y-ymin)/(h/15)
		y3 = (t.c.y-ymin)/(h/15)
	 ttri(
		 t.a.x,t.a.y,
			t.b.x,t.b.y,
			t.c.x,t.c.y,
	 	0,y1,
			0,y2,
			0,y3,
			2,-1)
	 trib(
		 t.a.x,t.a.y,
			t.b.x,t.b.y,
			t.c.x,t.c.y,
	 	15)
		namex = m.max(0,f-0.15)*m.cos(time()/17)+200
		namey = m.max(0,f-0.15)*m.sin(time()/11)+121
		for x=-1,1 do for y=-1,1 do
			print("vurpo",namex+x,namey+y,1)
		end end
		print("vurpo",namex,namey,15)
	end
	
	vbank(1)
	cls()
end