-- cubes (pearl and dean)
-- jtruk
-- For CoLD SToRAGE gig
-- at Mountain Bytes 24

local T=0
local TRAND=0

local M=math
local S,C,PI=M.sin,M.cos,M.pi
local TAU,ATAN,RAND=PI*2,M.atan2,M.random

local CAM_Z=-1
local getLayout=nil
local LINE_DIR=1

-- IONIC 6x6
FONTDATA="28E08beA15DADADA2DA6LBLBLBA9KAPBKAPBKA6PAEBOAFAOBA5LALAEAKBKBA5OALBOAHANAOBA3DADADA10PADADADAPA6PAMAMAMAPA6EAOAPBOAEA8GAPAPAGA10GAHADA10PBPBA11HAHAHA6MBMBOAHAHA6PBHBHBHBPBA5PAOAOAOAPBA5OBMBPBBAPBA5OBMBOBMBPBA5NBNBPBMBMBA5PABAPBMBPBA5PAHAPBHBPBA5PBMBOAOAOA6OBGBPBHBPBA5PBNBPBMBOBA5HAHA2HAHA6GA2GAHADA6EAGAPBGAEA8PBAAPBA7EAMAPBMAEA6PAIAOA2GA6OBBCNBBAOBA5PBHBPBHBHBA5PBHBPAHBPBA5PBHBHAHBPBA5PANBNBNBPBA5PBHAPAHAPBA5PBHAPAHAHA6PBHAHBHBPBA5HBHBPBHBHBA5HAHAHAHAHA6OAOAOAOAPA6HDHBPBHDHDA5HAHAHAHAPBA5PBFBFBFB2A5PBLBLBLBLBA5PBNBNBNBPBA5PBHBPBHAHA6PALALALAPBA5PBHBPAHBHBA5PAHAPBABPBA5PBOAOAOAOA6HBHBHBHBPBA5HBHBHBPAHA6BBFBFBFBPBA5HDHDOBHDHDA5NBNBPBMBPBA5PBMBOAHAPBA5PADADADAPA6HAHAOAMBMBA5PAMAMAMAPA6OABBOALBOA14HA6DADACA10OBIBPBNBPBA5HAPBHBHBPBA7PBHAHAPBA5MBPBNBNBPBA5PBHBPBHAPA6OBOAPBOAOA8PBNBPBMBOBA3HAPBHBHBHBA5HA2HAHAHA6OA2OAOAOAPA4HAHDPBHDHDA5PAOAOAOAOBA7PBFBFB2A7PBLBLBLBA7PBNBNBPBA7PBHBPBHAHA6PBNBPBMBMBA5PBHBHAHA8PAHAIBPBA5OAPBOAOAOA8HBHBHBPBA7HBHBPAHA8BBFBFBPBA7HDHDOBHDA7NBNBPBMBOBA5PBIBGAPBA5OACADACAOA6DADADADADA6HAEAMAEAHA6GCJBA11"

-- cube
PS={
 {x=-1,y=-1,z=1},
 {x=1,y=-1,z=1},
 {x=1,y=1,z=1},
 {x=-1,y=1,z=1},
 {x=-1,y=-1,z=-1},
 {x=1,y=-1,z=-1},
 {x=1,y=1,z=-1},
 {x=-1,y=1,z=-1},
}

FACES={
	{1,2,3,4},
	{6,5,8,7},
	{2,6,7,3},
	{5,1,4,8},
	{5,6,2,1},
	{4,3,7,8},
}

function getLayoutCS(t)
	local cs={}
	for i=0,15 do
		cs[i]={
			pos=nil,	-- default: offscreen
			rot=nil,
		}
	end
	
	cs[2].pos={x=-6,y=-2,z=0}
	cs[3].pos={x=-3,y=-2,z=0}
	cs[4].pos={x=-0,y=-2,z=0}
	cs[5].pos={x=3,y=-2,z=0}

	cs[7].pos={x=-9,y=2,z=0}
	cs[8].pos={x=-6,y=2,z=0}
	cs[9].pos={x=-3,y=2,z=0}
	cs[10].pos={x=0,y=2,z=0}
	cs[11].pos={x=3,y=2,z=0}
	cs[12].pos={x=6,y=2,z=0}
	cs[13].pos={x=9,y=2,z=0}

	for i,c in ipairs(cs) do
		if c.pos then
		 c.pos.y=c.pos.y+S(t*.03+i)*1
			c.pos.z=-2+S(c.pos.x/2+c.pos.y/2+t*.02)*8
			c.rot={
				x=0,
				y=t*.017,
				z=S(i*.2+t*.02)*.3
			}
		end
	end
	
 return {
 	text="  CoLD SToRAGE  ",
 	cubes=cs
 }
end

function getLayoutMB(t)
	local cs={}
 local text=" Mountain Bytes "
	for i=0,15 do
	 local iL=i+1
		local pos=nil
		local rot=nil
	 if text:sub(iL,iL)~=" " then
			local a=i/60*TAU-t*.005

		 pos={
				x=-C(a*2.5)*10,
				y=-S(a*5)*5,
				z=S(a*8)*25
			}

		 rot={
				x=S(t*.01+i*.4)*.3,
				y=t*.017,
				z=t*.03
			}
		end
		cs[i]={pos=pos,rot=rot}
	end

 return {text=text,cubes=cs}
end

function BOOT()
	fontToMem(FONTDATA)
end

function SCN(y)
	vbank(0)
	setRGB0(1,0,0,0)
	local r0,g0,b0=peek(16323),peek(16324),peek(16325)
	for i=2,14 do
	 local m=(i-1)/13
		local im=1-m
		local r=(im*r0)+(127+S(-T*.004-y*.01)*127)*m
		local g=(im*g0)+(127+S(T*.005-y*.008)*127)*m
		local b=(im*b0)+(127+S(T*.003+y*.012)*127)*m
 	setRGB0(i,r,g,b)
	end

 vbank(1)	
	for i=1,14 do
		local r=127+S(i*.5+y*.02+T*.05)*64
		local g=20
		local b=127+S(i*.4+y*.05+T*.07)*64
 	setRGB1(i,r,g,b)
	end
end

function makeRGBfn()
	t=randomiseTable({"a","a+1","a+2"})

	local v1=RAND()<.5 and "r" or "64+r/2"
	local v2=RAND()<.5 and "g" or "64+g/2"
	local v3=RAND()<.5 and "b" or "64+b/2"
	fn="local a=16320+i*3"
	fn=fn.."poke("..t[1]..","..v1..")"
	fn=fn.."poke("..t[2]..","..v2..")"
	fn=fn.."poke("..t[3]..","..v3..")"

	return load("i,r,g,b=...;" .. fn)
end

function randomiseTable(t)
	local newT={}
	repeat
		local iPos=RAND(1,#t)
		table.insert(newT,t[iPos])
		table.remove(t,iPos)
	until(#t==0)
	return newT
end

function setRealRGB(c,r,g,b)
	local a=16320+c*3
	poke(a,r)
	poke(a+1,g)
	poke(a+2,b)
end

function randomise()
	TRAND=RAND(0,100000)
 if RAND(0,1)==0 then
		getLayout=getLayoutCS
	else
		getLayout=getLayoutMB
	end

	LINE_DIR=.25+RAND()
	if RAND()<.5 then
	 LINE_DIR=-LINE_DIR
	end

	setRGB0=makeRGBfn()
	setRGB1=makeRGBfn()
	vbank(0)
	setRealRGB(0,0,0,0)
	setRealRGB(15,255,255,255)
 vbank(1)	
	setRealRGB(15,255,255,255)
end

randomise()

function TIC() 	
	T=time()/12
	poke(0x3FFB,0)
	vbank(0)

	-- Textures...	
	local layout=getLayout(T+TRAND)
	text=layout.text
	for i=0,15 do
 	local x,y=i%4,i//4
		local x0,y0=x*32,y*32
	 for x=0,31 do
	 	for y=0,31 do
				local c=(x+y+T*S(i))//1>>3
				pix(x0+x,y0+y,1+c%14)
			end
		end
		
	 local c=i*5
	 local lSz=4
		local l=text:sub(i+1,i+1)
	 local w=print(l,0,140,0,false,lSz)
		local xp,yp=x*32+18-w/2,y*32+6
	 print(l,xp-1,yp-1,2+(c-3)%13,false,lSz)
	 print(l,xp+1,yp+1,2+(c+3)%13,false,lSz)
	 print(l,xp,yp,15,false,lSz)
	end
	
	vbank(1)	
 cls(0)

	CAM_Z=2

	for iC,c in ipairs(layout.cubes) do 
	 if c.pos~=nil then		
			local tps={}
		 for iP,p in ipairs(PS) do
				p=rotZ(rotY(rotX(p,c.rot.x),c.rot.y),c.rot.z)
				p=add(p,c.pos.x,c.pos.y,c.pos.z)
				tps[iP]=proj(p)
			end
		
		 for _,f in ipairs(FACES) do
				drawTri(tps[f[1]],tps[f[2]],tps[f[3]],false,iC)
				drawTri(tps[f[3]],tps[f[4]],tps[f[1]],true,iC)
			end
		end
	end
		
	-- BG: pearl and dean it, m8
	vbank(0)
	cls()
	local spin=S(T*.02)+C(T*.013)
	for i=0,100 do
	 local seed=(i^5+T*4)
	 local d=20+S(i)*10
		local pow=S(i+T*.01)*10
		local a=(spin/2+(i^3+pow)/80*TAU)
		local z0=(LINE_DIR*seed*.7)%200-180
		local z1=z0+15
		local x,y=C(a)*d,S(a)*d
		local dx,dy=y/30,x/30
		local dxb,dyb=y/50,x/50
		local	p00={x=x+dxb,y=y-dyb,z=z0}
		local	p00=proj(p00)
		local	p01={x=x-dxb,y=y+dyb,z=z0}
		local	p01=proj(p01)
		local	p10={x=x+dx,y=y-dy,z=z1}
		local	p10=proj(p10)
		local	p11={x=x-dx,y=y+dy,z=z1}
		local	p11=proj(p11)
		local c=15-p00.z*1.4
		tri(p00.x,p00.y,p01.x,p01.y,p10.x,p10.y,c)
		tri(p01.x,p01.y,p11.x,p11.y,p10.x,p10.y,c)
	end

	print("jtruk",200,124,12)
end

function proj(p)
	local zF=CAM_Z-p.z*.05
	local sc=20
 return {
  x=120+sc*p.x/zF,
  y=68+sc*p.y/zF,
  z=zF,
 }
end

function add(p,x,y,z)
	return {
	 x=p.x+x,
		y=p.y+y,
		z=p.z+z,
	}
end

function rotX(p,a)
	return {
	 x=p.x,
		y=p.y*C(a)-p.z*S(a),
		z=p.y*S(a)+p.z*C(a),
	}
end

function rotY(p,a)
	return {
		x=p.x*C(a)-p.z*S(a),
	 y=p.y,
		z=p.x*S(a)+p.z*C(a),
	}
end

function rotZ(p,a)
	return {
		x=p.x*C(a)-p.y*S(a),
		y=p.x*S(a)+p.y*C(a),
	 z=p.z,
	}
end

-- page = 32x32
function drawTri(p1,p2,p3,flip,iPage)
	xPage,yPage=iPage%4,iPage//4
	
	pxL=xPage*32
	pxH=xPage*32+31
	pyL=yPage*32
	pyH=yPage*32+31
	if flip==false then 
		t1x,t1y,t2x,t2y,t3x,t3y=pxL,pyL,pxH,pyL,pxH,pyH
	else
		t1x,t1y,t2x,t2y,t3x,t3y=pxH,pyH,pxL,pyH,pxL,pyL
	end

	ttri(
		p1.x,p1.y,
		p2.x,p2.y,
		p3.x,p3.y,
		t1x,t1y,t2x,t2y,t3x,t3y,
		2,
		-1,
		p1.z,p2.z,p3.z
	)
end

function fontToMem(str)
  local o=tonumber(str:sub(1,5),16) -- get (o)ffset
  local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
  local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
  local d = "" -- (d)ecoded data
  for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
    d = d .. m .. (m:sub(-1):rep(c))  
  end
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end