; --------------------------------
;  Roberts: All you need is eight.
;  A real-time julia set animation
; --------------------------------

; Madram 18 Feb 2023            

; TODO: try with 16 bits.

; v4: Compute symetry (HL) from DE  (&80 exactement)
; v3: Fix bug  &87
; v2: Use symetry. SPACE to exit
; v1: Fix /gen_square/, still bugged though.
; v0: Bugged, as squares table assume 0 is centered at &80.

dev   = 1

r1    = 40
wid   = 32
hei   = 32
squares = &8000
screen = &C000 + 24 + r1*10
screen_end = screen + [hei-1]/2*r1*2 + [[hei-1] AND 1]*&2000 + wid-1

      IF hei AND 3
 !! we expect multiple of 4 for easier 'bc26' symmetry 
      END

      ORG &1000
      ENT start

      IF dev
      IMPORT "testkey.o"
      END


start
      IF dev
          ld a,2:call &BC0E ; mode 2
      END

; Disable firmware to gain CPU time and regs' (exx).
          di
; ---- Generate square with clipping. -----
; Not perfectly symmetric, nevermind.

          ld de,4
          ld bc,8
          ld h,b
          ld l,b
          exx
          ld hl,squares
          ld de,squares+&FF
gen_square
          exx

          ld a,h
          add hl,de
          ex de,hl
          add hl,bc
          ex de,hl

          exx
      IF squares/&0100 - &80
  !! must adapt code
      END
          cp h
          jr c,.ok
          ld a,h        ; saturate at 1.99
.ok
          ld (de),a:dec e
          ld (hl),a
          inc l
          jp p,gen_square

          ld ix,&F0F0

          exx           ; Keep HL pointing to square
frame_lp
          ld iyh,&A8    ; y0
          ld de,screen
          ld bc,hei/2 * &0100 + &80
y_lp
          ld hl,screen_end + screen AND &FFFF
          sbc hl,de
          push bc
          ld b,wid
x_lp
          ld a,c:add 8:ld c,a ; Reload (new) X
          exx
          ld d,iyh      ; Reload Y
          ld e,0        ; Color
one_iter
; Here A = x
     ; D = y
     ; E = color
     ; H = squares.h
     ; ixl = cx
     ; ixh = cy

          ld l,a:ld c,(hl) ; c = x^2
          ld l,d:ld b,(hl) ; b = y^2
          add d:ld l,a  ; l = x+y
; We add squares, so the result is meant to be positive.
; Negative -> overflow -> the sum is greater than 2
; For proper Julia, the threshold is 4, but that wouldn't be convenient.
; By the way, you should listen to "Critical Mass" album.
          ld a,b:add c:jp m,exit

; Still iterating: we increment "color"
          sl1 e:jp m,exit ; Exit if max color

test_size = $ - one_iter

; Compute y', x' for next iter
          ld c,a        ; c = x^2 + y^2
          ld a,(hl)     ; a = (x+y)^2
          sub c         ; a = 2*x*y
          add ixh:ld d,a ; d = y'      

          ld a,c:sub b:sub b:add ixl ; a = x' = x^2 - y^2 + cx

iter_size = $ - one_iter
          jr one_iter

exit
          ld a,e
          exx
          ld (de),a:inc de
          ld (hl),a:dec hl
          djnz x_lp

          ld hl,&2000 - wid
.retry
          add hl,de
          ld de,&C000 + r1*2
          jr c,.retry

          ex de,hl
          ld a,iyh:add 6:ld iyh,a
          pop bc
          djnz y_lp

          inc iyh
          inc ixl

      IF dev
          ld a,&45:call testkey:rla:ret nc
      END

          jr frame_lp

