; /////// Twisted  Mind \\\\\\\
;   \\\\\ Lovebyte 2024 /////

dev   = 0

; v3: Remove lisajou Y. Add sound!
; v2: Double color cycling. Disable lisajou Y
; v1: Lissajou Y. Chaos!
; v0: POC. Cycling too fast. Boucle too fast.

      ORG &010E
      ENT start

scr_set_ink = &BC32
gra_set_pen = &BBDE     ; A = pen
gra_move_absolute = &BBC0 ; DE = X  HL = Y   BC, DE, HL corrupt
gra_plot_absolute = &BBEA ; DE = X  HL = Y   BC, DE, HL corrupt
gra_line_absolute = &BBF6
gra_set_line_mask = &BD4C

      MACRO GEN_SINIT table,mid,amp
;-To copy paste in host.
;Then call gen_sin.

; Table: destination
; Mid: midpoint in y. 128 for maximum possible amplitude  
; Amp: amplitude

      IF amp AND 1
   !! should be even (otherwise there is a little discontinuity)
      END
          ld h,128
          ld de,amp*&3F + amp/2:ld bc,-amp
          ld ix,table+&80
      ENDM

      MACRO GEN_LOOP
.lp
          ld a,h
          cpl
          ld (ix+0),a
          ld (ix-&80),h
          add hl,de
          ex de,hl
          add hl,bc
          ex de,hl
          inc ixl
          jr nz,.lp
      ENDM


start
          xor a:call &BC0E
          ld a,&55:call gra_set_line_mask

          GEN_SINIT(sin,128,14)
          GEN_LOOP()

          di
          ld hl,psg+13
.psglp
          ld b,&F4:out (c),l
          ld bc,&F6C0:out (c),c:out (c),0
          dec b
          ld a,(hl)
          outd
          ld bc,&F680:out (c),c:out (c),0
          dec a
          jr nz,.psglp



          ld a,1
rotlp
          push af
          call gra_set_pen
;color-cycling 
          ld de,palette0
.colcycl  ld hl,palette0
          call next_col
          ld (.colcycl+1),hl
          ld a,1
          call set_pal


pntx1     ld hl,sin
          ld a,l:add 7:ld (pntx1+1),a
          push hl

          call get_x
          ex de,hl
          call gra_move_absolute

          pop hl
          ld a,l:add 80:ld l,a
          call get_x
          ex de,hl
          ld hl,0
          call gra_line_absolute

pen2      ld a,9
          inc a:cp 16:jr c,$+4:ld a,9
          ld (pen2+1),a
          call gra_set_pen

          ld de,palette1
.colcycl2 ld hl,palette1
          call next_col
          ld (.colcycl2+1),hl
          ld a,9
          call set_pal

pntx2     ld hl,sin
          ld a,l:add 7:ld (pntx2+1),a
          call get_x
          add hl,hl
          ex de,hl
          ld hl,400
          call gra_line_absolute

          pop af
          inc a:and 7:jr nz,$+3:inc a

      IF dev
          push af
          call &BB09
          jr nc,.ok
          pop af
          ret
.ok
          pop af
      END
          jp rotlp


get_x
          ld l,(hl)
          ld h,0
          add hl,hl
          ret

set_pal
          push af
          call next_col
          ld c,a:ld b,a
          pop af
          push hl
          push de
          push af
          call scr_set_ink
          pop af
          pop de
          pop hl
          inc a
          ld c,a
          and 7
          ld a,c
          jr nz,set_pal
          ret


next_col
          inc hl
          ld a,(hl)
          or a
          ret nz
          ex de,hl
          ld a,(hl)
          ret

palette0 BYTE 1,1,1,4,5,11,14,17,19,25,26,26,26,0
palette1 BYTE 4,4,5,5,11,11,14,14,0
      IF dev
      SKIP -$ AND &FF
      END
m
      IF $ AND &FF
   !! error align 
      END
psg   WORD &0201:WORD &0407:WORD &0606:BYTE 0,&38,&10,&10,&10
      WORD &20:BYTE &0A

      SKIP -$ AND &FF
sin   SKIP &0100
