// box assert, demo
// sam westerlund
// Graffathon 2024, 7.6.2024


const offset = 0
const bpm = 128
const bps = bpm / 60
const unit = 160

audioPlayer = document.querySelector('#song')
audioPlayer.currentTime = offset / bps

function draw() {
    const demoTime = getTime() * bps + offset


    if (demoTime === offset) {
        instructionsScene(demoTime,0)
	} else if (demoTime < 4) {
		instructionsFadeOutScene(demoTime, 0)

	} else if (demoTime < 8) {
		blackScene(demoTime, 0)

    } else if (demoTime < 16+8) {
		squareScene(demoTime, 0+8)

	} else if (demoTime < 24+8) {
		verticalSquadScene(demoTime, 16+8)

	} else if (demoTime < 24+4+8) {
		horizontalSquadScene(demoTime, 24+8)

	} else if (demoTime < 24+8+8) {
		squadZoomScene(demoTime, 24+4+8)

    } else if (demoTime < 24+16+8) {
		horizontalMarchingScene(demoTime, 16+16+8)

    } else if (demoTime < 32+16+8) {
        verticalMarchingScene(demoTime, 24+16+8)

    } else if (demoTime < 56+8) {
		chessboardScene(demoTime, 48+8)

    } else if (demoTime < 64+8) {
        inverseChessboardScene(demoTime, 56+8)

    } else if (demoTime < 72+8) {
        chessboardFadeOutScene(demoTime, 64+8)

	} else if (demoTime < 80+8) {
		squareFadeOutScene(demoTime, 72+8)

	} else if (demoTime < 88+8) {
		firstBoxFlashScene(demoTime, 80+8)
	
	} else if (demoTime < 96+8) {
		secondBoxFlashScene(demoTime, 88+8)

	} else if (demoTime < 104+8) {
		boxScene(demoTime, 96+8)

	} else if (demoTime < 112+8) {
		rotatingBoxScene(demoTime, 104+8)

	} else if (demoTime < 120+8) {
		marchingBoxesScene(demoTime, 112+8)

	} else if (demoTime < 132) {
		firstSpinningBoxesScene(demoTime, 128)

	} else if (demoTime < 136) {
		secondSpinningBoxesScene(demoTime, 132)
	
	} else if (demoTime < 140) {
		thirdSpinningBoxesScene(demoTime, 136)

	} else if (demoTime < 144) {
		fourthSpinningBoxesScene(demoTime, 140)

	} else if (demoTime < 140+8) {
		stillScene(demoTime, 136+8)
	
	} else if (demoTime < 148+8) {
		vanishingScene(demoTime, 140+8)
	
	} else if (demoTime < 160) {
		blackScene(demoTime, 156)

	} else {
        endDemo()

    }
}


function instructionsScene(sceneTime, startTime) {
	background(0);

	_text.fill(255);
	image(_text, -width/2, -height/2)
}

function instructionsFadeOutScene(sceneTime, startTime) {
    const time = sceneTime - startTime
	const fade = map(time,0,4,0,1)

	background(0);

	image(_text, -width/2, -height/2)

	resetMatrix()
	translate(0,0,1)
	noStroke()
	fill(0,0,0,fade)
	plane(1920,1080)
}


function blackScene(sceneTime, startTime) {
	background(0);
}


function squareScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(100)

	if (time < 3.5) {
		background(0,0,0) // black
		ambientLight(25, 9, 100) // white
	} else if (time < 4) {
		background(184,100,36) // blue
		ambientLight(61, 8, 96) // white
	} else if (time < 8) {
		background(83,60,50) // green
		ambientLight(61, 8, 96) // white
	} else if (time < 11.5) {
		background(83,60,50) // green
	} else if (time < 12) {
		background(184,100,36) // blue
	} else {
		background(0,0,0) // black
	}

	if (time < 8) {
		resetMatrix()
		translate(0,0,unit/2)
    	plane(unit)
	}
}


function verticalSquadScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()

	ambientLight(61, 8, 96) // white

	if (time < 3.5) {
		background(330,60,50) // pink
	} else if (time < 4) {
		background(184,100,36) // blue
	} else if (time < 8) {
		background(83,60,50) // green
	}


	if (time >= 0.5) {
		resetMatrix()
		translate(0,2*unit, unit/2)
		plane(unit)
	}
	
	if (time >= 1.25) {
		resetMatrix()
		translate(0,0, unit/2)
		plane(unit)
	}

	if (time >= 2) {
		resetMatrix()
		translate(0,-2*unit, unit/2)
		plane(unit)
	}
}


function horizontalSquadScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()

	if (time < 3.5) {
		background(350, 60, 50) // red
		ambientLight(61, 8, 96) // white
	} else if (time < 4) {
		background(184,100,36) // blue
		ambientLight(350, 60, 50) // red
	} else if (time < 8) {
		background(40,50,50) // sand
		ambientLight(0,0,0) // black
	}


	if (time >= 1.5) {
		resetMatrix()
		translate(-2*unit,0, unit/2)
		plane(unit)
	}
	
	if (time >= 2) {
		resetMatrix()
		translate(0,0, unit/2)
		plane(unit)
	}

	if (time >= 2.5) {
		resetMatrix()
		translate(2*unit,0, unit/2)
		plane(unit)
	}
}


function squadZoomScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	fill(0)
	noStroke()
	background(40,50,50) // sand

	for (let x = -1; x <= 1; x++) {
		resetMatrix()
		if (time >= 2) {
			let scaleFactor = map(time,2,4,1,6)
			scale(scaleFactor)
		}
		translate(x*2*unit,0,unit/2)
		plane(unit)
	}
}

function horizontalMarchingScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(100)

	background(0)
	ambientLight(61, 8, 96) // white

	const posOffset = (8-time) / 8 * 10

	// first row
	for (let x = -2; x <= 2; x++) {
		let pos_x = (x * 2 + posOffset) * unit
		resetMatrix()
		translate(pos_x, -2 * unit,unit/2)
		plane(unit);
	}

	// second row
	for (let x = -2; x <= 2; x++) {
		let pos_x = (x * 2 - posOffset) * unit
		resetMatrix()
		translate(pos_x,0,unit/2)
		plane(unit);
	}

	// third row
	for (let x = -2; x <= 2; x++) {
		let pos_x = (x * 2 + posOffset) * unit
		resetMatrix()
		translate(pos_x, 2 * unit,unit/2)
		plane(unit);
	}
}



function verticalMarchingScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()

	background(0)
	ambientLight(61, 8, 96) // white

	const posOffset = (8-time) / 8 * 7

	// previous squares
	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			plane(unit);
		}
	}

	// downward
	for (let x = -1; x <= 1; x++) {
		for (let y = -1.5; y <= 1.5; y++) {
			let pos_y = (2*y - posOffset) * unit
			let pos_x = map(x, -1, 1, -5 * unit, 3 *unit)
			resetMatrix()
			translate(pos_x, pos_y, unit/2)
			plane(unit);
		}
	}

	// upward
	for (let x = -1; x <= 1; x++) {
		for (let y = -1.5; y <= 1.5; y++) {
			let pos_y = (2*y + posOffset) * unit
			let pos_x = map(x, -1, 1, -3 * unit, 5 *unit)
			resetMatrix()
			translate(pos_x, pos_y, unit/2)
			plane(unit);
		}
	}
}


function chessboardScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(100)

	background(0,0,0) // black
	ambientLight(61, 8, 96) // white

	const bump = map(time - Math.floor(time),0,1,-HALF_PI, HALF_PI)
	const angleSmall = map(sin(bump),-1,1,0,HALF_PI)

	const angleBig = -map(time,0,8,0,HALF_PI)

	// previous squares
	for (let x = -3; x <= 3; x++) {
		for (let y = -3; y <= 3; y++) {
			resetMatrix()
			rotate(angleBig)
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			rotate(angleSmall)
			plane(unit);
		}
	}

	for (let x = -2.5; x <= 2.5; x++) {
		for (let y = -2.5; y <= 2.5; y++) {
			resetMatrix()
			rotate(angleBig)
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			rotate(angleSmall)
			plane(unit);
		}
	}
}


function inverseChessboardScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(100)

	background(61, 8, 96) // white
	ambientLight(0)

	const bump = map(time - Math.floor(time),0,1,-HALF_PI, HALF_PI)
	const angleSmall = map(sin(bump),-1,1,0,HALF_PI)

	const angleBig = -map(time,0,8,0,HALF_PI)

	// previous squares
	for (let x = -3; x <= 3; x++) {
		for (let y = -2.5; y <= 2.5; y++) {
			resetMatrix()
			rotate(angleBig)
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			rotate(angleSmall)
			plane(unit);
		}
	}

	for (let x = -2.5; x <= 2.5; x++) {
		for (let y = -3; y <= 3; y++) {
			resetMatrix()
			rotate(angleBig)
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			rotate(angleSmall)
			plane(unit);
		}
	}
}


function chessboardFadeOutScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(61, 8, 96) // white

	const fade = map(time,0,8,100,0)
	background(0,0,0)
	ambientLight(fade)

	// previous squares
	for (let x = -3; x <= 3; x++) {
		for (let y = -2; y <= 2; y++) {
			if (x===0 && y===0) {
				continue
			}
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			plane(unit);
		}
	}

	for (let x = -2.5; x <= 2.5; x++) {
		for (let y = -3.5; y <= 3.5; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			plane(unit);
		}
	}

	ambientLight(100-fade)

	resetMatrix()
	translate(0,0, unit/2)
	plane(unit);
}


function squareFadeOutScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(61, 8, 96) // white

	const fade = map(time,0,8,100,0)
	background(0,0,0)
	ambientLight(fade)

	console.log("fade", fade)

	resetMatrix()
	translate(0,0, unit/2)
	plane(unit);
}


function firstBoxFlashScene(sceneTime, startTime) {
	const time = sceneTime - startTime
	// 1 0 0 to the right
	// 0 1 0 downward
	// 0 0 1 forwards

  	//directionalLight(340, 100, 10, -1,1,0) // purple

	fill(0, 100, 100) // actually white
	noStroke()

	background(0);
	ambientLight(0);

	const flashTime = 0.3

	if (time >= 1) {
		const fade = map(time, 1, 1+flashTime, 1, 0)
		pointLight(184,100, 36*fade, -3*unit, -unit,0 ) // blue
	}
	
	if (time >= 1.333) {
		const fade = map(time, 1.333, 1.333+flashTime, 1, 0)
		pointLight(350, 60, 50*fade, 3*unit, unit,0) // red
	}
	
	if (time >= 1.666) {
		const fade = map(time, 1.666, 1.666+flashTime, 1, 0)
		pointLight(83,60,50*fade, -3*unit, unit,0) // green
	}
	
	if (time >= 2) {
		const fade = map(time, 2, 2+flashTime, 1, 0)
		pointLight(330,60,50*fade, 3*unit, -unit,0) // pink
	}

	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit)
			let order = (y+2) * 5 + x+2
			//rotateX(angle)
			//rotateY(angle)
			box(unit);
		}
	}
}


function secondBoxFlashScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	// 1 0 0 to the right
	// 0 1 0 downward
	// 0 0 1 forwards

  	//directionalLight(340, 100, 10, -1,1,0) // purple

	fill(0, 100, 100) // actually white
	noStroke()

	background(0);
	ambientLight(0);

	const flashTime = 0.2

	if (time >= 1) {
		const fade = map(time, 1, 1+flashTime, 1, 0)
		pointLight(83,60,50*fade, -3*unit, unit,0) // green
	}
	
	if (time >= 1.25) {
		const fade = map(time, 1.25, 1.25+flashTime, 1, 0)
		pointLight(330,60,50*fade, 3*unit, -unit,0) // pink
	}
	
	if (time >= 1.5) {
		const fade = map(time, 1.5, 1.5+flashTime, 1, 0)
		pointLight(184,100, 36*fade, -3*unit, -unit,0 ) // blue
	}

	if (time >= 1.75) {
		const fade = map(time, 1.75, 1.75+flashTime, 1, 0)
		pointLight(350, 60, 50*fade, 3*unit, unit,0) // red
	}
	
	if (time >= 2) {
		const fade = map(time, 2, 2+flashTime, 1, 0)
		pointLight(61, 8, 96 *fade, 4*unit, 0,0)
	}

	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit)
			box(unit);
		}
	}
}


function boxScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	const angle = map(time,0,8, -0.25, 0.25)
	const pos = (time-4 + 0.5) * unit

	fill(0, 100, 100) // actually white
	noStroke()

	background(0);
	ambientLight(0);
	pointLight(61, 8, 96, 0,0,pos) // white

	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit)
			rotateX(angle)
			rotateY(angle)
			box(unit);
		}
	}
}


function rotatingBoxScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	const angle = map(time,0,8,0.25,0.75) ;
	const pos = 4.5 * unit
	
	const angleBig = map(time,0,8,0,HALF_PI)

	fill(0, 100, 100) // white
	noStroke()

	background(0);
	ambientLight(0);
	pointLight(61, 8, 96, 0,0,pos) // white

	for (let x = -1; x <= 1; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			rotateY(angleBig)
			translate(4 * x * unit, y * 2 * unit)
			rotateX(angle)
			rotateY(angle)
			box(unit);
		}
	}

	for (let x = -0.5; x <= 0.5; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			rotateY(-angleBig)
			translate(x * 4 * unit, y * 2 * unit)
			rotateX(angle)
			rotateY(angle)
			box(unit);
		}
	}
}


function marchingBoxesScene(sceneTime, startTime) {
	const time = sceneTime - startTime


	//ambientLight(184,100, 36*fade) // blue
	//ambientLight(350, 60, 50*fade) // red
	//ambientLight( 83, 60, 50*fade) // green
	//ambientLight(330, 60, 50*fade) // pink

	//background(184,100, 36) // blue
	//background(350, 60, 50) // red
	//background( 83, 60, 50) // green
	//background(330, 60, 50) // pink

	const angleFast = map(time,0,1,0, HALF_PI)
	const pos = 4.5 * unit

	fill(0, 100, 100) // actually white
	noStroke()

	const fade = 0.2
	if (time < 1) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 2) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 3) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else if (time < 4) {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	} else if (time < 5) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 6) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 7) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	}

	directionalLight(61, 8, 96,0,0,-1)

	const posOffset = (8-time) / 8 * 10

	// first row horizontal
	for (let x = -2; x <= 2; x++) {
		let pos_x = (x * 2 - posOffset) * unit
		resetMatrix()
		translate(pos_x, -2 * unit)
		rotateX(angleFast)
		rotateY(angleFast)
		box(unit);
	}

	for (let x = -2; x <= 2; x++) {
		let pos_x = (x * 2 + posOffset) * unit
		resetMatrix()
		translate(pos_x, 0)
		rotateX(angleFast)
		rotateY(angleFast)
		box(unit);
	}

	for (let x = -2; x <= 2; x++) {
		let pos_x = (x * 2 - posOffset) * unit
		resetMatrix()
		translate(pos_x, 2 * unit)
		rotateX(angleFast)
		rotateY(angleFast)
		box(unit);
	}
}


function firstSpinningBoxesScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	const bump = map(time - Math.floor(time),0,1,-HALF_PI, HALF_PI)
	const angleSmall = map(sin(bump),-1,1,0,HALF_PI)

	fill(0, 100, 100) // white
	noStroke()

	const fade = 0.2
	if (time < 1) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 2) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 3) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else if (time < 4) {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	} else if (time < 5) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 6) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 7) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	}

	directionalLight(61, 8, 96,0,0,-1)

	// previous squares
	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit)
			rotateZ(angleSmall)
			box(unit);
		}
	}
}


function secondSpinningBoxesScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	const bump = map(time - Math.floor(time),0,1,-HALF_PI, HALF_PI)
	const angleSmall = map(sin(bump),-1,1,0,HALF_PI)

	fill(0, 100, 100) // white
	noStroke()

	const fade = 0.2
	if (time < 1) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 2) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 3) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else if (time < 4) {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	} else if (time < 5) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 6) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 7) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	}

	directionalLight(61, 8, 96,0,0,-1)

	const posOffset = map(time,0,4,0,7)

	// downward
	for (let x = -1; x <= 1; x++) {
		for (let y = -1; y <= 1; y++) {
			let pos_y = (2*y - posOffset) * unit
			let pos_x = x * 4 * unit
			resetMatrix()
			translate(pos_x, pos_y, 0)
			rotateZ(angleSmall)
			box(unit);
		}
	}

	// upward
	for (let x = -0.5; x <= 0.5; x++) {
		for (let y = -1; y <= 1; y++) {
			let pos_y = (2*y + posOffset) * unit
			let pos_x = x * 4 * unit
			resetMatrix()
			translate(pos_x, pos_y, 0)
			rotateZ(angleSmall)
			box(unit);
		}
	}
}


function thirdSpinningBoxesScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	const angleFast = map(time,0,1,0, HALF_PI)
	
	const angleBig = map(time,0,8,0, TWO_PI)

	fill(0, 100, 100) // actually white
	noStroke()

	const fade = 0.2
	if (time < 1) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 2) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 3) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else if (time < 4) {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	}

	directionalLight(61, 8, 96,0,0,-1)

	// previous squares
	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			rotateY(angleBig)
			translate(x * 2 * unit, y * 2 * unit)
			rotateX(angleFast)
			rotateY(angleFast)
			box(unit);
		}
	}
}


function fourthSpinningBoxesScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	const angleFast = map(time,0,1,0, HALF_PI)
	
	const angleBig = map(time,0,4,0, TWO_PI)

	fill(0, 100, 100) // actually white
	noStroke()

	const fade = 0.2
	if (time < 1) {
		background(184,100, 36) // blue
		ambientLight(184,100, 36*fade) // blue
	} else if (time < 2) {
		background(350, 60, 50) // red
		ambientLight(350, 60, 50*fade) // red
	} else if (time < 3) {
		background( 83, 60, 50) // green
		ambientLight( 83, 60, 50*fade) // gree
	} else if (time < 4) {
		background(330, 60, 50) // pink
		ambientLight(330, 60, 50*fade) // pink
	}

	directionalLight(61, 8, 96,0,0,-1)

	// previous squares
	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			rotateY(angleBig)
			translate(x * 2 * unit, y * 2 * unit)
			rotateX(angleFast)
			rotateY(angleFast)
			box(unit);
		}
	}
}


function stillScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()
	fill(100)

	background(0)
	ambientLight(61, 8, 96)

	// previous squares
	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			plane(unit);
		}
	}
}


function vanishingScene(sceneTime, startTime) {
	const time = sceneTime - startTime

	noStroke()

	background(0)
	ambientLight(61, 8, 96)

	// previous squares
	for (let x = -2; x <= 2; x++) {
		for (let y = -1; y <= 1; y++) {
			resetMatrix()
			const dist = sq(x) + sq(y)
			const fade = map(time + dist, 5,8,100, 0)
			fill(fade)
			translate(x * 2 * unit, y * 2 * unit, unit/2)
			plane(unit);
		}
	}
}