#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;
out vec2 PosXY;

void main() {
    TexCoords = aTexCoords;
    PosXY = vec2(aPos.x, aPos.y);
    gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}  

#type fragment
#version 330 core
layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 BrightColor;

in vec2 TexCoords;
in vec2 PosXY;

uniform sampler2D screenTexture[2];
uniform float near_plane;
uniform float far_plane;
uniform float t;

#define M_PI 3.141592654

void main() {
vec4 col = texture(screenTexture[0], TexCoords).rgba;
float depth = texture(screenTexture[1], TexCoords).r;

depth += 0.1;

float frequency = 60;
float lineCount = 50;
float lineWidth = 0.01 + pow(depth, 2); // From 0 to 1
float amplitude = 2;

if (sin(amplitude*sin(frequency*PosXY.x) + lineCount*M_PI*PosXY.y) > 2.0*lineWidth - 1) {
discard;
}

FragColor = vec4(depth, depth, depth, 1.0);
BrightColor = vec4(depth, depth, depth, 1.0);
}