#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

void main (void)
{
    TexCoords = aTexCoords;
    gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}

#type fragment
#version 330 core
// This shader outputs to 2 color attachments
layout (location = 0) out vec4 fragColor;
layout (location = 1) out vec4 brightColor;

in vec2 TexCoords;
uniform sampler2D screenOne[1];
uniform sampler2D screenTwo[1];
uniform sampler2D referenceTexture;

void main ()
{
  vec2 uv = TexCoords.xy;
  vec4 colorOne = texture(screenOne[0], uv.xy);
  vec4 colorTwo = texture(screenTwo[0], uv.xy);
  float gray = texture(referenceTexture, uv.xy).r;

  vec4 color = mix(colorOne, colorTwo, gray);

  fragColor = color;

  float brightness = dot(color.xyz, vec3(0, 1, 0));//vec3(0.1126, 0.1152, 0.0722));
  if(brightness > 0.6)
      brightColor = vec4(color.xyz, 1.0);
  else
      brightColor = vec4(0.0, 0.0, 0.0, 1.0);
}