#type vertex
#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main() {
TexCoords = aTexCoords;    
gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}

#type fragment
#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

// General parameters
uniform float aspect;
uniform float t;

// Position
uniform vec2 pos;

// Geometry
uniform float radius;
uniform float gaze;

// Colors
uniform vec3 topColor;
uniform vec3 bottomColor;

float sun(vec2 uv) {
    float r = radius;
    float val = smoothstep(r, r-0.01, length(uv));
    float bloom = smoothstep(1.0, 0.0, length(uv));
    float cut = 5.0 * sin((uv.y + t * 0.2 * (1.02)) * 60.0) + clamp((uv.y+0.15) * 10.0, -6.0, 6.0);
    cut = clamp(cut, 0.0, 1.0);
    return clamp(val * cut, 0.0, 1.0) + bloom * gaze;
}

void main() {
    vec2 uv = vec2(aspect*(2.0*TexCoords.x-1), 2.0*TexCoords.y-1);

uv.x -= pos.x;
uv.y -= pos.y;

    vec3 col = bottomColor;
    col = mix(col, topColor, uv.y * 2.0 + 0.2);
    col = mix(vec3(0.0, 0.0, 0.0), col, sun(uv));

    FragColor = vec4(col, 1.0);    
}
