#type vertex
#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexCoords;

out VS_OUT {
  vec3 FragPos;
  vec3 Normal;
  vec2 TexCoords;
} vs_out;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main() {
	vs_out.FragPos = vec3(model * vec4(aPos, 1.0));
	vs_out.Normal = aNormal;
	vs_out.TexCoords = aTexCoords;
	
	gl_Position = projection * view * vec4(vs_out.FragPos, 1.0);
}

#type fragment
#version 330 core
layout (location = 0) out vec4 FragColor;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fs_in;

// Object material Difusse color
uniform vec3  Mat_Kd;
uniform vec3  Mat_Ka;
uniform vec3  Mat_Ks;
uniform float Mat_KsStrenght;

uniform vec3 viewPos;

uniform vec3 light1Pos;
uniform vec3 light1Color;

uniform vec3 light2Pos;
uniform vec3 light2Color;

uniform float blinn_exponent_1;
uniform float blinn_exponent_2;

//	Simplex 3D Noise 
//	by Ian McEwan, Ashima Arts
//
vec4 permute(vec4 x){return mod(((x*34.0)+1.0)*x, 289.0);}
vec4 taylorInvSqrt(vec4 r){return 1.79284291400159 - 0.85373472095314 * r;}

float snoise(vec3 v){ 
  const vec2  C = vec2(1.0/6.0, 1.0/3.0) ;
  const vec4  D = vec4(0.0, 0.5, 1.0, 2.0);

// First corner
  vec3 i  = floor(v + dot(v, C.yyy) );
  vec3 x0 =   v - i + dot(i, C.xxx) ;

// Other corners
  vec3 g = step(x0.yzx, x0.xyz);
  vec3 l = 1.0 - g;
  vec3 i1 = min( g.xyz, l.zxy );
  vec3 i2 = max( g.xyz, l.zxy );

  //  x0 = x0 - 0. + 0.0 * C 
  vec3 x1 = x0 - i1 + 1.0 * C.xxx;
  vec3 x2 = x0 - i2 + 2.0 * C.xxx;
  vec3 x3 = x0 - 1. + 3.0 * C.xxx;

// Permutations
  i = mod(i, 289.0 ); 
  vec4 p = permute( permute( permute( 
             i.z + vec4(0.0, i1.z, i2.z, 1.0 ))
           + i.y + vec4(0.0, i1.y, i2.y, 1.0 )) 
           + i.x + vec4(0.0, i1.x, i2.x, 1.0 ));

// Gradients
// ( N*N points uniformly over a square, mapped onto an octahedron.)
  float n_ = 1.0/7.0; // N=7
  vec3  ns = n_ * D.wyz - D.xzx;

  vec4 j = p - 49.0 * floor(p * ns.z *ns.z);  //  mod(p,N*N)

  vec4 x_ = floor(j * ns.z);
  vec4 y_ = floor(j - 7.0 * x_ );    // mod(j,N)

  vec4 x = x_ *ns.x + ns.yyyy;
  vec4 y = y_ *ns.x + ns.yyyy;
  vec4 h = 1.0 - abs(x) - abs(y);

  vec4 b0 = vec4( x.xy, y.xy );
  vec4 b1 = vec4( x.zw, y.zw );

  vec4 s0 = floor(b0)*2.0 + 1.0;
  vec4 s1 = floor(b1)*2.0 + 1.0;
  vec4 sh = -step(h, vec4(0.0));

  vec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  vec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;

  vec3 p0 = vec3(a0.xy,h.x);
  vec3 p1 = vec3(a0.zw,h.y);
  vec3 p2 = vec3(a1.xy,h.z);
  vec3 p3 = vec3(a1.zw,h.w);

//Normalise gradients
  vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;

// Mix final noise value
  vec4 m = max(0.6 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
  m = m * m;
  return 42.0 * dot( m*m, vec4( dot(p0,x0), dot(p1,x1), 
                                dot(p2,x2), dot(p3,x3) ) );
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}



void main()
{
	vec3 color = Mat_Kd;

    // ambient
    vec3 ambient = 0.0 * color;

    // diffuse
    vec3 normal = normalize(fs_in.Normal);

    vec3 light1Dir = normalize(light1Pos - fs_in.FragPos);
    vec3 light2Dir = normalize(light2Pos - fs_in.FragPos);

    float diff1 = max(dot(light1Dir, normal), 0.0);
    float diff2 = max(dot(light2Dir, normal), 0.0);

    // granulus
    vec3 granulus = normalize(fs_in.FragPos);

    vec3 diffuse = (diff1 + diff2 ) * color - 0.4*granulus.yyy - 0.1*sin(fs_in.FragPos.y);
    diffuse = diffuse + 0.1*snoise(0.09*fs_in.FragPos);

    // specular
    vec3 viewDir = normalize(viewPos - fs_in.FragPos);

    vec3 reflectDir1 = reflect(-light1Dir, normal);
    vec3 reflectDir2 = reflect(-light2Dir, normal);

    vec3 specular1 = light1Color * pow(max(dot(viewDir, reflectDir1), 0.0), blinn_exponent_1);
    vec3 specular2 = light2Color * pow(max(dot(viewDir, reflectDir2), 0.0), blinn_exponent_2);

    vec3 specular = specular1 + specular2; // Assuming white light

    FragColor = vec4(ambient + diffuse + specular, 1.0);
}