width equ 1920
height equ 1080
col equ 0x0000FFFF
maximum equ 10800
startpos_x equ 0x3a
startpos_y equ 0x20

bits 32
org $00010000
  db $7F,"ELF"
  dd 1
  dd 0
  dd $$
  dw 2
  dw 3
  dd entry
  dd entry
  dd 4
fname:
  db "/dev/fb0",0

entry:
  mov ebx,fname
  inc ecx
  mov al,5
  int 0x80

allocate:
  mov eax, 0x2d
  int 0x80
  push eax		; Framebuffer Base
  xchg eax,ebx
  add ebx, 0x8000000
  mov eax, 0x2d
  int 0x80
  mov eax, width*height*4
  push eax		; Framebuffer Size

ant_init:
  mov edi, startpos_x	; Ant x
  mov esi, startpos_y 	; Ant y
  mov eax, 1
  push eax		; Ant Direction

col_init:
  mov ecx,[esp+0x04]	; Framebuffer Size
  shr ecx,2
  mov eax,[esp+0x08]	; Framebuffer Base
col_init_loop:
  mov [eax+ecx*4],dword col
  loop col_init_loop

mainloop:
  mov ecx, [esp+0x04]	; Framebuffer Size
  shr ecx, 2
  inc ebp
  push ebp

setpixels:
  mov ebx, width
  mov eax, ecx
  cdq
  div ebx
  shr edx, 4	; x
  shr eax, 4	; y
  cmp edx, edi
  jne skip_invert
  cmp eax, esi
  jne skip_invert

invert:
  mov ebx,[esp+0x0C]	; Framebuffer Base
  not dword [ebx+ecx*4]
  mov ebp, [ebx+ecx*4]
skip_invert:
  loop setpixels

  ; Turn
  mov ebx,[esp + 0x04]	; Ant Direction
  cmp ebp,col
  jne turn_positive
  dec ebx
  jmp turn_done
turn_positive:
  inc ebx
turn_done:
  and ebx,3
  mov [esp + 0x04],ebx	; Ant Direction

  ; Move
  cmp ebx, 0
  je move_up
  cmp ebx, 1
  je move_right
  cmp ebx, 2
  je move_down
move_left:
  dec edi
  jmp move_done
move_up:
  inc esi
  jmp move_done
move_right:
  inc edi
  jmp move_done
move_down:
  dec esi
move_done:

  ; Flush
  mov ecx, [esp+0x0C]	; Framebuffer Base EDI
  mov edx, [esp+0x08]	; Framebuffer Size EDI
  push edi
  push esi
  xor esi,esi
  xor edi,edi
  mov ebx,3
  mov eax,0xb5
  int 0x80
  pop esi
  pop edi
  pop ebp
  cmp ebp, maximum
  jne mainloop
;  hlt
  xor eax,eax
  xor ebx,ebx
  int 0x80
