#ifndef MESH_H
#define MESH_H

#include "cglm/types.h"
#include "cgltf.h"
#include "gl.h"
#include "material.h"
#include "shader.h"

typedef struct {
    GLenum mode;
    GLsizei count;
    GLenum index_type;
} draw_param_t;

typedef struct {
    GLuint *vaos;              // OpenGL VAO cache of glTF mesh primitives
    draw_param_t *draw_params; // Maps to glTF mesh primitives
    size_t *materials;         // Material indices of primitives
    size_t primitives_count;
    // Structure of Arrays
} mesh_t;

typedef struct node_t_ {
    int is_root;
    size_t parent;
    size_t *children;
    size_t children_count;
    mat4 matrix;
    size_t mesh;
} node_t;

typedef struct {
    GLuint *buffers;      // OpenGL buffer object cache of of glTF buffer views
                          // (vertices and indices). Value 0 means not loaded.
    size_t buffers_count; // Buffer view 0 is 0, buffer view 3 is 3, and so on
                          // should equal to data->buffer_views_count
} buffer_cache_t;

typedef struct {
    buffer_cache_t buffers;
    GLuint *images;
    size_t images_count;
    material_t *materials;
    size_t materials_count;
    mesh_t *meshes;
    size_t meshes_count;
    node_t *nodes;
    size_t nodes_count;
    size_t *parent_nodes;
    size_t parent_nodes_count;
} scene_t;

void mesh_draw(const mesh_t *mesh, const scene_t *scene,
               const program_t *program);
scene_t *scene_init_gltf(const char *path);
void scene_deinit(scene_t *scene);
void scene_draw(const scene_t *scene, const program_t *program);

#endif
