#ifndef CONFIG_H
#define CONFIG_H

// This header file is mostly referenced by main.c, demo.c and shader.c.
// Contains demo's configuration values such as resolution and music BPM.

#define WIDTH 800
#define HEIGHT 600
#define RESOLUTION_SCALE 1
#define BEATS_PER_MINUTE 100
#define ROWS_PER_BEAT 8.

// The default HDR pixel format for framebuffers
#define HDR_INTERNALFORMAT GL_R11F_G11F_B10F

// A RGBA noise texture is generated for every frame. It's pixel count is this
// value squared. This value affects required CPU->GPU bandwidth per frame.
#define NOISE_SIZE 128

// Bloom uses mipmaps to improve area of effect without huge computational cost
// This value determines how many mip levels are used
#define BLOOM_LEVELS 6
// This is resolution scale for base bloom level 0, other levels get scaled down
// from here
#define BLOOM_RESOLUTION_SCALE 2

// GLSL_VERSION is prefixed to every shader, change it if you need some other
// version than specified here.
#ifdef GLES
#define GLSL_VERSION "#version 300 es\n"
#else
#define GLSL_VERSION "#version 330 core\n"
#endif

#endif
