// VC³ 2023 'The Starry Night of Christmas'
//
// Author:   Erik Hooijmeijer / ctrl-alt-dev.nl
// Category: Christmas Challenge
// System:   Unexpanded VIC-20
// Language: Assembler, homegrown
// Description: 
//     Prints the pattern using the formula ((x % 6 == y % 6) || ((x + y) % 6 == 0))
//     Uses standard kernal routines to render the output.
//     Mod 6 is calculated by substracting 6 repeatedly.

tmp = $69  // temporary storage, basic floating point area. 

$1000  db $00,$0c,$10,$01,$00,$9e,$20,$34,$31,$31,$32,$00,$00,$00,$00,$00   // basic loader

start: LDY #$00
~2:    LDX #$03
~1:    JSR calc
       JSR $F27A
       INX
       CPX #$16
       BNE ~1
       LDA #$0D
       JSR $F27A
       INY
       CPY #$13
       BNE ~2
       RTS
       
calc:  TYA          // x%6 = y%6
       JSR mod6
       STA tmp
       TXA
       JSR mod6
       CMP tmp
       BNE xply
       LDA #$2A
       RTS

xply:  TYA         // (x+y)%6 = 0
       STA tmp
       TXA
       CLC
       ADC tmp
       JSR mod6
       CMP #$00
       BNE ~1
       LDA #$2A
       RTS
~1:    LDA #$20
       RTS

mod6:  CMP #$06   // MOD 6 using A
       BCC ~2
       SEC
       SBC #$06
       BCS mod6 
~2:    RTS

