; LOKIKER XMAS 23
;
; 6510 Assembler for Commodore C=64
;
; Sven Bastrop / TGS


*=$0801
BASIC                 ;23 SYS2061
!byte $0b,$08,$17,$00,$9e,$32,$30,$36,$31,$00,$00,$00

ASM                   ;Start ML $080d
    lda #$db          
    sta $0e           ;set first LOW screen center position, HIGH was already set by OS
    sta 3             ;set col loop %11011011
    
lc  lax #$2a          ;* for print out
    sbx #$1f          ;loop for pos_offset ($2a-$1f=$0b and also cleared carr flag)
    
lo  ldy pos_offset,x  ;get 12 screen offset positions
    sta ($0e),y       ;print * at screencpos+pos_offset
    dex
    bpl lo            ;end loop pos_offset

    tya               ;set new screen_pos for next col (+$f9)
    
    adc $0e           ;Carry flag was already cleared
    sta $0e
    lsr $03
    bcs lc            ;end loop cols

    adc #$02          ;set new screen pos for next row
    sta $0e
    inc $0f
    dec $9a           ;initial value 3 was set by OS
    bne lc            ;end loop rows

    rts               ;JPM into endless NMI-IRQ loop

pos_offset
!byte $f9,$30,$32,$57,$5b,$7e,$84,$a7,$ab,$d0,$d2
!byte $09             ;End ML $083e