layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;
layout (location = 2) out float v_time;
layout (location = 3) out vec3 v_vertex_camera_pos;
layout (location = 4) out vec3 v_light_camera_pos;
layout (location = 5) out vec3 v_tangent;
layout (location = 6) out vec3 v_vertex_world_pos;
layout (location = 7) out vec3 v_normal_world;
layout (location = 8) out vec3 v_tangent_world;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    float g_app_time;
    float extrude;
    float g_instance_count;
    vec4 A;
    vec3 light_position;
    vec3 pos_offset;
    vec3 rotp;
};

struct Point {
    vec4 pos;
    vec4 normal;
    vec4 tangent;
};

layout (set = 0, binding = 1) buffer Attractor {
    Point points[];
} attractor;

void main() {
    float coverage = A.x;
    float scale = A.y;

    vec3 pos = a_position;

    float id = (pos.y + 1) * 0.5 * coverage; //gl_InstanceIndex / g_instance_count * coverage;
    v_time = id;

    int attractor_index = int(100000  * id);
    Point p = attractor.points[attractor_index];

    vec3 normal = p.normal.xyz;
    vec3 tangent = p.tangent.xyz;
    vec3 binormal = cross(normal, tangent);
    mat3 rot_mat = mat3(normal, tangent, binormal);
//    mat3 rot_mat = mat3(normal, binormal, tangent);
//    mat3 n_rot_mat = inverse(rot_mat);

    vec3 local_pos = normalize(vec3(pos.x, 0, pos.z));
    vec3 new_local_pos = rot_mat * local_pos;
    vec3 new_pos = p.pos.xyz * scale + new_local_pos * extrude  + pos_offset * A.y;
    mat3 rotpm = mat3(rotate(rotp));
    new_pos = rotpm * new_pos;
    vec3 new_normal = rotpm * -new_local_pos;
    gl_Position = g_projection_from_model * vec4(new_pos, 1.0);
    v_uv = a_uv;

    // camera space
    v_normal = mat3(g_camera_from_model) * new_normal;
    v_vertex_camera_pos = (g_camera_from_model * vec4(new_pos, 1.0)).xyz;
    v_tangent = mat3(g_camera_from_model) * tangent;
    v_light_camera_pos = (g_camera_from_world * vec4(light_position, 1)).xyz;

    // world space
//    v_vertex_world_pos = (g_world_from_model * vec4(new_pos, 1.0)).xyz;
//    v_tangent_world = mat3(g_world_from_model) * tangent;
//    v_normal_world = mat3(g_world_from_model) * new_normal;

    v_vertex_world_pos = new_pos;
    v_tangent_world = tangent;
    v_normal_world = new_normal;
}